/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rtbfabric.model.LinkLogSettings;
import software.amazon.awssdk.services.rtbfabric.model.LinkStatus;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricResponse;
import software.amazon.awssdk.services.rtbfabric.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOutboundExternalLinkResponse
extends RtbFabricResponse
implements ToCopyableBuilder<Builder, GetOutboundExternalLinkResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(GetOutboundExternalLinkResponse.getter(GetOutboundExternalLinkResponse::gatewayId)).setter(GetOutboundExternalLinkResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<String> LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("linkId").getter(GetOutboundExternalLinkResponse.getter(GetOutboundExternalLinkResponse::linkId)).setter(GetOutboundExternalLinkResponse.setter(Builder::linkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetOutboundExternalLinkResponse.getter(GetOutboundExternalLinkResponse::statusAsString)).setter(GetOutboundExternalLinkResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> PUBLIC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicEndpoint").getter(GetOutboundExternalLinkResponse.getter(GetOutboundExternalLinkResponse::publicEndpoint)).setter(GetOutboundExternalLinkResponse.setter(Builder::publicEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicEndpoint").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetOutboundExternalLinkResponse.getter(GetOutboundExternalLinkResponse::createdAt)).setter(GetOutboundExternalLinkResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetOutboundExternalLinkResponse.getter(GetOutboundExternalLinkResponse::updatedAt)).setter(GetOutboundExternalLinkResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetOutboundExternalLinkResponse.getter(GetOutboundExternalLinkResponse::tags)).setter(GetOutboundExternalLinkResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<LinkLogSettings> LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logSettings").getter(GetOutboundExternalLinkResponse.getter(GetOutboundExternalLinkResponse::logSettings)).setter(GetOutboundExternalLinkResponse.setter(Builder::logSettings)).constructor(LinkLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, LINK_ID_FIELD, STATUS_FIELD, PUBLIC_ENDPOINT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD, LOG_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOutboundExternalLinkResponse.memberNameToFieldInitializer();
    private final String gatewayId;
    private final String linkId;
    private final String status;
    private final String publicEndpoint;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Map<String, String> tags;
    private final LinkLogSettings logSettings;

    private GetOutboundExternalLinkResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.linkId = builder.linkId;
        this.status = builder.status;
        this.publicEndpoint = builder.publicEndpoint;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
        this.logSettings = builder.logSettings;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String linkId() {
        return this.linkId;
    }

    public final LinkStatus status() {
        return LinkStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String publicEndpoint() {
        return this.publicEndpoint;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final LinkLogSettings logSettings() {
        return this.logSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutboundExternalLinkResponse)) {
            return false;
        }
        GetOutboundExternalLinkResponse other = (GetOutboundExternalLinkResponse)((Object)obj);
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.linkId(), other.linkId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.publicEndpoint(), other.publicEndpoint()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.logSettings(), other.logSettings());
    }

    public final String toString() {
        return ToString.builder((String)"GetOutboundExternalLinkResponse").add("GatewayId", (Object)this.gatewayId()).add("LinkId", (Object)this.linkId()).add("Status", (Object)this.statusAsString()).add("PublicEndpoint", (Object)this.publicEndpoint()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Tags", this.hasTags() ? this.tags() : null).add("LogSettings", (Object)this.logSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "linkId": {
                return Optional.ofNullable(clazz.cast(this.linkId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "publicEndpoint": {
                return Optional.ofNullable(clazz.cast(this.publicEndpoint()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "logSettings": {
                return Optional.ofNullable(clazz.cast(this.logSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("linkId", LINK_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("publicEndpoint", PUBLIC_ENDPOINT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("logSettings", LOG_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOutboundExternalLinkResponse, T> g) {
        return obj -> g.apply((GetOutboundExternalLinkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricResponse.BuilderImpl
    implements Builder {
        private String gatewayId;
        private String linkId;
        private String status;
        private String publicEndpoint;
        private Instant createdAt;
        private Instant updatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private LinkLogSettings logSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutboundExternalLinkResponse model) {
            super(model);
            this.gatewayId(model.gatewayId);
            this.linkId(model.linkId);
            this.status(model.status);
            this.publicEndpoint(model.publicEndpoint);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.tags(model.tags);
            this.logSettings(model.logSettings);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getLinkId() {
            return this.linkId;
        }

        public final void setLinkId(String linkId) {
            this.linkId = linkId;
        }

        @Override
        public final Builder linkId(String linkId) {
            this.linkId = linkId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LinkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getPublicEndpoint() {
            return this.publicEndpoint;
        }

        public final void setPublicEndpoint(String publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
        }

        @Override
        public final Builder publicEndpoint(String publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final LinkLogSettings.Builder getLogSettings() {
            return this.logSettings != null ? this.logSettings.toBuilder() : null;
        }

        public final void setLogSettings(LinkLogSettings.BuilderImpl logSettings) {
            this.logSettings = logSettings != null ? logSettings.build() : null;
        }

        @Override
        public final Builder logSettings(LinkLogSettings logSettings) {
            this.logSettings = logSettings;
            return this;
        }

        @Override
        public GetOutboundExternalLinkResponse build() {
            return new GetOutboundExternalLinkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOutboundExternalLinkResponse> {
        public Builder gatewayId(String var1);

        public Builder linkId(String var1);

        public Builder status(String var1);

        public Builder status(LinkStatus var1);

        public Builder publicEndpoint(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder logSettings(LinkLogSettings var1);

        default public Builder logSettings(Consumer<LinkLogSettings.Builder> logSettings) {
            return this.logSettings((LinkLogSettings)((LinkLogSettings.Builder)LinkLogSettings.builder().applyMutation(logSettings)).build());
        }
    }
}

