/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rtbfabric.model.FlowModuleNameListCopier;
import software.amazon.awssdk.services.rtbfabric.model.ModuleParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModuleConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModuleConfiguration> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ModuleConfiguration.getter(ModuleConfiguration::version)).setter(ModuleConfiguration.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ModuleConfiguration.getter(ModuleConfiguration::name)).setter(ModuleConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependsOn").getter(ModuleConfiguration.getter(ModuleConfiguration::dependsOn)).setter(ModuleConfiguration.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ModuleParameters> MODULE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("moduleParameters").getter(ModuleConfiguration.getter(ModuleConfiguration::moduleParameters)).setter(ModuleConfiguration.setter(Builder::moduleParameters)).constructor(ModuleParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moduleParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, NAME_FIELD, DEPENDS_ON_FIELD, MODULE_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModuleConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String version;
    private final String name;
    private final List<String> dependsOn;
    private final ModuleParameters moduleParameters;

    private ModuleConfiguration(BuilderImpl builder) {
        this.version = builder.version;
        this.name = builder.name;
        this.dependsOn = builder.dependsOn;
        this.moduleParameters = builder.moduleParameters;
    }

    public final String version() {
        return this.version;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public final List<String> dependsOn() {
        return this.dependsOn;
    }

    public final ModuleParameters moduleParameters() {
        return this.moduleParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOn() ? this.dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.moduleParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleConfiguration)) {
            return false;
        }
        ModuleConfiguration other = (ModuleConfiguration)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.name(), other.name()) && this.hasDependsOn() == other.hasDependsOn() && Objects.equals(this.dependsOn(), other.dependsOn()) && Objects.equals(this.moduleParameters(), other.moduleParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ModuleConfiguration").add("Version", (Object)this.version()).add("Name", (Object)this.name()).add("DependsOn", this.hasDependsOn() ? this.dependsOn() : null).add("ModuleParameters", (Object)this.moduleParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
            case "moduleParameters": {
                return Optional.ofNullable(clazz.cast(this.moduleParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", VERSION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dependsOn", DEPENDS_ON_FIELD);
        map.put("moduleParameters", MODULE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModuleConfiguration, T> g) {
        return obj -> g.apply((ModuleConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private String name;
        private List<String> dependsOn = DefaultSdkAutoConstructList.getInstance();
        private ModuleParameters moduleParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ModuleConfiguration model) {
            this.version(model.version);
            this.name(model.name);
            this.dependsOn(model.dependsOn);
            this.moduleParameters(model.moduleParameters);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getDependsOn() {
            if (this.dependsOn instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dependsOn;
        }

        public final void setDependsOn(Collection<String> dependsOn) {
            this.dependsOn = FlowModuleNameListCopier.copy(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<String> dependsOn) {
            this.dependsOn = FlowModuleNameListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(String ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        public final ModuleParameters.Builder getModuleParameters() {
            return this.moduleParameters != null ? this.moduleParameters.toBuilder() : null;
        }

        public final void setModuleParameters(ModuleParameters.BuilderImpl moduleParameters) {
            this.moduleParameters = moduleParameters != null ? moduleParameters.build() : null;
        }

        @Override
        public final Builder moduleParameters(ModuleParameters moduleParameters) {
            this.moduleParameters = moduleParameters;
            return this;
        }

        public ModuleConfiguration build() {
            return new ModuleConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModuleConfiguration> {
        public Builder version(String var1);

        public Builder name(String var1);

        public Builder dependsOn(Collection<String> var1);

        public Builder dependsOn(String ... var1);

        public Builder moduleParameters(ModuleParameters var1);

        default public Builder moduleParameters(Consumer<ModuleParameters.Builder> moduleParameters) {
            return this.moduleParameters((ModuleParameters)((ModuleParameters.Builder)ModuleParameters.builder().applyMutation(moduleParameters)).build());
        }
    }
}

