/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a trust store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrustStoreConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TrustStoreConfiguration.Builder, TrustStoreConfiguration> {
    private static final SdkField<List<String>> CERTIFICATE_AUTHORITY_CERTIFICATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("certificateAuthorityCertificates")
            .getter(getter(TrustStoreConfiguration::certificateAuthorityCertificates))
            .setter(setter(Builder::certificateAuthorityCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAuthorityCertificates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CERTIFICATE_AUTHORITY_CERTIFICATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> certificateAuthorityCertificates;

    private TrustStoreConfiguration(BuilderImpl builder) {
        this.certificateAuthorityCertificates = builder.certificateAuthorityCertificates;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificateAuthorityCertificates
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCertificateAuthorityCertificates() {
        return certificateAuthorityCertificates != null && !(certificateAuthorityCertificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The certificate authority certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateAuthorityCertificates}
     * method.
     * </p>
     * 
     * @return The certificate authority certificate.
     */
    public final List<String> certificateAuthorityCertificates() {
        return certificateAuthorityCertificates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCertificateAuthorityCertificates() ? certificateAuthorityCertificates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustStoreConfiguration)) {
            return false;
        }
        TrustStoreConfiguration other = (TrustStoreConfiguration) obj;
        return hasCertificateAuthorityCertificates() == other.hasCertificateAuthorityCertificates()
                && Objects.equals(certificateAuthorityCertificates(), other.certificateAuthorityCertificates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("TrustStoreConfiguration")
                .add("CertificateAuthorityCertificates",
                        certificateAuthorityCertificates() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateAuthorityCertificates":
            return Optional.ofNullable(clazz.cast(certificateAuthorityCertificates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("certificateAuthorityCertificates", CERTIFICATE_AUTHORITY_CERTIFICATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustStoreConfiguration, T> g) {
        return obj -> g.apply((TrustStoreConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrustStoreConfiguration> {
        /**
         * <p>
         * The certificate authority certificate.
         * </p>
         * 
         * @param certificateAuthorityCertificates
         *        The certificate authority certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityCertificates(Collection<String> certificateAuthorityCertificates);

        /**
         * <p>
         * The certificate authority certificate.
         * </p>
         * 
         * @param certificateAuthorityCertificates
         *        The certificate authority certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityCertificates(String... certificateAuthorityCertificates);
    }

    static final class BuilderImpl implements Builder {
        private List<String> certificateAuthorityCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustStoreConfiguration model) {
            certificateAuthorityCertificates(model.certificateAuthorityCertificates);
        }

        public final Collection<String> getCertificateAuthorityCertificates() {
            if (certificateAuthorityCertificates instanceof SdkAutoConstructList) {
                return null;
            }
            return certificateAuthorityCertificates;
        }

        public final void setCertificateAuthorityCertificates(Collection<String> certificateAuthorityCertificates) {
            this.certificateAuthorityCertificates = CertificateAuthorityCertificatesCopier.copy(certificateAuthorityCertificates);
        }

        @Override
        public final Builder certificateAuthorityCertificates(Collection<String> certificateAuthorityCertificates) {
            this.certificateAuthorityCertificates = CertificateAuthorityCertificatesCopier.copy(certificateAuthorityCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorityCertificates(String... certificateAuthorityCertificates) {
            certificateAuthorityCertificates(Arrays.asList(certificateAuthorityCertificates));
            return this;
        }

        @Override
        public TrustStoreConfiguration build() {
            return new TrustStoreConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
