/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a no bid action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NoBidAction implements SdkPojo, Serializable, ToCopyableBuilder<NoBidAction.Builder, NoBidAction> {
    private static final SdkField<Integer> NO_BID_REASON_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("noBidReasonCode").getter(getter(NoBidAction::noBidReasonCode)).setter(setter(Builder::noBidReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noBidReasonCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_BID_REASON_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer noBidReasonCode;

    private NoBidAction(BuilderImpl builder) {
        this.noBidReasonCode = builder.noBidReasonCode;
    }

    /**
     * <p>
     * The reason code for the no bid action.
     * </p>
     * 
     * @return The reason code for the no bid action.
     */
    public final Integer noBidReasonCode() {
        return noBidReasonCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noBidReasonCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoBidAction)) {
            return false;
        }
        NoBidAction other = (NoBidAction) obj;
        return Objects.equals(noBidReasonCode(), other.noBidReasonCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NoBidAction").add("NoBidReasonCode", noBidReasonCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "noBidReasonCode":
            return Optional.ofNullable(clazz.cast(noBidReasonCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("noBidReasonCode", NO_BID_REASON_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NoBidAction, T> g) {
        return obj -> g.apply((NoBidAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NoBidAction> {
        /**
         * <p>
         * The reason code for the no bid action.
         * </p>
         * 
         * @param noBidReasonCode
         *        The reason code for the no bid action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noBidReasonCode(Integer noBidReasonCode);
    }

    static final class BuilderImpl implements Builder {
        private Integer noBidReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(NoBidAction model) {
            noBidReasonCode(model.noBidReasonCode);
        }

        public final Integer getNoBidReasonCode() {
            return noBidReasonCode;
        }

        public final void setNoBidReasonCode(Integer noBidReasonCode) {
            this.noBidReasonCode = noBidReasonCode;
        }

        @Override
        public final Builder noBidReasonCode(Integer noBidReasonCode) {
            this.noBidReasonCode = noBidReasonCode;
            return this;
        }

        @Override
        public NoBidAction build() {
            return new NoBidAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
