/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterType {
    INCLUDE("INCLUDE"),
    EXCLUDE("EXCLUDE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterType> VALUE_MAP;
    private final String value;

    private FilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterType> knownValues() {
        EnumSet<FilterType> knownValues = EnumSet.allOf(FilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterType.class, FilterType::toString);
    }
}

