/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.MutationProtectionStatus;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFirewallRuleGroupAssociationRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, UpdateFirewallRuleGroupAssociationRequest> {
    private static final SdkField<String> FIREWALL_RULE_GROUP_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallRuleGroupAssociationId").getter(UpdateFirewallRuleGroupAssociationRequest.getter(UpdateFirewallRuleGroupAssociationRequest::firewallRuleGroupAssociationId)).setter(UpdateFirewallRuleGroupAssociationRequest.setter(Builder::firewallRuleGroupAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupAssociationId").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(UpdateFirewallRuleGroupAssociationRequest.getter(UpdateFirewallRuleGroupAssociationRequest::priority)).setter(UpdateFirewallRuleGroupAssociationRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> MUTATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MutationProtection").getter(UpdateFirewallRuleGroupAssociationRequest.getter(UpdateFirewallRuleGroupAssociationRequest::mutationProtectionAsString)).setter(UpdateFirewallRuleGroupAssociationRequest.setter(Builder::mutationProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutationProtection").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateFirewallRuleGroupAssociationRequest.getter(UpdateFirewallRuleGroupAssociationRequest::name)).setter(UpdateFirewallRuleGroupAssociationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULE_GROUP_ASSOCIATION_ID_FIELD, PRIORITY_FIELD, MUTATION_PROTECTION_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFirewallRuleGroupAssociationRequest.memberNameToFieldInitializer();
    private final String firewallRuleGroupAssociationId;
    private final Integer priority;
    private final String mutationProtection;
    private final String name;

    private UpdateFirewallRuleGroupAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.firewallRuleGroupAssociationId = builder.firewallRuleGroupAssociationId;
        this.priority = builder.priority;
        this.mutationProtection = builder.mutationProtection;
        this.name = builder.name;
    }

    public final String firewallRuleGroupAssociationId() {
        return this.firewallRuleGroupAssociationId;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final MutationProtectionStatus mutationProtection() {
        return MutationProtectionStatus.fromValue(this.mutationProtection);
    }

    public final String mutationProtectionAsString() {
        return this.mutationProtection;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallRuleGroupAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutationProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallRuleGroupAssociationRequest)) {
            return false;
        }
        UpdateFirewallRuleGroupAssociationRequest other = (UpdateFirewallRuleGroupAssociationRequest)((Object)obj);
        return Objects.equals(this.firewallRuleGroupAssociationId(), other.firewallRuleGroupAssociationId()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.mutationProtectionAsString(), other.mutationProtectionAsString()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFirewallRuleGroupAssociationRequest").add("FirewallRuleGroupAssociationId", (Object)this.firewallRuleGroupAssociationId()).add("Priority", (Object)this.priority()).add("MutationProtection", (Object)this.mutationProtectionAsString()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirewallRuleGroupAssociationId": {
                return Optional.ofNullable(clazz.cast(this.firewallRuleGroupAssociationId()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "MutationProtection": {
                return Optional.ofNullable(clazz.cast(this.mutationProtectionAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FirewallRuleGroupAssociationId", FIREWALL_RULE_GROUP_ASSOCIATION_ID_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("MutationProtection", MUTATION_PROTECTION_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFirewallRuleGroupAssociationRequest, T> g) {
        return obj -> g.apply((UpdateFirewallRuleGroupAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String firewallRuleGroupAssociationId;
        private Integer priority;
        private String mutationProtection;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFirewallRuleGroupAssociationRequest model) {
            super(model);
            this.firewallRuleGroupAssociationId(model.firewallRuleGroupAssociationId);
            this.priority(model.priority);
            this.mutationProtection(model.mutationProtection);
            this.name(model.name);
        }

        public final String getFirewallRuleGroupAssociationId() {
            return this.firewallRuleGroupAssociationId;
        }

        public final void setFirewallRuleGroupAssociationId(String firewallRuleGroupAssociationId) {
            this.firewallRuleGroupAssociationId = firewallRuleGroupAssociationId;
        }

        @Override
        public final Builder firewallRuleGroupAssociationId(String firewallRuleGroupAssociationId) {
            this.firewallRuleGroupAssociationId = firewallRuleGroupAssociationId;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getMutationProtection() {
            return this.mutationProtection;
        }

        public final void setMutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
        }

        @Override
        public final Builder mutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
            return this;
        }

        @Override
        public final Builder mutationProtection(MutationProtectionStatus mutationProtection) {
            this.mutationProtection(mutationProtection == null ? null : mutationProtection.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFirewallRuleGroupAssociationRequest build() {
            return new UpdateFirewallRuleGroupAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFirewallRuleGroupAssociationRequest> {
        public Builder firewallRuleGroupAssociationId(String var1);

        public Builder priority(Integer var1);

        public Builder mutationProtection(String var1);

        public Builder mutationProtection(MutationProtectionStatus var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

