/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.ResolverDNSSECValidationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolverDnssecConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolverDnssecConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ResolverDnssecConfig.getter(ResolverDnssecConfig::id)).setter(ResolverDnssecConfig.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(ResolverDnssecConfig.getter(ResolverDnssecConfig::ownerId)).setter(ResolverDnssecConfig.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ResolverDnssecConfig.getter(ResolverDnssecConfig::resourceId)).setter(ResolverDnssecConfig.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatus").getter(ResolverDnssecConfig.getter(ResolverDnssecConfig::validationStatusAsString)).setter(ResolverDnssecConfig.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, OWNER_ID_FIELD, RESOURCE_ID_FIELD, VALIDATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResolverDnssecConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String ownerId;
    private final String resourceId;
    private final String validationStatus;

    private ResolverDnssecConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.ownerId = builder.ownerId;
        this.resourceId = builder.resourceId;
        this.validationStatus = builder.validationStatus;
    }

    public final String id() {
        return this.id;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ResolverDNSSECValidationStatus validationStatus() {
        return ResolverDNSSECValidationStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverDnssecConfig)) {
            return false;
        }
        ResolverDnssecConfig other = (ResolverDnssecConfig)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResolverDnssecConfig").add("Id", (Object)this.id()).add("OwnerId", (Object)this.ownerId()).add("ResourceId", (Object)this.resourceId()).add("ValidationStatus", (Object)this.validationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ValidationStatus", VALIDATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolverDnssecConfig, T> g) {
        return obj -> g.apply((ResolverDnssecConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String ownerId;
        private String resourceId;
        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverDnssecConfig model) {
            this.id(model.id);
            this.ownerId(model.ownerId);
            this.resourceId(model.resourceId);
            this.validationStatus(model.validationStatus);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(ResolverDNSSECValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public ResolverDnssecConfig build() {
            return new ResolverDnssecConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolverDnssecConfig> {
        public Builder id(String var1);

        public Builder ownerId(String var1);

        public Builder resourceId(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(ResolverDNSSECValidationStatus var1);
    }
}

