/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.FirewallRule;
import software.amazon.awssdk.services.route53resolver.model.FirewallRulesCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFirewallRulesResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListFirewallRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFirewallRulesResponse.getter(ListFirewallRulesResponse::nextToken)).setter(ListFirewallRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<FirewallRule>> FIREWALL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FirewallRules").getter(ListFirewallRulesResponse.getter(ListFirewallRulesResponse::firewallRules)).setter(ListFirewallRulesResponse.setter(Builder::firewallRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FirewallRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, FIREWALL_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFirewallRulesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<FirewallRule> firewallRules;

    private ListFirewallRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallRules = builder.firewallRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasFirewallRules() {
        return this.firewallRules != null && !(this.firewallRules instanceof SdkAutoConstructList);
    }

    public final List<FirewallRule> firewallRules() {
        return this.firewallRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFirewallRules() ? this.firewallRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRulesResponse)) {
            return false;
        }
        ListFirewallRulesResponse other = (ListFirewallRulesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasFirewallRules() == other.hasFirewallRules() && Objects.equals(this.firewallRules(), other.firewallRules());
    }

    public final String toString() {
        return ToString.builder((String)"ListFirewallRulesResponse").add("NextToken", (Object)this.nextToken()).add("FirewallRules", this.hasFirewallRules() ? this.firewallRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FirewallRules": {
                return Optional.ofNullable(clazz.cast(this.firewallRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("FirewallRules", FIREWALL_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRulesResponse, T> g) {
        return obj -> g.apply((ListFirewallRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FirewallRule> firewallRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRulesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.firewallRules(model.firewallRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallRule.Builder> getFirewallRules() {
            List<FirewallRule.Builder> result = FirewallRulesCopier.copyToBuilder(this.firewallRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallRules(Collection<FirewallRule.BuilderImpl> firewallRules) {
            this.firewallRules = FirewallRulesCopier.copyFromBuilder(firewallRules);
        }

        @Override
        public final Builder firewallRules(Collection<FirewallRule> firewallRules) {
            this.firewallRules = FirewallRulesCopier.copy(firewallRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRules(FirewallRule ... firewallRules) {
            this.firewallRules(Arrays.asList(firewallRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRules(Consumer<FirewallRule.Builder> ... firewallRules) {
            this.firewallRules(Stream.of(firewallRules).map(c -> (FirewallRule)((FirewallRule.Builder)FirewallRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallRulesResponse build() {
            return new ListFirewallRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFirewallRulesResponse> {
        public Builder nextToken(String var1);

        public Builder firewallRules(Collection<FirewallRule> var1);

        public Builder firewallRules(FirewallRule ... var1);

        public Builder firewallRules(Consumer<FirewallRule.Builder> ... var1);
    }
}

