/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverRuleAssociationsResponse;

public class ListResolverRuleAssociationsPublisher
implements SdkPublisher<ListResolverRuleAssociationsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverRuleAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverRuleAssociationsPublisher(Route53ResolverAsyncClient client, ListResolverRuleAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverRuleAssociationsPublisher(Route53ResolverAsyncClient client, ListResolverRuleAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverRuleAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverRuleAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListResolverRuleAssociationsPublisher resume(ListResolverRuleAssociationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListResolverRuleAssociationsPublisher(this.client, (ListResolverRuleAssociationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListResolverRuleAssociationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListResolverRuleAssociationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListResolverRuleAssociationsResponseFetcher
    implements AsyncPageFetcher<ListResolverRuleAssociationsResponse> {
        private ListResolverRuleAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverRuleAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverRuleAssociationsResponse> nextPage(ListResolverRuleAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverRuleAssociationsPublisher.this.client.listResolverRuleAssociations(ListResolverRuleAssociationsPublisher.this.firstRequest);
            }
            return ListResolverRuleAssociationsPublisher.this.client.listResolverRuleAssociations((ListResolverRuleAssociationsRequest)((Object)ListResolverRuleAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

