/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest;
import software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse;
import software.amazon.awssdk.services.route53resolver.model.OutpostResolver;

public class ListOutpostResolversIterable
implements SdkIterable<ListOutpostResolversResponse> {
    private final Route53ResolverClient client;
    private final ListOutpostResolversRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOutpostResolversIterable(Route53ResolverClient client, ListOutpostResolversRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOutpostResolversResponseFetcher();
    }

    public Iterator<ListOutpostResolversResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OutpostResolver> outpostResolvers() {
        Function<ListOutpostResolversResponse, Iterator> getIterator = response -> {
            if (response != null && response.outpostResolvers() != null) {
                return response.outpostResolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOutpostResolversResponseFetcher
    implements SyncPageFetcher<ListOutpostResolversResponse> {
        private ListOutpostResolversResponseFetcher() {
        }

        public boolean hasNextPage(ListOutpostResolversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOutpostResolversResponse nextPage(ListOutpostResolversResponse previousPage) {
            if (previousPage == null) {
                return ListOutpostResolversIterable.this.client.listOutpostResolvers(ListOutpostResolversIterable.this.firstRequest);
            }
            return ListOutpostResolversIterable.this.client.listOutpostResolvers((ListOutpostResolversRequest)((Object)ListOutpostResolversIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

