/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResolverEndpointType {
    IPV6("IPV6"),
    IPV4("IPV4"),
    DUALSTACK("DUALSTACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResolverEndpointType> VALUE_MAP;
    private final String value;

    private ResolverEndpointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResolverEndpointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResolverEndpointType> knownValues() {
        EnumSet<ResolverEndpointType> knownValues = EnumSet.allOf(ResolverEndpointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResolverEndpointType.class, ResolverEndpointType::toString);
    }
}

