/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.FirewallDomainsCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFirewallDomainsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListFirewallDomainsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFirewallDomainsResponse.getter(ListFirewallDomainsResponse::nextToken)).setter(ListFirewallDomainsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<String>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Domains").getter(ListFirewallDomainsResponse.getter(ListFirewallDomainsResponse::domains)).setter(ListFirewallDomainsResponse.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DOMAINS_FIELD));
    private final String nextToken;
    private final List<String> domains;

    private ListFirewallDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.domains = builder.domains;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public final List<String> domains() {
        return this.domains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomains() ? this.domains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallDomainsResponse)) {
            return false;
        }
        ListFirewallDomainsResponse other = (ListFirewallDomainsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDomains() == other.hasDomains() && Objects.equals(this.domains(), other.domains());
    }

    public final String toString() {
        return ToString.builder((String)"ListFirewallDomainsResponse").add("NextToken", (Object)this.nextToken()).add("Domains", this.hasDomains() ? this.domains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallDomainsResponse, T> g) {
        return obj -> g.apply((ListFirewallDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> domains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallDomainsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.domains(model.domains);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getDomains() {
            if (this.domains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domains;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = FirewallDomainsCopier.copy(domains);
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = FirewallDomainsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        @Override
        public ListFirewallDomainsResponse build() {
            return new ListFirewallDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFirewallDomainsResponse> {
        public Builder nextToken(String var1);

        public Builder domains(Collection<String> var1);

        public Builder domains(String ... var1);
    }
}

