/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.Action;
import software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType;
import software.amazon.awssdk.services.route53resolver.model.BlockResponse;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFirewallRuleRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, CreateFirewallRuleRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::creatorRequestId)).setter(CreateFirewallRuleRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallRuleGroupId").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::firewallRuleGroupId)).setter(CreateFirewallRuleRequest.setter(Builder::firewallRuleGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build()}).build();
    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallDomainListId").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::firewallDomainListId)).setter(CreateFirewallRuleRequest.setter(Builder::firewallDomainListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallDomainListId").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::priority)).setter(CreateFirewallRuleRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::actionAsString)).setter(CreateFirewallRuleRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> BLOCK_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockResponse").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::blockResponseAsString)).setter(CreateFirewallRuleRequest.setter(Builder::blockResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockResponse").build()}).build();
    private static final SdkField<String> BLOCK_OVERRIDE_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockOverrideDomain").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::blockOverrideDomain)).setter(CreateFirewallRuleRequest.setter(Builder::blockOverrideDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideDomain").build()}).build();
    private static final SdkField<String> BLOCK_OVERRIDE_DNS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockOverrideDnsType").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::blockOverrideDnsTypeAsString)).setter(CreateFirewallRuleRequest.setter(Builder::blockOverrideDnsType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideDnsType").build()}).build();
    private static final SdkField<Integer> BLOCK_OVERRIDE_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockOverrideTtl").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::blockOverrideTtl)).setter(CreateFirewallRuleRequest.setter(Builder::blockOverrideTtl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockOverrideTtl").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::name)).setter(CreateFirewallRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD, FIREWALL_RULE_GROUP_ID_FIELD, FIREWALL_DOMAIN_LIST_ID_FIELD, PRIORITY_FIELD, ACTION_FIELD, BLOCK_RESPONSE_FIELD, BLOCK_OVERRIDE_DOMAIN_FIELD, BLOCK_OVERRIDE_DNS_TYPE_FIELD, BLOCK_OVERRIDE_TTL_FIELD, NAME_FIELD));
    private final String creatorRequestId;
    private final String firewallRuleGroupId;
    private final String firewallDomainListId;
    private final Integer priority;
    private final String action;
    private final String blockResponse;
    private final String blockOverrideDomain;
    private final String blockOverrideDnsType;
    private final Integer blockOverrideTtl;
    private final String name;

    private CreateFirewallRuleRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.firewallDomainListId = builder.firewallDomainListId;
        this.priority = builder.priority;
        this.action = builder.action;
        this.blockResponse = builder.blockResponse;
        this.blockOverrideDomain = builder.blockOverrideDomain;
        this.blockOverrideDnsType = builder.blockOverrideDnsType;
        this.blockOverrideTtl = builder.blockOverrideTtl;
        this.name = builder.name;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String firewallRuleGroupId() {
        return this.firewallRuleGroupId;
    }

    public final String firewallDomainListId() {
        return this.firewallDomainListId;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Action action() {
        return Action.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final BlockResponse blockResponse() {
        return BlockResponse.fromValue(this.blockResponse);
    }

    public final String blockResponseAsString() {
        return this.blockResponse;
    }

    public final String blockOverrideDomain() {
        return this.blockOverrideDomain;
    }

    public final BlockOverrideDnsType blockOverrideDnsType() {
        return BlockOverrideDnsType.fromValue(this.blockOverrideDnsType);
    }

    public final String blockOverrideDnsTypeAsString() {
        return this.blockOverrideDnsType;
    }

    public final Integer blockOverrideTtl() {
        return this.blockOverrideTtl;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideDnsTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideTtl());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallRuleRequest)) {
            return false;
        }
        CreateFirewallRuleRequest other = (CreateFirewallRuleRequest)((Object)obj);
        return Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.firewallRuleGroupId(), other.firewallRuleGroupId()) && Objects.equals(this.firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.blockResponseAsString(), other.blockResponseAsString()) && Objects.equals(this.blockOverrideDomain(), other.blockOverrideDomain()) && Objects.equals(this.blockOverrideDnsTypeAsString(), other.blockOverrideDnsTypeAsString()) && Objects.equals(this.blockOverrideTtl(), other.blockOverrideTtl()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFirewallRuleRequest").add("CreatorRequestId", (Object)this.creatorRequestId()).add("FirewallRuleGroupId", (Object)this.firewallRuleGroupId()).add("FirewallDomainListId", (Object)this.firewallDomainListId()).add("Priority", (Object)this.priority()).add("Action", (Object)this.actionAsString()).add("BlockResponse", (Object)this.blockResponseAsString()).add("BlockOverrideDomain", (Object)this.blockOverrideDomain()).add("BlockOverrideDnsType", (Object)this.blockOverrideDnsTypeAsString()).add("BlockOverrideTtl", (Object)this.blockOverrideTtl()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "FirewallRuleGroupId": {
                return Optional.ofNullable(clazz.cast(this.firewallRuleGroupId()));
            }
            case "FirewallDomainListId": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainListId()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "BlockResponse": {
                return Optional.ofNullable(clazz.cast(this.blockResponseAsString()));
            }
            case "BlockOverrideDomain": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideDomain()));
            }
            case "BlockOverrideDnsType": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideDnsTypeAsString()));
            }
            case "BlockOverrideTtl": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideTtl()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallRuleRequest, T> g) {
        return obj -> g.apply((CreateFirewallRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String creatorRequestId;
        private String firewallRuleGroupId;
        private String firewallDomainListId;
        private Integer priority;
        private String action;
        private String blockResponse;
        private String blockOverrideDomain;
        private String blockOverrideDnsType;
        private Integer blockOverrideTtl;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallRuleRequest model) {
            super(model);
            this.creatorRequestId(model.creatorRequestId);
            this.firewallRuleGroupId(model.firewallRuleGroupId);
            this.firewallDomainListId(model.firewallDomainListId);
            this.priority(model.priority);
            this.action(model.action);
            this.blockResponse(model.blockResponse);
            this.blockOverrideDomain(model.blockOverrideDomain);
            this.blockOverrideDnsType(model.blockOverrideDnsType);
            this.blockOverrideTtl(model.blockOverrideTtl);
            this.name(model.name);
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getFirewallRuleGroupId() {
            return this.firewallRuleGroupId;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        @Override
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final String getFirewallDomainListId() {
            return this.firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBlockResponse() {
            return this.blockResponse;
        }

        public final void setBlockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
        }

        @Override
        public final Builder blockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
            return this;
        }

        @Override
        public final Builder blockResponse(BlockResponse blockResponse) {
            this.blockResponse(blockResponse == null ? null : blockResponse.toString());
            return this;
        }

        public final String getBlockOverrideDomain() {
            return this.blockOverrideDomain;
        }

        public final void setBlockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
        }

        @Override
        public final Builder blockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
            return this;
        }

        public final String getBlockOverrideDnsType() {
            return this.blockOverrideDnsType;
        }

        public final void setBlockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
        }

        @Override
        public final Builder blockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
            return this;
        }

        @Override
        public final Builder blockOverrideDnsType(BlockOverrideDnsType blockOverrideDnsType) {
            this.blockOverrideDnsType(blockOverrideDnsType == null ? null : blockOverrideDnsType.toString());
            return this;
        }

        public final Integer getBlockOverrideTtl() {
            return this.blockOverrideTtl;
        }

        public final void setBlockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
        }

        @Override
        public final Builder blockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFirewallRuleRequest build() {
            return new CreateFirewallRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFirewallRuleRequest> {
        public Builder creatorRequestId(String var1);

        public Builder firewallRuleGroupId(String var1);

        public Builder firewallDomainListId(String var1);

        public Builder priority(Integer var1);

        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder blockResponse(String var1);

        public Builder blockResponse(BlockResponse var1);

        public Builder blockOverrideDomain(String var1);

        public Builder blockOverrideDnsType(String var1);

        public Builder blockOverrideDnsType(BlockOverrideDnsType var1);

        public Builder blockOverrideTtl(Integer var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

