/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation;
import software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociationsCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResolverRuleAssociationsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListResolverRuleAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResolverRuleAssociationsResponse.getter(ListResolverRuleAssociationsResponse::nextToken)).setter(ListResolverRuleAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResolverRuleAssociationsResponse.getter(ListResolverRuleAssociationsResponse::maxResults)).setter(ListResolverRuleAssociationsResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<ResolverRuleAssociation>> RESOLVER_RULE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResolverRuleAssociations").getter(ListResolverRuleAssociationsResponse.getter(ListResolverRuleAssociationsResponse::resolverRuleAssociations)).setter(ListResolverRuleAssociationsResponse.setter(Builder::resolverRuleAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolverRuleAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOLVER_RULE_ASSOCIATIONS_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final List<ResolverRuleAssociation> resolverRuleAssociations;

    private ListResolverRuleAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resolverRuleAssociations = builder.resolverRuleAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasResolverRuleAssociations() {
        return this.resolverRuleAssociations != null && !(this.resolverRuleAssociations instanceof SdkAutoConstructList);
    }

    public final List<ResolverRuleAssociation> resolverRuleAssociations() {
        return this.resolverRuleAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolverRuleAssociations() ? this.resolverRuleAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverRuleAssociationsResponse)) {
            return false;
        }
        ListResolverRuleAssociationsResponse other = (ListResolverRuleAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasResolverRuleAssociations() == other.hasResolverRuleAssociations() && Objects.equals(this.resolverRuleAssociations(), other.resolverRuleAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListResolverRuleAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResolverRuleAssociations", this.hasResolverRuleAssociations() ? this.resolverRuleAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ResolverRuleAssociations": {
                return Optional.ofNullable(clazz.cast(this.resolverRuleAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverRuleAssociationsResponse, T> g) {
        return obj -> g.apply((ListResolverRuleAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<ResolverRuleAssociation> resolverRuleAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverRuleAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resolverRuleAssociations(model.resolverRuleAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<ResolverRuleAssociation.Builder> getResolverRuleAssociations() {
            List<ResolverRuleAssociation.Builder> result = ResolverRuleAssociationsCopier.copyToBuilder(this.resolverRuleAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResolverRuleAssociations(Collection<ResolverRuleAssociation.BuilderImpl> resolverRuleAssociations) {
            this.resolverRuleAssociations = ResolverRuleAssociationsCopier.copyFromBuilder(resolverRuleAssociations);
        }

        @Override
        @Transient
        public final Builder resolverRuleAssociations(Collection<ResolverRuleAssociation> resolverRuleAssociations) {
            this.resolverRuleAssociations = ResolverRuleAssociationsCopier.copy(resolverRuleAssociations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resolverRuleAssociations(ResolverRuleAssociation ... resolverRuleAssociations) {
            this.resolverRuleAssociations(Arrays.asList(resolverRuleAssociations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resolverRuleAssociations(Consumer<ResolverRuleAssociation.Builder> ... resolverRuleAssociations) {
            this.resolverRuleAssociations(Stream.of(resolverRuleAssociations).map(c -> (ResolverRuleAssociation)((ResolverRuleAssociation.Builder)ResolverRuleAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResolverRuleAssociationsResponse build() {
            return new ListResolverRuleAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResolverRuleAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resolverRuleAssociations(Collection<ResolverRuleAssociation> var1);

        public Builder resolverRuleAssociations(ResolverRuleAssociation ... var1);

        public Builder resolverRuleAssociations(Consumer<ResolverRuleAssociation.Builder> ... var1);
    }
}

