/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResolverQueryLogConfigsRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<ListResolverQueryLogConfigsRequest.Builder, ListResolverQueryLogConfigsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResolverQueryLogConfigsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResolverQueryLogConfigsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListResolverQueryLogConfigsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListResolverQueryLogConfigsRequest::sortBy)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListResolverQueryLogConfigsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, FILTERS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final List<Filter> filters;

    private final String sortBy;

    private final String sortOrder;

    private ListResolverQueryLogConfigsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The maximum number of query logging configurations that you want to return in the response to a
     * <code>ListResolverQueryLogConfigs</code> request. If you don't specify a value for <code>MaxResults</code>,
     * Resolver returns up to 100 query logging configurations.
     * </p>
     * 
     * @return The maximum number of query logging configurations that you want to return in the response to a
     *         <code>ListResolverQueryLogConfigs</code> request. If you don't specify a value for
     *         <code>MaxResults</code>, Resolver returns up to 100 query logging configurations.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.
     * </p>
     * <p>
     * If there are more than <code>MaxResults</code> query logging configurations that match the values that you
     * specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigs</code> request to get
     * the next group of configurations. In the next request, specify the value of <code>NextToken</code> from the
     * previous response.
     * </p>
     * 
     * @return For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
     *         <p>
     *         If there are more than <code>MaxResults</code> query logging configurations that match the values that
     *         you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigs</code>
     *         request to get the next group of configurations. In the next request, specify the value of
     *         <code>NextToken</code> from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional specification to return a subset of query logging configurations.
     * </p>
     * <note>
     * <p>
     * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
     * <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the
     * previous request.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An optional specification to return a subset of query logging configurations.</p> <note>
     *         <p>
     *         If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
     *         <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in
     *         the previous request.
     *         </p>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The element that you want Resolver to sort query logging configurations by.
     * </p>
     * <note>
     * <p>
     * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
     * <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the previous
     * request.
     * </p>
     * </note>
     * <p>
     * Valid values include the following elements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Arn</code>: The ARN of the query logging configuration
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the
     * configuration was created
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationArn</code>: The location that logs are sent to
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Id</code>: The ID of the configuration
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>: The name of the configuration
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OwnerId</code>: The AWS account number of the account that created the configuration
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShareStatus</code>: Whether the configuration is shared with other AWS accounts or shared with the current
     * account by another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Status</code>: The current status of the configuration. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: Resolver is creating the query logging configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries that
     * originate in the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Resolver is deleting this query logging configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration. Here are
     * two common causes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The specified destination (for example, an Amazon S3 bucket) was deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * Permissions don't allow sending logs to the destination.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The element that you want Resolver to sort query logging configurations by. </p> <note>
     *         <p>
     *         If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
     *         <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the
     *         previous request.
     *         </p>
     *         </note>
     *         <p>
     *         Valid values include the following elements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Arn</code>: The ARN of the query logging configuration
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the
     *         configuration was created
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DestinationArn</code>: The location that logs are sent to
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Id</code>: The ID of the configuration
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code>: The name of the configuration
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OwnerId</code>: The AWS account number of the account that created the configuration
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShareStatus</code>: Whether the configuration is shared with other AWS accounts or shared with the
     *         current account by another AWS account. Sharing is configured through AWS Resource Access Manager (AWS
     *         RAM).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Status</code>: The current status of the configuration. Valid values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: Resolver is creating the query logging configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging
     *         queries that originate in the specified VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Resolver is deleting this query logging configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration.
     *         Here are two common causes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The specified destination (for example, an Amazon S3 bucket) was deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Permissions don't allow sending logs to the destination.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be
     * listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.
     * </p>
     * <note>
     * <p>
     * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
     * <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the
     * previous request.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to
     *         be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>
     *         <p>
     *         If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
     *         <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in
     *         the previous request.
     *         </p>
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be
     * listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.
     * </p>
     * <note>
     * <p>
     * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
     * <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the
     * previous request.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to
     *         be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>
     *         <p>
     *         If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
     *         <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in
     *         the previous request.
     *         </p>
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverQueryLogConfigsRequest)) {
            return false;
        }
        ListResolverQueryLogConfigsRequest other = (ListResolverQueryLogConfigsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(sortBy(), other.sortBy()) && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResolverQueryLogConfigsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Filters", hasFilters() ? filters() : null).add("SortBy", sortBy())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverQueryLogConfigsRequest, T> g) {
        return obj -> g.apply((ListResolverQueryLogConfigsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResolverQueryLogConfigsRequest> {
        /**
         * <p>
         * The maximum number of query logging configurations that you want to return in the response to a
         * <code>ListResolverQueryLogConfigs</code> request. If you don't specify a value for <code>MaxResults</code>,
         * Resolver returns up to 100 query logging configurations.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of query logging configurations that you want to return in the response to a
         *        <code>ListResolverQueryLogConfigs</code> request. If you don't specify a value for
         *        <code>MaxResults</code>, Resolver returns up to 100 query logging configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.
         * </p>
         * <p>
         * If there are more than <code>MaxResults</code> query logging configurations that match the values that you
         * specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigs</code> request to
         * get the next group of configurations. In the next request, specify the value of <code>NextToken</code> from
         * the previous response.
         * </p>
         * 
         * @param nextToken
         *        For the first <code>ListResolverQueryLogConfigs</code> request, omit this value.</p>
         *        <p>
         *        If there are more than <code>MaxResults</code> query logging configurations that match the values that
         *        you specify for <code>Filters</code>, you can submit another <code>ListResolverQueryLogConfigs</code>
         *        request to get the next group of configurations. In the next request, specify the value of
         *        <code>NextToken</code> from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An optional specification to return a subset of query logging configurations.
         * </p>
         * <note>
         * <p>
         * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         * <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the
         * previous request.
         * </p>
         * </note>
         * 
         * @param filters
         *        An optional specification to return a subset of query logging configurations.</p> <note>
         *        <p>
         *        If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         *        <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in
         *        the previous request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * An optional specification to return a subset of query logging configurations.
         * </p>
         * <note>
         * <p>
         * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         * <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the
         * previous request.
         * </p>
         * </note>
         * 
         * @param filters
         *        An optional specification to return a subset of query logging configurations.</p> <note>
         *        <p>
         *        If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         *        <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in
         *        the previous request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * An optional specification to return a subset of query logging configurations.
         * </p>
         * <note>
         * <p>
         * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         * <code>NextToken</code> parameter, you must use the same values for <code>Filters</code>, if any, as in the
         * previous request.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need
         * to create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The element that you want Resolver to sort query logging configurations by.
         * </p>
         * <note>
         * <p>
         * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         * <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in the
         * previous request.
         * </p>
         * </note>
         * <p>
         * Valid values include the following elements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Arn</code>: The ARN of the query logging configuration
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the
         * configuration was created
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DestinationArn</code>: The location that logs are sent to
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Id</code>: The ID of the configuration
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code>: The name of the configuration
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OwnerId</code>: The AWS account number of the account that created the configuration
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShareStatus</code>: Whether the configuration is shared with other AWS accounts or shared with the
         * current account by another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Status</code>: The current status of the configuration. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: Resolver is creating the query logging configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging queries
         * that originate in the specified VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Resolver is deleting this query logging configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging configuration. Here
         * are two common causes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The specified destination (for example, an Amazon S3 bucket) was deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * Permissions don't allow sending logs to the destination.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param sortBy
         *        The element that you want Resolver to sort query logging configurations by. </p> <note>
         *        <p>
         *        If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         *        <code>NextToken</code> parameter, you must use the same value for <code>SortBy</code>, if any, as in
         *        the previous request.
         *        </p>
         *        </note>
         *        <p>
         *        Valid values include the following elements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Arn</code>: The ARN of the query logging configuration
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AssociationCount</code>: The number of VPCs that are associated with the specified configuration
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreationTime</code>: The date and time that Resolver returned when the configuration was created
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreatorRequestId</code>: The value that was specified for <code>CreatorRequestId</code> when the
         *        configuration was created
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DestinationArn</code>: The location that logs are sent to
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Id</code>: The ID of the configuration
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code>: The name of the configuration
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OwnerId</code>: The AWS account number of the account that created the configuration
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShareStatus</code>: Whether the configuration is shared with other AWS accounts or shared with
         *        the current account by another AWS account. Sharing is configured through AWS Resource Access Manager
         *        (AWS RAM).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Status</code>: The current status of the configuration. Valid values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: Resolver is creating the query logging configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code>: The query logging configuration was successfully created. Resolver is logging
         *        queries that originate in the specified VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Resolver is deleting this query logging configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging
         *        configuration. Here are two common causes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The specified destination (for example, an Amazon S3 bucket) was deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Permissions don't allow sending logs to the destination.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be
         * listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * <note>
         * <p>
         * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         * <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the
         * previous request.
         * </p>
         * </note>
         * 
         * @param sortOrder
         *        If you specified a value for <code>SortBy</code>, the order that you want query logging configurations
         *        to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>
         *        <p>
         *        If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         *        <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as
         *        in the previous request.
         *        </p>
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * If you specified a value for <code>SortBy</code>, the order that you want query logging configurations to be
         * listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * <note>
         * <p>
         * If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         * <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as in the
         * previous request.
         * </p>
         * </note>
         * 
         * @param sortOrder
         *        If you specified a value for <code>SortBy</code>, the order that you want query logging configurations
         *        to be listed in, <code>ASCENDING</code> or <code>DESCENDING</code>.</p> <note>
         *        <p>
         *        If you submit a second or subsequent <code>ListResolverQueryLogConfigs</code> request and specify the
         *        <code>NextToken</code> parameter, you must use the same value for <code>SortOrder</code>, if any, as
         *        in the previous request.
         *        </p>
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverQueryLogConfigsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Filter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersCopier.copyFromBuilder(filters);
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResolverQueryLogConfigsRequest build() {
            return new ListResolverQueryLogConfigsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
