/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResolverEndpointRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<CreateResolverEndpointRequest.Builder, CreateResolverEndpointRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(CreateResolverEndpointRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateResolverEndpointRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateResolverEndpointRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Direction").getter(getter(CreateResolverEndpointRequest::directionAsString))
            .setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<List<IpAddressRequest>> IP_ADDRESSES_FIELD = SdkField
            .<List<IpAddressRequest>> builder(MarshallingType.LIST)
            .memberName("IpAddresses")
            .getter(getter(CreateResolverEndpointRequest::ipAddresses))
            .setter(setter(Builder::ipAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpAddressRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpAddressRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateResolverEndpointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD,
            NAME_FIELD, SECURITY_GROUP_IDS_FIELD, DIRECTION_FIELD, IP_ADDRESSES_FIELD, TAGS_FIELD));

    private final String creatorRequestId;

    private final String name;

    private final List<String> securityGroupIds;

    private final String direction;

    private final List<IpAddressRequest> ipAddresses;

    private final List<Tag> tags;

    private CreateResolverEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.name = builder.name;
        this.securityGroupIds = builder.securityGroupIds;
        this.direction = builder.direction;
        this.ipAddresses = builder.ipAddresses;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of
     * executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time
     * stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed requests to be retried without the
     *         risk of executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for
     *         example, a date/time stamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
     * </p>
     * 
     * @return A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53
     *         console.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of one or more security groups that you want to use to control access to this VPC. The security group that
     * you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules (for
     * outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open
     * port 53. For outbound access, open the port that you're using for DNS queries on your network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ID of one or more security groups that you want to use to control access to this VPC. The security
     *         group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or
     *         outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP
     *         access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS
     *         queries on your network.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Specify the applicable value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link ResolverEndpointDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #directionAsString}.
     * </p>
     * 
     * @return Specify the applicable value:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network
     *         </p>
     *         </li>
     * @see ResolverEndpointDirection
     */
    public final ResolverEndpointDirection direction() {
        return ResolverEndpointDirection.fromValue(direction);
    }

    /**
     * <p>
     * Specify the applicable value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link ResolverEndpointDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #directionAsString}.
     * </p>
     * 
     * @return Specify the applicable value:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network
     *         </p>
     *         </li>
     * @see ResolverEndpointDirection
     */
    public final String directionAsString() {
        return direction;
    }

    /**
     * Returns true if the IpAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpAddresses() {
        return ipAddresses != null && !(ipAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you
     * forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that
     *         you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
     */
    public final List<IpAddressRequest> ipAddresses() {
        return ipAddresses;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tag keys and values that you want to associate with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the tag keys and values that you want to associate with the endpoint.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpAddresses() ? ipAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResolverEndpointRequest)) {
            return false;
        }
        CreateResolverEndpointRequest other = (CreateResolverEndpointRequest) obj;
        return Objects.equals(creatorRequestId(), other.creatorRequestId()) && Objects.equals(name(), other.name())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(directionAsString(), other.directionAsString()) && hasIpAddresses() == other.hasIpAddresses()
                && Objects.equals(ipAddresses(), other.ipAddresses()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResolverEndpointRequest").add("CreatorRequestId", creatorRequestId()).add("Name", name())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("Direction", directionAsString())
                .add("IpAddresses", hasIpAddresses() ? ipAddresses() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "IpAddresses":
            return Optional.ofNullable(clazz.cast(ipAddresses()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResolverEndpointRequest, T> g) {
        return obj -> g.apply((CreateResolverEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResolverEndpointRequest> {
        /**
         * <p>
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of
         * executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a
         * date/time stamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed requests to be retried without the
         *        risk of executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for
         *        example, a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
         * </p>
         * 
         * @param name
         *        A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53
         *        console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of one or more security groups that you want to use to control access to this VPC. The security group
         * that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules
         * (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound
         * access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
         * </p>
         * 
         * @param securityGroupIds
         *        The ID of one or more security groups that you want to use to control access to this VPC. The security
         *        group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or
         *        outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP
         *        access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS
         *        queries on your network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The ID of one or more security groups that you want to use to control access to this VPC. The security group
         * that you specify must include one or more inbound rules (for inbound Resolver endpoints) or outbound rules
         * (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound
         * access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
         * </p>
         * 
         * @param securityGroupIds
         *        The ID of one or more security groups that you want to use to control access to this VPC. The security
         *        group that you specify must include one or more inbound rules (for inbound Resolver endpoints) or
         *        outbound rules (for outbound Resolver endpoints). Inbound and outbound rules must allow TCP and UDP
         *        access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS
         *        queries on your network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Specify the applicable value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network
         * </p>
         * </li>
         * </ul>
         * 
         * @param direction
         *        Specify the applicable value:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network
         *        </p>
         *        </li>
         * @see ResolverEndpointDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverEndpointDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * Specify the applicable value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network
         * </p>
         * </li>
         * </ul>
         * 
         * @param direction
         *        Specify the applicable value:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INBOUND</code>: Resolver forwards DNS queries to the DNS service for a VPC from your network
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUTBOUND</code>: Resolver forwards DNS queries from the DNS service for a VPC to your network
         *        </p>
         *        </li>
         * @see ResolverEndpointDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverEndpointDirection
         */
        Builder direction(ResolverEndpointDirection direction);

        /**
         * <p>
         * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you
         * forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
         * </p>
         * 
         * @param ipAddresses
         *        The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or
         *        that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(Collection<IpAddressRequest> ipAddresses);

        /**
         * <p>
         * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you
         * forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
         * </p>
         * 
         * @param ipAddresses
         *        The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or
         *        that you forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(IpAddressRequest... ipAddresses);

        /**
         * <p>
         * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you
         * forward DNS queries to (for inbound endpoints). The subnet ID uniquely identifies a VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpAddressRequest>.Builder} avoiding the
         * need to create one manually via {@link List<IpAddressRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpAddressRequest>.Builder#build()} is called immediately and
         * its result is passed to {@link #ipAddresses(List<IpAddressRequest>)}.
         * 
         * @param ipAddresses
         *        a consumer that will call methods on {@link List<IpAddressRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipAddresses(List<IpAddressRequest>)
         */
        Builder ipAddresses(Consumer<IpAddressRequest.Builder>... ipAddresses);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the endpoint.
         * </p>
         * 
         * @param tags
         *        A list of the tag keys and values that you want to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the endpoint.
         * </p>
         * 
         * @param tags
         *        A list of the tag keys and values that you want to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String creatorRequestId;

        private String name;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String direction;

        private List<IpAddressRequest> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResolverEndpointRequest model) {
            super(model);
            creatorRequestId(model.creatorRequestId);
            name(model.name);
            securityGroupIds(model.securityGroupIds);
            direction(model.direction);
            ipAddresses(model.ipAddresses);
            tags(model.tags);
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final String getDirection() {
            return direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(ResolverEndpointDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        public final Collection<IpAddressRequest.Builder> getIpAddresses() {
            if (ipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipAddresses != null ? ipAddresses.stream().map(IpAddressRequest::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ipAddresses(Collection<IpAddressRequest> ipAddresses) {
            this.ipAddresses = IpAddressesRequestCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(IpAddressRequest... ipAddresses) {
            ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(Consumer<IpAddressRequest.Builder>... ipAddresses) {
            ipAddresses(Stream.of(ipAddresses).map(c -> IpAddressRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpAddresses(Collection<IpAddressRequest.BuilderImpl> ipAddresses) {
            this.ipAddresses = IpAddressesRequestCopier.copyFromBuilder(ipAddresses);
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResolverEndpointRequest build() {
            return new CreateResolverEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
