/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus;
import software.amazon.awssdk.services.route53resolver.model.MutationProtectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirewallRuleGroupAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirewallRuleGroupAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::id)).setter(FirewallRuleGroupAssociation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::arn)).setter(FirewallRuleGroupAssociation.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallRuleGroupId").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::firewallRuleGroupId)).setter(FirewallRuleGroupAssociation.setter(Builder::firewallRuleGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::vpcId)).setter(FirewallRuleGroupAssociation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::name)).setter(FirewallRuleGroupAssociation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::priority)).setter(FirewallRuleGroupAssociation.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> MUTATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MutationProtection").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::mutationProtectionAsString)).setter(FirewallRuleGroupAssociation.setter(Builder::mutationProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutationProtection").build()}).build();
    private static final SdkField<String> MANAGED_OWNER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedOwnerName").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::managedOwnerName)).setter(FirewallRuleGroupAssociation.setter(Builder::managedOwnerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedOwnerName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::statusAsString)).setter(FirewallRuleGroupAssociation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::statusMessage)).setter(FirewallRuleGroupAssociation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::creatorRequestId)).setter(FirewallRuleGroupAssociation.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::creationTime)).setter(FirewallRuleGroupAssociation.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationTime").getter(FirewallRuleGroupAssociation.getter(FirewallRuleGroupAssociation::modificationTime)).setter(FirewallRuleGroupAssociation.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, FIREWALL_RULE_GROUP_ID_FIELD, VPC_ID_FIELD, NAME_FIELD, PRIORITY_FIELD, MUTATION_PROTECTION_FIELD, MANAGED_OWNER_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATOR_REQUEST_ID_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String firewallRuleGroupId;
    private final String vpcId;
    private final String name;
    private final Integer priority;
    private final String mutationProtection;
    private final String managedOwnerName;
    private final String status;
    private final String statusMessage;
    private final String creatorRequestId;
    private final String creationTime;
    private final String modificationTime;

    private FirewallRuleGroupAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.vpcId = builder.vpcId;
        this.name = builder.name;
        this.priority = builder.priority;
        this.mutationProtection = builder.mutationProtection;
        this.managedOwnerName = builder.managedOwnerName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String firewallRuleGroupId() {
        return this.firewallRuleGroupId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String name() {
        return this.name;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final MutationProtectionStatus mutationProtection() {
        return MutationProtectionStatus.fromValue(this.mutationProtection);
    }

    public final String mutationProtectionAsString() {
        return this.mutationProtection;
    }

    public final String managedOwnerName() {
        return this.managedOwnerName;
    }

    public final FirewallRuleGroupAssociationStatus status() {
        return FirewallRuleGroupAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String modificationTime() {
        return this.modificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutationProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedOwnerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallRuleGroupAssociation)) {
            return false;
        }
        FirewallRuleGroupAssociation other = (FirewallRuleGroupAssociation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.firewallRuleGroupId(), other.firewallRuleGroupId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.mutationProtectionAsString(), other.mutationProtectionAsString()) && Objects.equals(this.managedOwnerName(), other.managedOwnerName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modificationTime(), other.modificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"FirewallRuleGroupAssociation").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("FirewallRuleGroupId", (Object)this.firewallRuleGroupId()).add("VpcId", (Object)this.vpcId()).add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("MutationProtection", (Object)this.mutationProtectionAsString()).add("ManagedOwnerName", (Object)this.managedOwnerName()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("CreationTime", (Object)this.creationTime()).add("ModificationTime", (Object)this.modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "FirewallRuleGroupId": {
                return Optional.ofNullable(clazz.cast(this.firewallRuleGroupId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "MutationProtection": {
                return Optional.ofNullable(clazz.cast(this.mutationProtectionAsString()));
            }
            case "ManagedOwnerName": {
                return Optional.ofNullable(clazz.cast(this.managedOwnerName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallRuleGroupAssociation, T> g) {
        return obj -> g.apply((FirewallRuleGroupAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String firewallRuleGroupId;
        private String vpcId;
        private String name;
        private Integer priority;
        private String mutationProtection;
        private String managedOwnerName;
        private String status;
        private String statusMessage;
        private String creatorRequestId;
        private String creationTime;
        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallRuleGroupAssociation model) {
            this.id(model.id);
            this.arn(model.arn);
            this.firewallRuleGroupId(model.firewallRuleGroupId);
            this.vpcId(model.vpcId);
            this.name(model.name);
            this.priority(model.priority);
            this.mutationProtection(model.mutationProtection);
            this.managedOwnerName(model.managedOwnerName);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creatorRequestId(model.creatorRequestId);
            this.creationTime(model.creationTime);
            this.modificationTime(model.modificationTime);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getFirewallRuleGroupId() {
            return this.firewallRuleGroupId;
        }

        @Override
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMutationProtection() {
            return this.mutationProtection;
        }

        @Override
        public final Builder mutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
            return this;
        }

        @Override
        public final Builder mutationProtection(MutationProtectionStatus mutationProtection) {
            this.mutationProtection(mutationProtection == null ? null : mutationProtection.toString());
            return this;
        }

        public final void setMutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
        }

        public final String getManagedOwnerName() {
            return this.managedOwnerName;
        }

        @Override
        public final Builder managedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
            return this;
        }

        public final void setManagedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallRuleGroupAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModificationTime() {
            return this.modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        public FirewallRuleGroupAssociation build() {
            return new FirewallRuleGroupAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirewallRuleGroupAssociation> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder firewallRuleGroupId(String var1);

        public Builder vpcId(String var1);

        public Builder name(String var1);

        public Builder priority(Integer var1);

        public Builder mutationProtection(String var1);

        public Builder mutationProtection(MutationProtectionStatus var1);

        public Builder managedOwnerName(String var1);

        public Builder status(String var1);

        public Builder status(FirewallRuleGroupAssociationStatus var1);

        public Builder statusMessage(String var1);

        public Builder creatorRequestId(String var1);

        public Builder creationTime(String var1);

        public Builder modificationTime(String var1);
    }
}

