/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigListCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResolverQueryLogConfigsResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListResolverQueryLogConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResolverQueryLogConfigsResponse.getter(ListResolverQueryLogConfigsResponse::nextToken)).setter(ListResolverQueryLogConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(ListResolverQueryLogConfigsResponse.getter(ListResolverQueryLogConfigsResponse::totalCount)).setter(ListResolverQueryLogConfigsResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final SdkField<Integer> TOTAL_FILTERED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalFilteredCount").getter(ListResolverQueryLogConfigsResponse.getter(ListResolverQueryLogConfigsResponse::totalFilteredCount)).setter(ListResolverQueryLogConfigsResponse.setter(Builder::totalFilteredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFilteredCount").build()}).build();
    private static final SdkField<List<ResolverQueryLogConfig>> RESOLVER_QUERY_LOG_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResolverQueryLogConfigs").getter(ListResolverQueryLogConfigsResponse.getter(ListResolverQueryLogConfigsResponse::resolverQueryLogConfigs)).setter(ListResolverQueryLogConfigsResponse.setter(Builder::resolverQueryLogConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolverQueryLogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD, TOTAL_FILTERED_COUNT_FIELD, RESOLVER_QUERY_LOG_CONFIGS_FIELD));
    private final String nextToken;
    private final Integer totalCount;
    private final Integer totalFilteredCount;
    private final List<ResolverQueryLogConfig> resolverQueryLogConfigs;

    private ListResolverQueryLogConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
        this.totalFilteredCount = builder.totalFilteredCount;
        this.resolverQueryLogConfigs = builder.resolverQueryLogConfigs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public Integer totalFilteredCount() {
        return this.totalFilteredCount;
    }

    public boolean hasResolverQueryLogConfigs() {
        return this.resolverQueryLogConfigs != null && !(this.resolverQueryLogConfigs instanceof SdkAutoConstructList);
    }

    public List<ResolverQueryLogConfig> resolverQueryLogConfigs() {
        return this.resolverQueryLogConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFilteredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverQueryLogConfigs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverQueryLogConfigsResponse)) {
            return false;
        }
        ListResolverQueryLogConfigsResponse other = (ListResolverQueryLogConfigsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount()) && Objects.equals(this.totalFilteredCount(), other.totalFilteredCount()) && Objects.equals(this.resolverQueryLogConfigs(), other.resolverQueryLogConfigs());
    }

    public String toString() {
        return ToString.builder((String)"ListResolverQueryLogConfigsResponse").add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).add("TotalFilteredCount", (Object)this.totalFilteredCount()).add("ResolverQueryLogConfigs", this.resolverQueryLogConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
            case "TotalFilteredCount": {
                return Optional.ofNullable(clazz.cast(this.totalFilteredCount()));
            }
            case "ResolverQueryLogConfigs": {
                return Optional.ofNullable(clazz.cast(this.resolverQueryLogConfigs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverQueryLogConfigsResponse, T> g) {
        return obj -> g.apply((ListResolverQueryLogConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer totalCount;
        private Integer totalFilteredCount;
        private List<ResolverQueryLogConfig> resolverQueryLogConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverQueryLogConfigsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
            this.totalFilteredCount(model.totalFilteredCount);
            this.resolverQueryLogConfigs(model.resolverQueryLogConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public final Integer getTotalFilteredCount() {
            return this.totalFilteredCount;
        }

        @Override
        public final Builder totalFilteredCount(Integer totalFilteredCount) {
            this.totalFilteredCount = totalFilteredCount;
            return this;
        }

        public final void setTotalFilteredCount(Integer totalFilteredCount) {
            this.totalFilteredCount = totalFilteredCount;
        }

        public final Collection<ResolverQueryLogConfig.Builder> getResolverQueryLogConfigs() {
            return this.resolverQueryLogConfigs != null ? (Collection)this.resolverQueryLogConfigs.stream().map(ResolverQueryLogConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resolverQueryLogConfigs(Collection<ResolverQueryLogConfig> resolverQueryLogConfigs) {
            this.resolverQueryLogConfigs = ResolverQueryLogConfigListCopier.copy(resolverQueryLogConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverQueryLogConfigs(ResolverQueryLogConfig ... resolverQueryLogConfigs) {
            this.resolverQueryLogConfigs(Arrays.asList(resolverQueryLogConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverQueryLogConfigs(Consumer<ResolverQueryLogConfig.Builder> ... resolverQueryLogConfigs) {
            this.resolverQueryLogConfigs(Stream.of(resolverQueryLogConfigs).map(c -> (ResolverQueryLogConfig)((ResolverQueryLogConfig.Builder)ResolverQueryLogConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolverQueryLogConfigs(Collection<ResolverQueryLogConfig.BuilderImpl> resolverQueryLogConfigs) {
            this.resolverQueryLogConfigs = ResolverQueryLogConfigListCopier.copyFromBuilder(resolverQueryLogConfigs);
        }

        @Override
        public ListResolverQueryLogConfigsResponse build() {
            return new ListResolverQueryLogConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResolverQueryLogConfigsResponse> {
        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);

        public Builder totalFilteredCount(Integer var1);

        public Builder resolverQueryLogConfigs(Collection<ResolverQueryLogConfig> var1);

        public Builder resolverQueryLogConfigs(ResolverQueryLogConfig ... var1);

        public Builder resolverQueryLogConfigs(Consumer<ResolverQueryLogConfig.Builder> ... var1);
    }
}

