/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In a <a>CreateResolverRule</a> request, an array of the IPs that you want to forward DNS queries to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetAddress implements SdkPojo, Serializable, ToCopyableBuilder<TargetAddress.Builder, TargetAddress> {
    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TargetAddress::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TargetAddress::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ip;

    private final Integer port;

    private TargetAddress(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
    }

    /**
     * <p>
     * One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
     * </p>
     * 
     * @return One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
     */
    public String ip() {
        return ip;
    }

    /**
     * <p>
     * The port at <code>Ip</code> that you want to forward DNS queries to.
     * </p>
     * 
     * @return The port at <code>Ip</code> that you want to forward DNS queries to.
     */
    public Integer port() {
        return port;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetAddress)) {
            return false;
        }
        TargetAddress other = (TargetAddress) obj;
        return Objects.equals(ip(), other.ip()) && Objects.equals(port(), other.port());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TargetAddress").add("Ip", ip()).add("Port", port()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetAddress, T> g) {
        return obj -> g.apply((TargetAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetAddress> {
        /**
         * <p>
         * One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
         * </p>
         * 
         * @param ip
         *        One IP address that you want to forward DNS queries to. You can specify only IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * <p>
         * The port at <code>Ip</code> that you want to forward DNS queries to.
         * </p>
         * 
         * @param port
         *        The port at <code>Ip</code> that you want to forward DNS queries to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);
    }

    static final class BuilderImpl implements Builder {
        private String ip;

        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetAddress model) {
            ip(model.ip);
            port(model.port);
        }

        public final String getIp() {
            return ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public TargetAddress build() {
            return new TargetAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
