/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In the response to an <a>AssociateResolverRule</a>, <a>DisassociateResolverRule</a>, or
 * <a>ListResolverRuleAssociations</a> request, information about an association between a resolver rule and a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolverRuleAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolverRuleAssociation.Builder, ResolverRuleAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverRuleAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RESOLVER_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverRuleAssociation::resolverRuleId)).setter(setter(Builder::resolverRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverRuleAssociation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverRuleAssociation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverRuleAssociation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverRuleAssociation::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            RESOLVER_RULE_ID_FIELD, NAME_FIELD, VPC_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String resolverRuleId;

    private final String name;

    private final String vpcId;

    private final String status;

    private final String statusMessage;

    private ResolverRuleAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.resolverRuleId = builder.resolverRuleId;
        this.name = builder.name;
        this.vpcId = builder.vpcId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The ID of the association between a resolver rule and a VPC. Resolver assigns this value when you submit an
     * <a>AssociateResolverRule</a> request.
     * </p>
     * 
     * @return The ID of the association between a resolver rule and a VPC. Resolver assigns this value when you submit
     *         an <a>AssociateResolverRule</a> request.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.
     * </p>
     * 
     * @return The ID of the resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.
     */
    public String resolverRuleId() {
        return resolverRuleId;
    }

    /**
     * <p>
     * The name of an association between a resolver rule and a VPC.
     * </p>
     * 
     * @return The name of an association between a resolver rule and a VPC.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the VPC that you associated the resolver rule with.
     * </p>
     * 
     * @return The ID of the VPC that you associated the resolver rule with.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * A code that specifies the current status of the association between a resolver rule and a VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverRuleAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return A code that specifies the current status of the association between a resolver rule and a VPC.
     * @see ResolverRuleAssociationStatus
     */
    public ResolverRuleAssociationStatus status() {
        return ResolverRuleAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * A code that specifies the current status of the association between a resolver rule and a VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverRuleAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return A code that specifies the current status of the association between a resolver rule and a VPC.
     * @see ResolverRuleAssociationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed description of the status of the association between a resolver rule and a VPC.
     * </p>
     * 
     * @return A detailed description of the status of the association between a resolver rule and a VPC.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resolverRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverRuleAssociation)) {
            return false;
        }
        ResolverRuleAssociation other = (ResolverRuleAssociation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resolverRuleId(), other.resolverRuleId())
                && Objects.equals(name(), other.name()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResolverRuleAssociation").add("Id", id()).add("ResolverRuleId", resolverRuleId())
                .add("Name", name()).add("VPCId", vpcId()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ResolverRuleId":
            return Optional.ofNullable(clazz.cast(resolverRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VPCId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolverRuleAssociation, T> g) {
        return obj -> g.apply((ResolverRuleAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolverRuleAssociation> {
        /**
         * <p>
         * The ID of the association between a resolver rule and a VPC. Resolver assigns this value when you submit an
         * <a>AssociateResolverRule</a> request.
         * </p>
         * 
         * @param id
         *        The ID of the association between a resolver rule and a VPC. Resolver assigns this value when you
         *        submit an <a>AssociateResolverRule</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.
         * </p>
         * 
         * @param resolverRuleId
         *        The ID of the resolver rule that you associated with the VPC that is specified by <code>VPCId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRuleId(String resolverRuleId);

        /**
         * <p>
         * The name of an association between a resolver rule and a VPC.
         * </p>
         * 
         * @param name
         *        The name of an association between a resolver rule and a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the VPC that you associated the resolver rule with.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC that you associated the resolver rule with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A code that specifies the current status of the association between a resolver rule and a VPC.
         * </p>
         * 
         * @param status
         *        A code that specifies the current status of the association between a resolver rule and a VPC.
         * @see ResolverRuleAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverRuleAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A code that specifies the current status of the association between a resolver rule and a VPC.
         * </p>
         * 
         * @param status
         *        A code that specifies the current status of the association between a resolver rule and a VPC.
         * @see ResolverRuleAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverRuleAssociationStatus
         */
        Builder status(ResolverRuleAssociationStatus status);

        /**
         * <p>
         * A detailed description of the status of the association between a resolver rule and a VPC.
         * </p>
         * 
         * @param statusMessage
         *        A detailed description of the status of the association between a resolver rule and a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String resolverRuleId;

        private String name;

        private String vpcId;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverRuleAssociation model) {
            id(model.id);
            resolverRuleId(model.resolverRuleId);
            name(model.name);
            vpcId(model.vpcId);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResolverRuleId() {
            return resolverRuleId;
        }

        @Override
        public final Builder resolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
            return this;
        }

        public final void setResolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResolverRuleAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public ResolverRuleAssociation build() {
            return new ResolverRuleAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
