/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResolverEndpointsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListResolverEndpointsResponse.Builder, ListResolverEndpointsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListResolverEndpointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListResolverEndpointsResponse::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<ResolverEndpoint>> RESOLVER_ENDPOINTS_FIELD = SdkField
            .<List<ResolverEndpoint>> builder(MarshallingType.LIST)
            .getter(getter(ListResolverEndpointsResponse::resolverEndpoints))
            .setter(setter(Builder::resolverEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResolverEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResolverEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, RESOLVER_ENDPOINTS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<ResolverEndpoint> resolverEndpoints;

    private ListResolverEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resolverEndpoints = builder.resolverEndpoints;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another
     * <code>ListResolverEndpoint</code> request to get the next group of results. In the next request, specify the
     * value of <code>NextToken</code> from the previous response.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another
     *         <code>ListResolverEndpoint</code> request to get the next group of results. In the next request, specify
     *         the value of <code>NextToken</code> from the previous response.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The value that you specified for <code>MaxResults</code> in the request.
     * </p>
     * 
     * @return The value that you specified for <code>MaxResults</code> in the request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the ResolverEndpoints property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResolverEndpoints() {
        return resolverEndpoints != null && !(resolverEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resolver endpoints that were created by using the current AWS account, and that match the specified filters,
     * if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResolverEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The resolver endpoints that were created by using the current AWS account, and that match the specified
     *         filters, if any.
     */
    public List<ResolverEndpoint> resolverEndpoints() {
        return resolverEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(resolverEndpoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverEndpointsResponse)) {
            return false;
        }
        ListResolverEndpointsResponse other = (ListResolverEndpointsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(resolverEndpoints(), other.resolverEndpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListResolverEndpointsResponse").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ResolverEndpoints", resolverEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ResolverEndpoints":
            return Optional.ofNullable(clazz.cast(resolverEndpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverEndpointsResponse, T> g) {
        return obj -> g.apply((ListResolverEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResolverEndpointsResponse> {
        /**
         * <p>
         * If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another
         * <code>ListResolverEndpoint</code> request to get the next group of results. In the next request, specify the
         * value of <code>NextToken</code> from the previous response.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> IP addresses match the specified criteria, you can submit another
         *        <code>ListResolverEndpoint</code> request to get the next group of results. In the next request,
         *        specify the value of <code>NextToken</code> from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The value that you specified for <code>MaxResults</code> in the request.
         * </p>
         * 
         * @param maxResults
         *        The value that you specified for <code>MaxResults</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The resolver endpoints that were created by using the current AWS account, and that match the specified
         * filters, if any.
         * </p>
         * 
         * @param resolverEndpoints
         *        The resolver endpoints that were created by using the current AWS account, and that match the
         *        specified filters, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverEndpoints(Collection<ResolverEndpoint> resolverEndpoints);

        /**
         * <p>
         * The resolver endpoints that were created by using the current AWS account, and that match the specified
         * filters, if any.
         * </p>
         * 
         * @param resolverEndpoints
         *        The resolver endpoints that were created by using the current AWS account, and that match the
         *        specified filters, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverEndpoints(ResolverEndpoint... resolverEndpoints);

        /**
         * <p>
         * The resolver endpoints that were created by using the current AWS account, and that match the specified
         * filters, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResolverEndpoint>.Builder} avoiding the
         * need to create one manually via {@link List<ResolverEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResolverEndpoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #resolverEndpoints(List<ResolverEndpoint>)}.
         * 
         * @param resolverEndpoints
         *        a consumer that will call methods on {@link List<ResolverEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverEndpoints(List<ResolverEndpoint>)
         */
        Builder resolverEndpoints(Consumer<ResolverEndpoint.Builder>... resolverEndpoints);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<ResolverEndpoint> resolverEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverEndpointsResponse model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            resolverEndpoints(model.resolverEndpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<ResolverEndpoint.Builder> getResolverEndpoints() {
            return resolverEndpoints != null ? resolverEndpoints.stream().map(ResolverEndpoint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resolverEndpoints(Collection<ResolverEndpoint> resolverEndpoints) {
            this.resolverEndpoints = ResolverEndpointsCopier.copy(resolverEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverEndpoints(ResolverEndpoint... resolverEndpoints) {
            resolverEndpoints(Arrays.asList(resolverEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverEndpoints(Consumer<ResolverEndpoint.Builder>... resolverEndpoints) {
            resolverEndpoints(Stream.of(resolverEndpoints).map(c -> ResolverEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResolverEndpoints(Collection<ResolverEndpoint.BuilderImpl> resolverEndpoints) {
            this.resolverEndpoints = ResolverEndpointsCopier.copyFromBuilder(resolverEndpoints);
        }

        @Override
        public ListResolverEndpointsResponse build() {
            return new ListResolverEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
