/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResolverEndpointRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<GetResolverEndpointRequest.Builder, GetResolverEndpointRequest> {
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResolverEndpointRequest::resolverEndpointId)).setter(setter(Builder::resolverEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_ENDPOINT_ID_FIELD));

    private final String resolverEndpointId;

    private GetResolverEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.resolverEndpointId = builder.resolverEndpointId;
    }

    /**
     * <p>
     * The ID of the resolver endpoint that you want to get information about.
     * </p>
     * 
     * @return The ID of the resolver endpoint that you want to get information about.
     */
    public String resolverEndpointId() {
        return resolverEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverEndpointId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResolverEndpointRequest)) {
            return false;
        }
        GetResolverEndpointRequest other = (GetResolverEndpointRequest) obj;
        return Objects.equals(resolverEndpointId(), other.resolverEndpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetResolverEndpointRequest").add("ResolverEndpointId", resolverEndpointId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverEndpointId":
            return Optional.ofNullable(clazz.cast(resolverEndpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResolverEndpointRequest, T> g) {
        return obj -> g.apply((GetResolverEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResolverEndpointRequest> {
        /**
         * <p>
         * The ID of the resolver endpoint that you want to get information about.
         * </p>
         * 
         * @param resolverEndpointId
         *        The ID of the resolver endpoint that you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverEndpointId(String resolverEndpointId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resolverEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResolverEndpointRequest model) {
            super(model);
            resolverEndpointId(model.resolverEndpointId);
        }

        public final String getResolverEndpointId() {
            return resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResolverEndpointRequest build() {
            return new GetResolverEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
