/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateResolverEndpointIpAddressResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<DisassociateResolverEndpointIpAddressResponse.Builder, DisassociateResolverEndpointIpAddressResponse> {
    private static final SdkField<ResolverEndpoint> RESOLVER_ENDPOINT_FIELD = SdkField
            .<ResolverEndpoint> builder(MarshallingType.SDK_POJO)
            .getter(getter(DisassociateResolverEndpointIpAddressResponse::resolverEndpoint))
            .setter(setter(Builder::resolverEndpoint)).constructor(ResolverEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_ENDPOINT_FIELD));

    private final ResolverEndpoint resolverEndpoint;

    private DisassociateResolverEndpointIpAddressResponse(BuilderImpl builder) {
        super(builder);
        this.resolverEndpoint = builder.resolverEndpoint;
    }

    /**
     * <p>
     * The response to an <code>DisassociateResolverEndpointIpAddress</code> request.
     * </p>
     * 
     * @return The response to an <code>DisassociateResolverEndpointIpAddress</code> request.
     */
    public ResolverEndpoint resolverEndpoint() {
        return resolverEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverEndpoint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResolverEndpointIpAddressResponse)) {
            return false;
        }
        DisassociateResolverEndpointIpAddressResponse other = (DisassociateResolverEndpointIpAddressResponse) obj;
        return Objects.equals(resolverEndpoint(), other.resolverEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DisassociateResolverEndpointIpAddressResponse").add("ResolverEndpoint", resolverEndpoint())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverEndpoint":
            return Optional.ofNullable(clazz.cast(resolverEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResolverEndpointIpAddressResponse, T> g) {
        return obj -> g.apply((DisassociateResolverEndpointIpAddressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateResolverEndpointIpAddressResponse> {
        /**
         * <p>
         * The response to an <code>DisassociateResolverEndpointIpAddress</code> request.
         * </p>
         * 
         * @param resolverEndpoint
         *        The response to an <code>DisassociateResolverEndpointIpAddress</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverEndpoint(ResolverEndpoint resolverEndpoint);

        /**
         * <p>
         * The response to an <code>DisassociateResolverEndpointIpAddress</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link ResolverEndpoint.Builder} avoiding the need to
         * create one manually via {@link ResolverEndpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResolverEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #resolverEndpoint(ResolverEndpoint)}.
         * 
         * @param resolverEndpoint
         *        a consumer that will call methods on {@link ResolverEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverEndpoint(ResolverEndpoint)
         */
        default Builder resolverEndpoint(Consumer<ResolverEndpoint.Builder> resolverEndpoint) {
            return resolverEndpoint(ResolverEndpoint.builder().applyMutation(resolverEndpoint).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private ResolverEndpoint resolverEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResolverEndpointIpAddressResponse model) {
            super(model);
            resolverEndpoint(model.resolverEndpoint);
        }

        public final ResolverEndpoint.Builder getResolverEndpoint() {
            return resolverEndpoint != null ? resolverEndpoint.toBuilder() : null;
        }

        @Override
        public final Builder resolverEndpoint(ResolverEndpoint resolverEndpoint) {
            this.resolverEndpoint = resolverEndpoint;
            return this;
        }

        public final void setResolverEndpoint(ResolverEndpoint.BuilderImpl resolverEndpoint) {
            this.resolverEndpoint = resolverEndpoint != null ? resolverEndpoint.build() : null;
        }

        @Override
        public DisassociateResolverEndpointIpAddressResponse build() {
            return new DisassociateResolverEndpointIpAddressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
