/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResolverRuleRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<CreateResolverRuleRequest.Builder, CreateResolverRuleRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRuleRequest::creatorRequestId)).setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRuleRequest::ruleTypeAsString)).setter(setter(Builder::ruleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleType").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRuleRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<List<TargetAddress>> TARGET_IPS_FIELD = SdkField
            .<List<TargetAddress>> builder(MarshallingType.LIST)
            .getter(getter(CreateResolverRuleRequest::targetIps))
            .setter(setter(Builder::targetIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateResolverRuleRequest::resolverEndpointId)).setter(setter(Builder::resolverEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateResolverRuleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD,
            NAME_FIELD, RULE_TYPE_FIELD, DOMAIN_NAME_FIELD, TARGET_IPS_FIELD, RESOLVER_ENDPOINT_ID_FIELD, TAGS_FIELD));

    private final String creatorRequestId;

    private final String name;

    private final String ruleType;

    private final String domainName;

    private final List<TargetAddress> targetIps;

    private final String resolverEndpointId;

    private final List<Tag> tags;

    private CreateResolverRuleRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.name = builder.name;
        this.ruleType = builder.ruleType;
        this.domainName = builder.domainName;
        this.targetIps = builder.targetIps;
        this.resolverEndpointId = builder.resolverEndpointId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of
     * executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a date/time
     * stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed requests to be retried without the
     *         risk of executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for
     *         example, a date/time stamp.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
     * </p>
     * 
     * @return A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Specify <code>FORWARD</code>. Other resolver rule types aren't supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleTypeOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return Specify <code>FORWARD</code>. Other resolver rule types aren't supported.
     * @see RuleTypeOption
     */
    public RuleTypeOption ruleType() {
        return RuleTypeOption.fromValue(ruleType);
    }

    /**
     * <p>
     * Specify <code>FORWARD</code>. Other resolver rule types aren't supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleTypeOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return Specify <code>FORWARD</code>. Other resolver rule types aren't supported.
     * @see RuleTypeOption
     */
    public String ruleTypeAsString() {
        return ruleType;
    }

    /**
     * <p>
     * DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>. If
     * a query matches multiple resolver rules (example.com and www.example.com), outbound DNS queries are routed using
     * the resolver rule that contains the most specific domain name (www.example.com).
     * </p>
     * 
     * @return DNS queries for this domain name are forwarded to the IP addresses that you specify in
     *         <code>TargetIps</code>. If a query matches multiple resolver rules (example.com and www.example.com),
     *         outbound DNS queries are routed using the resolver rule that contains the most specific domain name
     *         (www.example.com).
     */
    public String domainName() {
        return domainName;
    }

    /**
     * Returns true if the TargetIps property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTargetIps() {
        return targetIps != null && !(targetIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP
     * addresses with a comma.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetIps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate
     *         IP addresses with a comma.
     */
    public List<TargetAddress> targetIps() {
        return targetIps;
    }

    /**
     * <p>
     * The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that you
     * specify in <code>TargetIps</code>.
     * </p>
     * 
     * @return The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses
     *         that you specify in <code>TargetIps</code>.
     */
    public String resolverEndpointId() {
        return resolverEndpointId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the tag keys and values that you want to associate with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the tag keys and values that you want to associate with the endpoint.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(targetIps());
        hashCode = 31 * hashCode + Objects.hashCode(resolverEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResolverRuleRequest)) {
            return false;
        }
        CreateResolverRuleRequest other = (CreateResolverRuleRequest) obj;
        return Objects.equals(creatorRequestId(), other.creatorRequestId()) && Objects.equals(name(), other.name())
                && Objects.equals(ruleTypeAsString(), other.ruleTypeAsString())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(targetIps(), other.targetIps())
                && Objects.equals(resolverEndpointId(), other.resolverEndpointId()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateResolverRuleRequest").add("CreatorRequestId", creatorRequestId()).add("Name", name())
                .add("RuleType", ruleTypeAsString()).add("DomainName", domainName()).add("TargetIps", targetIps())
                .add("ResolverEndpointId", resolverEndpointId()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleType":
            return Optional.ofNullable(clazz.cast(ruleTypeAsString()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "TargetIps":
            return Optional.ofNullable(clazz.cast(targetIps()));
        case "ResolverEndpointId":
            return Optional.ofNullable(clazz.cast(resolverEndpointId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResolverRuleRequest, T> g) {
        return obj -> g.apply((CreateResolverRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResolverRuleRequest> {
        /**
         * <p>
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of
         * executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for example, a
         * date/time stamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed requests to be retried without the
         *        risk of executing the operation twice. <code>CreatorRequestId</code> can be any unique string, for
         *        example, a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
         * </p>
         * 
         * @param name
         *        A friendly name that lets you easily find a rule in the Resolver dashboard in the Route 53 console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specify <code>FORWARD</code>. Other resolver rule types aren't supported.
         * </p>
         * 
         * @param ruleType
         *        Specify <code>FORWARD</code>. Other resolver rule types aren't supported.
         * @see RuleTypeOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleTypeOption
         */
        Builder ruleType(String ruleType);

        /**
         * <p>
         * Specify <code>FORWARD</code>. Other resolver rule types aren't supported.
         * </p>
         * 
         * @param ruleType
         *        Specify <code>FORWARD</code>. Other resolver rule types aren't supported.
         * @see RuleTypeOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleTypeOption
         */
        Builder ruleType(RuleTypeOption ruleType);

        /**
         * <p>
         * DNS queries for this domain name are forwarded to the IP addresses that you specify in <code>TargetIps</code>
         * . If a query matches multiple resolver rules (example.com and www.example.com), outbound DNS queries are
         * routed using the resolver rule that contains the most specific domain name (www.example.com).
         * </p>
         * 
         * @param domainName
         *        DNS queries for this domain name are forwarded to the IP addresses that you specify in
         *        <code>TargetIps</code>. If a query matches multiple resolver rules (example.com and www.example.com),
         *        outbound DNS queries are routed using the resolver rule that contains the most specific domain name
         *        (www.example.com).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP
         * addresses with a comma.
         * </p>
         * 
         * @param targetIps
         *        The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses.
         *        Separate IP addresses with a comma.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIps(Collection<TargetAddress> targetIps);

        /**
         * <p>
         * The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP
         * addresses with a comma.
         * </p>
         * 
         * @param targetIps
         *        The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses.
         *        Separate IP addresses with a comma.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIps(TargetAddress... targetIps);

        /**
         * <p>
         * The IPs that you want Resolver to forward DNS queries to. You can specify only IPv4 addresses. Separate IP
         * addresses with a comma.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetAddress>.Builder} avoiding the need
         * to create one manually via {@link List<TargetAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetAddress>.Builder#build()} is called immediately and
         * its result is passed to {@link #targetIps(List<TargetAddress>)}.
         * 
         * @param targetIps
         *        a consumer that will call methods on {@link List<TargetAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetIps(List<TargetAddress>)
         */
        Builder targetIps(Consumer<TargetAddress.Builder>... targetIps);

        /**
         * <p>
         * The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses that
         * you specify in <code>TargetIps</code>.
         * </p>
         * 
         * @param resolverEndpointId
         *        The ID of the outbound resolver endpoint that you want to use to route DNS queries to the IP addresses
         *        that you specify in <code>TargetIps</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverEndpointId(String resolverEndpointId);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the endpoint.
         * </p>
         * 
         * @param tags
         *        A list of the tag keys and values that you want to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the endpoint.
         * </p>
         * 
         * @param tags
         *        A list of the tag keys and values that you want to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of the tag keys and values that you want to associate with the endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String creatorRequestId;

        private String name;

        private String ruleType;

        private String domainName;

        private List<TargetAddress> targetIps = DefaultSdkAutoConstructList.getInstance();

        private String resolverEndpointId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResolverRuleRequest model) {
            super(model);
            creatorRequestId(model.creatorRequestId);
            name(model.name);
            ruleType(model.ruleType);
            domainName(model.domainName);
            targetIps(model.targetIps);
            resolverEndpointId(model.resolverEndpointId);
            tags(model.tags);
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRuleType() {
            return ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleTypeOption ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<TargetAddress.Builder> getTargetIps() {
            return targetIps != null ? targetIps.stream().map(TargetAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetIps(Collection<TargetAddress> targetIps) {
            this.targetIps = TargetListCopier.copy(targetIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIps(TargetAddress... targetIps) {
            targetIps(Arrays.asList(targetIps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIps(Consumer<TargetAddress.Builder>... targetIps) {
            targetIps(Stream.of(targetIps).map(c -> TargetAddress.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTargetIps(Collection<TargetAddress.BuilderImpl> targetIps) {
            this.targetIps = TargetListCopier.copyFromBuilder(targetIps);
        }

        public final String getResolverEndpointId() {
            return resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResolverRuleRequest build() {
            return new CreateResolverRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
