/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateResolverRuleRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<AssociateResolverRuleRequest.Builder, AssociateResolverRuleRequest> {
    private static final SdkField<String> RESOLVER_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateResolverRuleRequest::resolverRuleId)).setter(setter(Builder::resolverRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateResolverRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateResolverRuleRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_RULE_ID_FIELD,
            NAME_FIELD, VPC_ID_FIELD));

    private final String resolverRuleId;

    private final String name;

    private final String vpcId;

    private AssociateResolverRuleRequest(BuilderImpl builder) {
        super(builder);
        this.resolverRuleId = builder.resolverRuleId;
        this.name = builder.name;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The ID of the resolver rule that you want to associate with the VPC. To list the existing resolver rules, use
     * <a>ListResolverRules</a>.
     * </p>
     * 
     * @return The ID of the resolver rule that you want to associate with the VPC. To list the existing resolver rules,
     *         use <a>ListResolverRules</a>.
     */
    public String resolverRuleId() {
        return resolverRuleId;
    }

    /**
     * <p>
     * A name for the association that you're creating between a resolver rule and a VPC.
     * </p>
     * 
     * @return A name for the association that you're creating between a resolver rule and a VPC.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the VPC that you want to associate the resolver rule with.
     * </p>
     * 
     * @return The ID of the VPC that you want to associate the resolver rule with.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResolverRuleRequest)) {
            return false;
        }
        AssociateResolverRuleRequest other = (AssociateResolverRuleRequest) obj;
        return Objects.equals(resolverRuleId(), other.resolverRuleId()) && Objects.equals(name(), other.name())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateResolverRuleRequest").add("ResolverRuleId", resolverRuleId()).add("Name", name())
                .add("VPCId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverRuleId":
            return Optional.ofNullable(clazz.cast(resolverRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VPCId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateResolverRuleRequest, T> g) {
        return obj -> g.apply((AssociateResolverRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateResolverRuleRequest> {
        /**
         * <p>
         * The ID of the resolver rule that you want to associate with the VPC. To list the existing resolver rules, use
         * <a>ListResolverRules</a>.
         * </p>
         * 
         * @param resolverRuleId
         *        The ID of the resolver rule that you want to associate with the VPC. To list the existing resolver
         *        rules, use <a>ListResolverRules</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRuleId(String resolverRuleId);

        /**
         * <p>
         * A name for the association that you're creating between a resolver rule and a VPC.
         * </p>
         * 
         * @param name
         *        A name for the association that you're creating between a resolver rule and a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the VPC that you want to associate the resolver rule with.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC that you want to associate the resolver rule with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resolverRuleId;

        private String name;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateResolverRuleRequest model) {
            super(model);
            resolverRuleId(model.resolverRuleId);
            name(model.name);
            vpcId(model.vpcId);
        }

        public final String getResolverRuleId() {
            return resolverRuleId;
        }

        @Override
        public final Builder resolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
            return this;
        }

        public final void setResolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateResolverRuleRequest build() {
            return new AssociateResolverRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
