/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResolverRuleRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<UpdateResolverRuleRequest.Builder, UpdateResolverRuleRequest> {
    private static final SdkField<String> RESOLVER_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateResolverRuleRequest::resolverRuleId)).setter(setter(Builder::resolverRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleId").build()).build();

    private static final SdkField<ResolverRuleConfig> CONFIG_FIELD = SdkField
            .<ResolverRuleConfig> builder(MarshallingType.SDK_POJO).getter(getter(UpdateResolverRuleRequest::config))
            .setter(setter(Builder::config)).constructor(ResolverRuleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_RULE_ID_FIELD,
            CONFIG_FIELD));

    private final String resolverRuleId;

    private final ResolverRuleConfig config;

    private UpdateResolverRuleRequest(BuilderImpl builder) {
        super(builder);
        this.resolverRuleId = builder.resolverRuleId;
        this.config = builder.config;
    }

    /**
     * <p>
     * The ID of the resolver rule that you want to update.
     * </p>
     * 
     * @return The ID of the resolver rule that you want to update.
     */
    public String resolverRuleId() {
        return resolverRuleId;
    }

    /**
     * <p>
     * The new settings for the resolver rule.
     * </p>
     * 
     * @return The new settings for the resolver rule.
     */
    public ResolverRuleConfig config() {
        return config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverRuleRequest)) {
            return false;
        }
        UpdateResolverRuleRequest other = (UpdateResolverRuleRequest) obj;
        return Objects.equals(resolverRuleId(), other.resolverRuleId()) && Objects.equals(config(), other.config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateResolverRuleRequest").add("ResolverRuleId", resolverRuleId()).add("Config", config())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverRuleId":
            return Optional.ofNullable(clazz.cast(resolverRuleId()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverRuleRequest, T> g) {
        return obj -> g.apply((UpdateResolverRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResolverRuleRequest> {
        /**
         * <p>
         * The ID of the resolver rule that you want to update.
         * </p>
         * 
         * @param resolverRuleId
         *        The ID of the resolver rule that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRuleId(String resolverRuleId);

        /**
         * <p>
         * The new settings for the resolver rule.
         * </p>
         * 
         * @param config
         *        The new settings for the resolver rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(ResolverRuleConfig config);

        /**
         * <p>
         * The new settings for the resolver rule.
         * </p>
         * This is a convenience that creates an instance of the {@link ResolverRuleConfig.Builder} avoiding the need to
         * create one manually via {@link ResolverRuleConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResolverRuleConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #config(ResolverRuleConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link ResolverRuleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(ResolverRuleConfig)
         */
        default Builder config(Consumer<ResolverRuleConfig.Builder> config) {
            return config(ResolverRuleConfig.builder().applyMutation(config).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resolverRuleId;

        private ResolverRuleConfig config;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverRuleRequest model) {
            super(model);
            resolverRuleId(model.resolverRuleId);
            config(model.config);
        }

        public final String getResolverRuleId() {
            return resolverRuleId;
        }

        @Override
        public final Builder resolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
            return this;
        }

        public final void setResolverRuleId(String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
        }

        public final ResolverRuleConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        @Override
        public final Builder config(ResolverRuleConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(ResolverRuleConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverRuleRequest build() {
            return new UpdateResolverRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
