/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In the response to a <a>CreateResolverEndpoint</a>, <a>DeleteResolverEndpoint</a>, <a>GetResolverEndpoint</a>,
 * <a>ListResolverEndpoints</a>, or <a>UpdateResolverEndpoint</a> request, a complex type that contains settings for an
 * existing inbound or outbound resolver endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolverEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolverEndpoint.Builder, ResolverEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::creatorRequestId)).setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ResolverEndpoint::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::directionAsString)).setter(setter(Builder::direction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()).build();

    private static final SdkField<Integer> IP_ADDRESS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ResolverEndpoint::ipAddressCount)).setter(setter(Builder::ipAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressCount").build()).build();

    private static final SdkField<String> HOST_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::hostVPCId)).setter(setter(Builder::hostVPCId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostVPCId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResolverEndpoint::modificationTime)).setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CREATOR_REQUEST_ID_FIELD, ARN_FIELD, NAME_FIELD, SECURITY_GROUP_IDS_FIELD, DIRECTION_FIELD, IP_ADDRESS_COUNT_FIELD,
            HOST_VPC_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String creatorRequestId;

    private final String arn;

    private final String name;

    private final List<String> securityGroupIds;

    private final String direction;

    private final Integer ipAddressCount;

    private final String hostVPCId;

    private final String status;

    private final String statusMessage;

    private final String creationTime;

    private final String modificationTime;

    private ResolverEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorRequestId = builder.creatorRequestId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.securityGroupIds = builder.securityGroupIds;
        this.direction = builder.direction;
        this.ipAddressCount = builder.ipAddressCount;
        this.hostVPCId = builder.hostVPCId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    /**
     * <p>
     * The ID of the resolver endpoint.
     * </p>
     * 
     * @return The ID of the resolver endpoint.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A unique string that identifies the request that created the resolver endpoint. The <code>CreatorRequestId</code>
     * allows failed requests to be retried without the risk of executing the operation twice.
     * </p>
     * 
     * @return A unique string that identifies the request that created the resolver endpoint. The
     *         <code>CreatorRequestId</code> allows failed requests to be retried without the risk of executing the
     *         operation twice.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the resolver endpoint.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the resolver endpoint.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name that you assigned to the resolver endpoint when you submitted a <a>CreateResolverEndpoint</a> request.
     * </p>
     * 
     * @return The name that you assigned to the resolver endpoint when you submitted a <a>CreateResolverEndpoint</a>
     *         request.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of one or more security groups that control access to this VPC. The security group must include one or
     * more inbound resolver rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ID of one or more security groups that control access to this VPC. The security group must include
     *         one or more inbound resolver rules.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Indicates whether the resolver endpoint allows inbound or outbound DNS queries:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INBOUND</code>: allows DNS queries to your VPC from your network or another VPC
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUTBOUND</code>: allows DNS queries from your VPC to your network or another VPC
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link ResolverEndpointDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #directionAsString}.
     * </p>
     * 
     * @return Indicates whether the resolver endpoint allows inbound or outbound DNS queries:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INBOUND</code>: allows DNS queries to your VPC from your network or another VPC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUTBOUND</code>: allows DNS queries from your VPC to your network or another VPC
     *         </p>
     *         </li>
     * @see ResolverEndpointDirection
     */
    public ResolverEndpointDirection direction() {
        return ResolverEndpointDirection.fromValue(direction);
    }

    /**
     * <p>
     * Indicates whether the resolver endpoint allows inbound or outbound DNS queries:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INBOUND</code>: allows DNS queries to your VPC from your network or another VPC
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OUTBOUND</code>: allows DNS queries from your VPC to your network or another VPC
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #direction} will
     * return {@link ResolverEndpointDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #directionAsString}.
     * </p>
     * 
     * @return Indicates whether the resolver endpoint allows inbound or outbound DNS queries:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INBOUND</code>: allows DNS queries to your VPC from your network or another VPC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OUTBOUND</code>: allows DNS queries from your VPC to your network or another VPC
     *         </p>
     *         </li>
     * @see ResolverEndpointDirection
     */
    public String directionAsString() {
        return direction;
    }

    /**
     * <p>
     * The number of IP addresses that the resolver endpoint can use for DNS queries.
     * </p>
     * 
     * @return The number of IP addresses that the resolver endpoint can use for DNS queries.
     */
    public Integer ipAddressCount() {
        return ipAddressCount;
    }

    /**
     * <p>
     * The ID of the VPC that you want to create the resolver endpoint in.
     * </p>
     * 
     * @return The ID of the VPC that you want to create the resolver endpoint in.
     */
    public String hostVPCId() {
        return hostVPCId;
    }

    /**
     * <p>
     * A code that specifies the current status of the resolver endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A code that specifies the current status of the resolver endpoint.
     * @see ResolverEndpointStatus
     */
    public ResolverEndpointStatus status() {
        return ResolverEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * A code that specifies the current status of the resolver endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A code that specifies the current status of the resolver endpoint.
     * @see ResolverEndpointStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed description of the status of the resolver endpoint.
     * </p>
     * 
     * @return A detailed description of the status of the resolver endpoint.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time
     *         (UTC).
     */
    public String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time
     *         (UTC).
     */
    public String modificationTime() {
        return modificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hostVPCId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverEndpoint)) {
            return false;
        }
        ResolverEndpoint other = (ResolverEndpoint) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(directionAsString(), other.directionAsString())
                && Objects.equals(ipAddressCount(), other.ipAddressCount()) && Objects.equals(hostVPCId(), other.hostVPCId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modificationTime(), other.modificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResolverEndpoint").add("Id", id()).add("CreatorRequestId", creatorRequestId()).add("Arn", arn())
                .add("Name", name()).add("SecurityGroupIds", securityGroupIds()).add("Direction", directionAsString())
                .add("IpAddressCount", ipAddressCount()).add("HostVPCId", hostVPCId()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreationTime", creationTime())
                .add("ModificationTime", modificationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Direction":
            return Optional.ofNullable(clazz.cast(directionAsString()));
        case "IpAddressCount":
            return Optional.ofNullable(clazz.cast(ipAddressCount()));
        case "HostVPCId":
            return Optional.ofNullable(clazz.cast(hostVPCId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolverEndpoint, T> g) {
        return obj -> g.apply((ResolverEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolverEndpoint> {
        /**
         * <p>
         * The ID of the resolver endpoint.
         * </p>
         * 
         * @param id
         *        The ID of the resolver endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A unique string that identifies the request that created the resolver endpoint. The
         * <code>CreatorRequestId</code> allows failed requests to be retried without the risk of executing the
         * operation twice.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request that created the resolver endpoint. The
         *        <code>CreatorRequestId</code> allows failed requests to be retried without the risk of executing the
         *        operation twice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the resolver endpoint.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the resolver endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name that you assigned to the resolver endpoint when you submitted a <a>CreateResolverEndpoint</a>
         * request.
         * </p>
         * 
         * @param name
         *        The name that you assigned to the resolver endpoint when you submitted a <a>CreateResolverEndpoint</a>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of one or more security groups that control access to this VPC. The security group must include one or
         * more inbound resolver rules.
         * </p>
         * 
         * @param securityGroupIds
         *        The ID of one or more security groups that control access to this VPC. The security group must include
         *        one or more inbound resolver rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The ID of one or more security groups that control access to this VPC. The security group must include one or
         * more inbound resolver rules.
         * </p>
         * 
         * @param securityGroupIds
         *        The ID of one or more security groups that control access to this VPC. The security group must include
         *        one or more inbound resolver rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Indicates whether the resolver endpoint allows inbound or outbound DNS queries:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INBOUND</code>: allows DNS queries to your VPC from your network or another VPC
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUTBOUND</code>: allows DNS queries from your VPC to your network or another VPC
         * </p>
         * </li>
         * </ul>
         * 
         * @param direction
         *        Indicates whether the resolver endpoint allows inbound or outbound DNS queries:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INBOUND</code>: allows DNS queries to your VPC from your network or another VPC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUTBOUND</code>: allows DNS queries from your VPC to your network or another VPC
         *        </p>
         *        </li>
         * @see ResolverEndpointDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverEndpointDirection
         */
        Builder direction(String direction);

        /**
         * <p>
         * Indicates whether the resolver endpoint allows inbound or outbound DNS queries:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INBOUND</code>: allows DNS queries to your VPC from your network or another VPC
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OUTBOUND</code>: allows DNS queries from your VPC to your network or another VPC
         * </p>
         * </li>
         * </ul>
         * 
         * @param direction
         *        Indicates whether the resolver endpoint allows inbound or outbound DNS queries:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INBOUND</code>: allows DNS queries to your VPC from your network or another VPC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OUTBOUND</code>: allows DNS queries from your VPC to your network or another VPC
         *        </p>
         *        </li>
         * @see ResolverEndpointDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverEndpointDirection
         */
        Builder direction(ResolverEndpointDirection direction);

        /**
         * <p>
         * The number of IP addresses that the resolver endpoint can use for DNS queries.
         * </p>
         * 
         * @param ipAddressCount
         *        The number of IP addresses that the resolver endpoint can use for DNS queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressCount(Integer ipAddressCount);

        /**
         * <p>
         * The ID of the VPC that you want to create the resolver endpoint in.
         * </p>
         * 
         * @param hostVPCId
         *        The ID of the VPC that you want to create the resolver endpoint in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostVPCId(String hostVPCId);

        /**
         * <p>
         * A code that specifies the current status of the resolver endpoint.
         * </p>
         * 
         * @param status
         *        A code that specifies the current status of the resolver endpoint.
         * @see ResolverEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A code that specifies the current status of the resolver endpoint.
         * </p>
         * 
         * @param status
         *        A code that specifies the current status of the resolver endpoint.
         * @see ResolverEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverEndpointStatus
         */
        Builder status(ResolverEndpointStatus status);

        /**
         * <p>
         * A detailed description of the status of the resolver endpoint.
         * </p>
         * 
         * @param statusMessage
         *        A detailed description of the status of the resolver endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the endpoint was created, in Unix time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the endpoint was last modified, in Unix time format and Coordinated Universal
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(String modificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String creatorRequestId;

        private String arn;

        private String name;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String direction;

        private Integer ipAddressCount;

        private String hostVPCId;

        private String status;

        private String statusMessage;

        private String creationTime;

        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverEndpoint model) {
            id(model.id);
            creatorRequestId(model.creatorRequestId);
            arn(model.arn);
            name(model.name);
            securityGroupIds(model.securityGroupIds);
            direction(model.direction);
            ipAddressCount(model.ipAddressCount);
            hostVPCId(model.hostVPCId);
            status(model.status);
            statusMessage(model.statusMessage);
            creationTime(model.creationTime);
            modificationTime(model.modificationTime);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        public final String getDirectionAsString() {
            return direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(ResolverEndpointDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        public final Integer getIpAddressCount() {
            return ipAddressCount;
        }

        @Override
        public final Builder ipAddressCount(Integer ipAddressCount) {
            this.ipAddressCount = ipAddressCount;
            return this;
        }

        public final void setIpAddressCount(Integer ipAddressCount) {
            this.ipAddressCount = ipAddressCount;
        }

        public final String getHostVPCId() {
            return hostVPCId;
        }

        @Override
        public final Builder hostVPCId(String hostVPCId) {
            this.hostVPCId = hostVPCId;
            return this;
        }

        public final void setHostVPCId(String hostVPCId) {
            this.hostVPCId = hostVPCId;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResolverEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModificationTime() {
            return modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public ResolverEndpoint build() {
            return new ResolverEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
