/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResolverRulePolicyResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetResolverRulePolicyResponse.Builder, GetResolverRulePolicyResponse> {
    private static final SdkField<String> RESOLVER_RULE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetResolverRulePolicyResponse::resolverRulePolicy)).setter(setter(Builder::resolverRulePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRulePolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_RULE_POLICY_FIELD));

    private final String resolverRulePolicy;

    private GetResolverRulePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.resolverRulePolicy = builder.resolverRulePolicy;
    }

    /**
     * <p>
     * Information about the resolver rule policy that you specified in a <code>GetResolverRulePolicy</code> request.
     * </p>
     * 
     * @return Information about the resolver rule policy that you specified in a <code>GetResolverRulePolicy</code>
     *         request.
     */
    public String resolverRulePolicy() {
        return resolverRulePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverRulePolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResolverRulePolicyResponse)) {
            return false;
        }
        GetResolverRulePolicyResponse other = (GetResolverRulePolicyResponse) obj;
        return Objects.equals(resolverRulePolicy(), other.resolverRulePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetResolverRulePolicyResponse").add("ResolverRulePolicy", resolverRulePolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverRulePolicy":
            return Optional.ofNullable(clazz.cast(resolverRulePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResolverRulePolicyResponse, T> g) {
        return obj -> g.apply((GetResolverRulePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResolverRulePolicyResponse> {
        /**
         * <p>
         * Information about the resolver rule policy that you specified in a <code>GetResolverRulePolicy</code>
         * request.
         * </p>
         * 
         * @param resolverRulePolicy
         *        Information about the resolver rule policy that you specified in a <code>GetResolverRulePolicy</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRulePolicy(String resolverRulePolicy);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String resolverRulePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResolverRulePolicyResponse model) {
            super(model);
            resolverRulePolicy(model.resolverRulePolicy);
        }

        public final String getResolverRulePolicy() {
            return resolverRulePolicy;
        }

        @Override
        public final Builder resolverRulePolicy(String resolverRulePolicy) {
            this.resolverRulePolicy = resolverRulePolicy;
            return this;
        }

        public final void setResolverRulePolicy(String resolverRulePolicy) {
            this.resolverRulePolicy = resolverRulePolicy;
        }

        @Override
        public GetResolverRulePolicyResponse build() {
            return new GetResolverRulePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
