/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResolverRuleAssociationResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetResolverRuleAssociationResponse.Builder, GetResolverRuleAssociationResponse> {
    private static final SdkField<ResolverRuleAssociation> RESOLVER_RULE_ASSOCIATION_FIELD = SdkField
            .<ResolverRuleAssociation> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetResolverRuleAssociationResponse::resolverRuleAssociation))
            .setter(setter(Builder::resolverRuleAssociation)).constructor(ResolverRuleAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOLVER_RULE_ASSOCIATION_FIELD));

    private final ResolverRuleAssociation resolverRuleAssociation;

    private GetResolverRuleAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.resolverRuleAssociation = builder.resolverRuleAssociation;
    }

    /**
     * <p>
     * Information about the resolver rule association that you specified in a <code>GetResolverRuleAssociation</code>
     * request.
     * </p>
     * 
     * @return Information about the resolver rule association that you specified in a
     *         <code>GetResolverRuleAssociation</code> request.
     */
    public ResolverRuleAssociation resolverRuleAssociation() {
        return resolverRuleAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverRuleAssociation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResolverRuleAssociationResponse)) {
            return false;
        }
        GetResolverRuleAssociationResponse other = (GetResolverRuleAssociationResponse) obj;
        return Objects.equals(resolverRuleAssociation(), other.resolverRuleAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetResolverRuleAssociationResponse").add("ResolverRuleAssociation", resolverRuleAssociation())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverRuleAssociation":
            return Optional.ofNullable(clazz.cast(resolverRuleAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResolverRuleAssociationResponse, T> g) {
        return obj -> g.apply((GetResolverRuleAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResolverRuleAssociationResponse> {
        /**
         * <p>
         * Information about the resolver rule association that you specified in a
         * <code>GetResolverRuleAssociation</code> request.
         * </p>
         * 
         * @param resolverRuleAssociation
         *        Information about the resolver rule association that you specified in a
         *        <code>GetResolverRuleAssociation</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRuleAssociation(ResolverRuleAssociation resolverRuleAssociation);

        /**
         * <p>
         * Information about the resolver rule association that you specified in a
         * <code>GetResolverRuleAssociation</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link ResolverRuleAssociation.Builder} avoiding the
         * need to create one manually via {@link ResolverRuleAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResolverRuleAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #resolverRuleAssociation(ResolverRuleAssociation)}.
         * 
         * @param resolverRuleAssociation
         *        a consumer that will call methods on {@link ResolverRuleAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverRuleAssociation(ResolverRuleAssociation)
         */
        default Builder resolverRuleAssociation(Consumer<ResolverRuleAssociation.Builder> resolverRuleAssociation) {
            return resolverRuleAssociation(ResolverRuleAssociation.builder().applyMutation(resolverRuleAssociation).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private ResolverRuleAssociation resolverRuleAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResolverRuleAssociationResponse model) {
            super(model);
            resolverRuleAssociation(model.resolverRuleAssociation);
        }

        public final ResolverRuleAssociation.Builder getResolverRuleAssociation() {
            return resolverRuleAssociation != null ? resolverRuleAssociation.toBuilder() : null;
        }

        @Override
        public final Builder resolverRuleAssociation(ResolverRuleAssociation resolverRuleAssociation) {
            this.resolverRuleAssociation = resolverRuleAssociation;
            return this;
        }

        public final void setResolverRuleAssociation(ResolverRuleAssociation.BuilderImpl resolverRuleAssociation) {
            this.resolverRuleAssociation = resolverRuleAssociation != null ? resolverRuleAssociation.build() : null;
        }

        @Override
        public GetResolverRuleAssociationResponse build() {
            return new GetResolverRuleAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
