/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53profiles.model.ProfileStatus;
import software.amazon.awssdk.services.route53profiles.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Profile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Profile> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Profile.getter(Profile::arn)).setter(Profile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(Profile.getter(Profile::clientToken)).setter(Profile.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Profile.getter(Profile::creationTime)).setter(Profile.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Profile.getter(Profile::id)).setter(Profile.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModificationTime").getter(Profile.getter(Profile::modificationTime)).setter(Profile.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Profile.getter(Profile::name)).setter(Profile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(Profile.getter(Profile::ownerId)).setter(Profile.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareStatus").getter(Profile.getter(Profile::shareStatusAsString)).setter(Profile.setter(Builder::shareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Profile.getter(Profile::statusAsString)).setter(Profile.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(Profile.getter(Profile::statusMessage)).setter(Profile.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CLIENT_TOKEN_FIELD, CREATION_TIME_FIELD, ID_FIELD, MODIFICATION_TIME_FIELD, NAME_FIELD, OWNER_ID_FIELD, SHARE_STATUS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Profile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String clientToken;
    private final Instant creationTime;
    private final String id;
    private final Instant modificationTime;
    private final String name;
    private final String ownerId;
    private final String shareStatus;
    private final String status;
    private final String statusMessage;

    private Profile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.modificationTime = builder.modificationTime;
        this.name = builder.name;
        this.ownerId = builder.ownerId;
        this.shareStatus = builder.shareStatus;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final Instant modificationTime() {
        return this.modificationTime;
    }

    public final String name() {
        return this.name;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(this.shareStatus);
    }

    public final String shareStatusAsString() {
        return this.shareStatus;
    }

    public final ProfileStatus status() {
        return ProfileStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.modificationTime(), other.modificationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.shareStatusAsString(), other.shareStatusAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"Profile").add("Arn", (Object)this.arn()).add("ClientToken", (Object)this.clientToken()).add("CreationTime", (Object)this.creationTime()).add("Id", (Object)this.id()).add("ModificationTime", (Object)this.modificationTime()).add("Name", (Object)this.name()).add("OwnerId", (Object)this.ownerId()).add("ShareStatus", (Object)this.shareStatusAsString()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "ShareStatus": {
                return Optional.ofNullable(clazz.cast(this.shareStatusAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ModificationTime", MODIFICATION_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("ShareStatus", SHARE_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Profile, T> g) {
        return obj -> g.apply((Profile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String clientToken;
        private Instant creationTime;
        private String id;
        private Instant modificationTime;
        private String name;
        private String ownerId;
        private String shareStatus;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Profile model) {
            this.arn(model.arn);
            this.clientToken(model.clientToken);
            this.creationTime(model.creationTime);
            this.id(model.id);
            this.modificationTime(model.modificationTime);
            this.name(model.name);
            this.ownerId(model.ownerId);
            this.shareStatus(model.shareStatus);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getModificationTime() {
            return this.modificationTime;
        }

        public final void setModificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(Instant modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getShareStatus() {
            return this.shareStatus;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Profile build() {
            return new Profile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Profile> {
        public Builder arn(String var1);

        public Builder clientToken(String var1);

        public Builder creationTime(Instant var1);

        public Builder id(String var1);

        public Builder modificationTime(Instant var1);

        public Builder name(String var1);

        public Builder ownerId(String var1);

        public Builder shareStatus(String var1);

        public Builder shareStatus(ShareStatus var1);

        public Builder status(String var1);

        public Builder status(ProfileStatus var1);

        public Builder statusMessage(String var1);
    }
}

