/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53profiles.model.ProfileResourceAssociation;
import software.amazon.awssdk.services.route53profiles.model.ProfileResourceAssociationsCopier;
import software.amazon.awssdk.services.route53profiles.model.Route53ProfilesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfileResourceAssociationsResponse
extends Route53ProfilesResponse
implements ToCopyableBuilder<Builder, ListProfileResourceAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProfileResourceAssociationsResponse.getter(ListProfileResourceAssociationsResponse::nextToken)).setter(ListProfileResourceAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ProfileResourceAssociation>> PROFILE_RESOURCE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileResourceAssociations").getter(ListProfileResourceAssociationsResponse.getter(ListProfileResourceAssociationsResponse::profileResourceAssociations)).setter(ListProfileResourceAssociationsResponse.setter(Builder::profileResourceAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileResourceAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileResourceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROFILE_RESOURCE_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ProfileResourceAssociations", PROFILE_RESOURCE_ASSOCIATIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<ProfileResourceAssociation> profileResourceAssociations;

    private ListProfileResourceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.profileResourceAssociations = builder.profileResourceAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProfileResourceAssociations() {
        return this.profileResourceAssociations != null && !(this.profileResourceAssociations instanceof SdkAutoConstructList);
    }

    public final List<ProfileResourceAssociation> profileResourceAssociations() {
        return this.profileResourceAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileResourceAssociations() ? this.profileResourceAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileResourceAssociationsResponse)) {
            return false;
        }
        ListProfileResourceAssociationsResponse other = (ListProfileResourceAssociationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasProfileResourceAssociations() == other.hasProfileResourceAssociations() && Objects.equals(this.profileResourceAssociations(), other.profileResourceAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfileResourceAssociationsResponse").add("NextToken", (Object)this.nextToken()).add("ProfileResourceAssociations", this.hasProfileResourceAssociations() ? this.profileResourceAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ProfileResourceAssociations": {
                return Optional.ofNullable(clazz.cast(this.profileResourceAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListProfileResourceAssociationsResponse, T> g) {
        return obj -> g.apply((ListProfileResourceAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ProfilesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ProfileResourceAssociation> profileResourceAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileResourceAssociationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.profileResourceAssociations(model.profileResourceAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProfileResourceAssociation.Builder> getProfileResourceAssociations() {
            List<ProfileResourceAssociation.Builder> result = ProfileResourceAssociationsCopier.copyToBuilder(this.profileResourceAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileResourceAssociations(Collection<ProfileResourceAssociation.BuilderImpl> profileResourceAssociations) {
            this.profileResourceAssociations = ProfileResourceAssociationsCopier.copyFromBuilder(profileResourceAssociations);
        }

        @Override
        public final Builder profileResourceAssociations(Collection<ProfileResourceAssociation> profileResourceAssociations) {
            this.profileResourceAssociations = ProfileResourceAssociationsCopier.copy(profileResourceAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileResourceAssociations(ProfileResourceAssociation ... profileResourceAssociations) {
            this.profileResourceAssociations(Arrays.asList(profileResourceAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileResourceAssociations(Consumer<ProfileResourceAssociation.Builder> ... profileResourceAssociations) {
            this.profileResourceAssociations(Stream.of(profileResourceAssociations).map(c -> (ProfileResourceAssociation)((ProfileResourceAssociation.Builder)ProfileResourceAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProfileResourceAssociationsResponse build() {
            return new ListProfileResourceAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53ProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfileResourceAssociationsResponse> {
        public Builder nextToken(String var1);

        public Builder profileResourceAssociations(Collection<ProfileResourceAssociation> var1);

        public Builder profileResourceAssociations(ProfileResourceAssociation ... var1);

        public Builder profileResourceAssociations(Consumer<ProfileResourceAssociation.Builder> ... var1);
    }
}

