/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53profiles.Route53ProfilesClient;
import software.amazon.awssdk.services.route53profiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53profiles.model.ListProfileResourceAssociationsRequest;
import software.amazon.awssdk.services.route53profiles.model.ListProfileResourceAssociationsResponse;
import software.amazon.awssdk.services.route53profiles.model.ProfileResourceAssociation;

public class ListProfileResourceAssociationsIterable
implements SdkIterable<ListProfileResourceAssociationsResponse> {
    private final Route53ProfilesClient client;
    private final ListProfileResourceAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfileResourceAssociationsIterable(Route53ProfilesClient client, ListProfileResourceAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProfileResourceAssociationsResponseFetcher();
    }

    public Iterator<ListProfileResourceAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProfileResourceAssociation> profileResourceAssociations() {
        Function<ListProfileResourceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileResourceAssociations() != null) {
                return response.profileResourceAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProfileResourceAssociationsResponseFetcher
    implements SyncPageFetcher<ListProfileResourceAssociationsResponse> {
        private ListProfileResourceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileResourceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfileResourceAssociationsResponse nextPage(ListProfileResourceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListProfileResourceAssociationsIterable.this.client.listProfileResourceAssociations(ListProfileResourceAssociationsIterable.this.firstRequest);
            }
            return ListProfileResourceAssociationsIterable.this.client.listProfileResourceAssociations((ListProfileResourceAssociationsRequest)((Object)ListProfileResourceAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

