/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverAsyncClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.HostedZoneAssociationSummary;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse;

public class ListHostedZoneAssociationsPublisher
implements SdkPublisher<ListHostedZoneAssociationsResponse> {
    private final Route53GlobalResolverAsyncClient client;
    private final ListHostedZoneAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHostedZoneAssociationsPublisher(Route53GlobalResolverAsyncClient client, ListHostedZoneAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHostedZoneAssociationsPublisher(Route53GlobalResolverAsyncClient client, ListHostedZoneAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHostedZoneAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHostedZoneAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HostedZoneAssociationSummary> hostedZoneAssociations() {
        Function<ListHostedZoneAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hostedZoneAssociations() != null) {
                return response.hostedZoneAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHostedZoneAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHostedZoneAssociationsResponseFetcher
    implements AsyncPageFetcher<ListHostedZoneAssociationsResponse> {
        private ListHostedZoneAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListHostedZoneAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHostedZoneAssociationsResponse> nextPage(ListHostedZoneAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListHostedZoneAssociationsPublisher.this.client.listHostedZoneAssociations(ListHostedZoneAssociationsPublisher.this.firstRequest);
            }
            return ListHostedZoneAssociationsPublisher.this.client.listHostedZoneAssociations((ListHostedZoneAssociationsRequest)((Object)ListHostedZoneAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

