/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53globalresolver.model.BlockOverrideDnsQueryType;
import software.amazon.awssdk.services.route53globalresolver.model.CRResourceStatus;
import software.amazon.awssdk.services.route53globalresolver.model.ConfidenceThreshold;
import software.amazon.awssdk.services.route53globalresolver.model.DnsAdvancedProtection;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallBlockResponse;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallRuleAction;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFirewallRuleResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, GetFirewallRuleResponse> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::actionAsString)).setter(GetFirewallRuleResponse.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> BLOCK_OVERRIDE_DNS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockOverrideDnsType").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::blockOverrideDnsTypeAsString)).setter(GetFirewallRuleResponse.setter(Builder::blockOverrideDnsType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideDnsType").build()}).build();
    private static final SdkField<String> BLOCK_OVERRIDE_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockOverrideDomain").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::blockOverrideDomain)).setter(GetFirewallRuleResponse.setter(Builder::blockOverrideDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideDomain").build()}).build();
    private static final SdkField<Integer> BLOCK_OVERRIDE_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("blockOverrideTtl").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::blockOverrideTtl)).setter(GetFirewallRuleResponse.setter(Builder::blockOverrideTtl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideTtl").build()}).build();
    private static final SdkField<String> BLOCK_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockResponse").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::blockResponseAsString)).setter(GetFirewallRuleResponse.setter(Builder::blockResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockResponse").build()}).build();
    private static final SdkField<String> CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confidenceThreshold").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::confidenceThresholdAsString)).setter(GetFirewallRuleResponse.setter(Builder::confidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::createdAt)).setter(GetFirewallRuleResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::description)).setter(GetFirewallRuleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DNS_ADVANCED_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsAdvancedProtection").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::dnsAdvancedProtectionAsString)).setter(GetFirewallRuleResponse.setter(Builder::dnsAdvancedProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsAdvancedProtection").build()}).build();
    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firewallDomainListId").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::firewallDomainListId)).setter(GetFirewallRuleResponse.setter(Builder::firewallDomainListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallDomainListId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::id)).setter(GetFirewallRuleResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::name)).setter(GetFirewallRuleResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Long> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("priority").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::priority)).setter(GetFirewallRuleResponse.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsViewId").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::dnsViewId)).setter(GetFirewallRuleResponse.setter(Builder::dnsViewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViewId").build()}).build();
    private static final SdkField<String> QUERY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryType").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::queryType)).setter(GetFirewallRuleResponse.setter(Builder::queryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::statusAsString)).setter(GetFirewallRuleResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetFirewallRuleResponse.getter(GetFirewallRuleResponse::updatedAt)).setter(GetFirewallRuleResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BLOCK_OVERRIDE_DNS_TYPE_FIELD, BLOCK_OVERRIDE_DOMAIN_FIELD, BLOCK_OVERRIDE_TTL_FIELD, BLOCK_RESPONSE_FIELD, CONFIDENCE_THRESHOLD_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DNS_ADVANCED_PROTECTION_FIELD, FIREWALL_DOMAIN_LIST_ID_FIELD, ID_FIELD, NAME_FIELD, PRIORITY_FIELD, DNS_VIEW_ID_FIELD, QUERY_TYPE_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFirewallRuleResponse.memberNameToFieldInitializer();
    private final String action;
    private final String blockOverrideDnsType;
    private final String blockOverrideDomain;
    private final Integer blockOverrideTtl;
    private final String blockResponse;
    private final String confidenceThreshold;
    private final Instant createdAt;
    private final String description;
    private final String dnsAdvancedProtection;
    private final String firewallDomainListId;
    private final String id;
    private final String name;
    private final Long priority;
    private final String dnsViewId;
    private final String queryType;
    private final String status;
    private final Instant updatedAt;

    private GetFirewallRuleResponse(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.blockOverrideDnsType = builder.blockOverrideDnsType;
        this.blockOverrideDomain = builder.blockOverrideDomain;
        this.blockOverrideTtl = builder.blockOverrideTtl;
        this.blockResponse = builder.blockResponse;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.dnsAdvancedProtection = builder.dnsAdvancedProtection;
        this.firewallDomainListId = builder.firewallDomainListId;
        this.id = builder.id;
        this.name = builder.name;
        this.priority = builder.priority;
        this.dnsViewId = builder.dnsViewId;
        this.queryType = builder.queryType;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final FirewallRuleAction action() {
        return FirewallRuleAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final BlockOverrideDnsQueryType blockOverrideDnsType() {
        return BlockOverrideDnsQueryType.fromValue(this.blockOverrideDnsType);
    }

    public final String blockOverrideDnsTypeAsString() {
        return this.blockOverrideDnsType;
    }

    public final String blockOverrideDomain() {
        return this.blockOverrideDomain;
    }

    public final Integer blockOverrideTtl() {
        return this.blockOverrideTtl;
    }

    public final FirewallBlockResponse blockResponse() {
        return FirewallBlockResponse.fromValue(this.blockResponse);
    }

    public final String blockResponseAsString() {
        return this.blockResponse;
    }

    public final ConfidenceThreshold confidenceThreshold() {
        return ConfidenceThreshold.fromValue(this.confidenceThreshold);
    }

    public final String confidenceThresholdAsString() {
        return this.confidenceThreshold;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final DnsAdvancedProtection dnsAdvancedProtection() {
        return DnsAdvancedProtection.fromValue(this.dnsAdvancedProtection);
    }

    public final String dnsAdvancedProtectionAsString() {
        return this.dnsAdvancedProtection;
    }

    public final String firewallDomainListId() {
        return this.firewallDomainListId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Long priority() {
        return this.priority;
    }

    public final String dnsViewId() {
        return this.dnsViewId;
    }

    public final String queryType() {
        return this.queryType;
    }

    public final CRResourceStatus status() {
        return CRResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideDnsTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideTtl());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceThresholdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsAdvancedProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryType());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFirewallRuleResponse)) {
            return false;
        }
        GetFirewallRuleResponse other = (GetFirewallRuleResponse)((Object)obj);
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.blockOverrideDnsTypeAsString(), other.blockOverrideDnsTypeAsString()) && Objects.equals(this.blockOverrideDomain(), other.blockOverrideDomain()) && Objects.equals(this.blockOverrideTtl(), other.blockOverrideTtl()) && Objects.equals(this.blockResponseAsString(), other.blockResponseAsString()) && Objects.equals(this.confidenceThresholdAsString(), other.confidenceThresholdAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dnsAdvancedProtectionAsString(), other.dnsAdvancedProtectionAsString()) && Objects.equals(this.firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.dnsViewId(), other.dnsViewId()) && Objects.equals(this.queryType(), other.queryType()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetFirewallRuleResponse").add("Action", (Object)this.actionAsString()).add("BlockOverrideDnsType", (Object)this.blockOverrideDnsTypeAsString()).add("BlockOverrideDomain", (Object)this.blockOverrideDomain()).add("BlockOverrideTtl", (Object)this.blockOverrideTtl()).add("BlockResponse", (Object)this.blockResponseAsString()).add("ConfidenceThreshold", (Object)this.confidenceThresholdAsString()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("DnsAdvancedProtection", (Object)this.dnsAdvancedProtectionAsString()).add("FirewallDomainListId", (Object)this.firewallDomainListId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("DnsViewId", (Object)this.dnsViewId()).add("QueryType", (Object)this.queryType()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "blockOverrideDnsType": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideDnsTypeAsString()));
            }
            case "blockOverrideDomain": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideDomain()));
            }
            case "blockOverrideTtl": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideTtl()));
            }
            case "blockResponse": {
                return Optional.ofNullable(clazz.cast(this.blockResponseAsString()));
            }
            case "confidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.confidenceThresholdAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "dnsAdvancedProtection": {
                return Optional.ofNullable(clazz.cast(this.dnsAdvancedProtectionAsString()));
            }
            case "firewallDomainListId": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainListId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "dnsViewId": {
                return Optional.ofNullable(clazz.cast(this.dnsViewId()));
            }
            case "queryType": {
                return Optional.ofNullable(clazz.cast(this.queryType()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", ACTION_FIELD);
        map.put("blockOverrideDnsType", BLOCK_OVERRIDE_DNS_TYPE_FIELD);
        map.put("blockOverrideDomain", BLOCK_OVERRIDE_DOMAIN_FIELD);
        map.put("blockOverrideTtl", BLOCK_OVERRIDE_TTL_FIELD);
        map.put("blockResponse", BLOCK_RESPONSE_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dnsAdvancedProtection", DNS_ADVANCED_PROTECTION_FIELD);
        map.put("firewallDomainListId", FIREWALL_DOMAIN_LIST_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("queryType", QUERY_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFirewallRuleResponse, T> g) {
        return obj -> g.apply((GetFirewallRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String action;
        private String blockOverrideDnsType;
        private String blockOverrideDomain;
        private Integer blockOverrideTtl;
        private String blockResponse;
        private String confidenceThreshold;
        private Instant createdAt;
        private String description;
        private String dnsAdvancedProtection;
        private String firewallDomainListId;
        private String id;
        private String name;
        private Long priority;
        private String dnsViewId;
        private String queryType;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFirewallRuleResponse model) {
            super(model);
            this.action(model.action);
            this.blockOverrideDnsType(model.blockOverrideDnsType);
            this.blockOverrideDomain(model.blockOverrideDomain);
            this.blockOverrideTtl(model.blockOverrideTtl);
            this.blockResponse(model.blockResponse);
            this.confidenceThreshold(model.confidenceThreshold);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.dnsAdvancedProtection(model.dnsAdvancedProtection);
            this.firewallDomainListId(model.firewallDomainListId);
            this.id(model.id);
            this.name(model.name);
            this.priority(model.priority);
            this.dnsViewId(model.dnsViewId);
            this.queryType(model.queryType);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FirewallRuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBlockOverrideDnsType() {
            return this.blockOverrideDnsType;
        }

        public final void setBlockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
        }

        @Override
        public final Builder blockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
            return this;
        }

        @Override
        public final Builder blockOverrideDnsType(BlockOverrideDnsQueryType blockOverrideDnsType) {
            this.blockOverrideDnsType(blockOverrideDnsType == null ? null : blockOverrideDnsType.toString());
            return this;
        }

        public final String getBlockOverrideDomain() {
            return this.blockOverrideDomain;
        }

        public final void setBlockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
        }

        @Override
        public final Builder blockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
            return this;
        }

        public final Integer getBlockOverrideTtl() {
            return this.blockOverrideTtl;
        }

        public final void setBlockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
        }

        @Override
        public final Builder blockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
            return this;
        }

        public final String getBlockResponse() {
            return this.blockResponse;
        }

        public final void setBlockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
        }

        @Override
        public final Builder blockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
            return this;
        }

        @Override
        public final Builder blockResponse(FirewallBlockResponse blockResponse) {
            this.blockResponse(blockResponse == null ? null : blockResponse.toString());
            return this;
        }

        public final String getConfidenceThreshold() {
            return this.confidenceThreshold;
        }

        public final void setConfidenceThreshold(String confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(String confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        @Override
        public final Builder confidenceThreshold(ConfidenceThreshold confidenceThreshold) {
            this.confidenceThreshold(confidenceThreshold == null ? null : confidenceThreshold.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDnsAdvancedProtection() {
            return this.dnsAdvancedProtection;
        }

        public final void setDnsAdvancedProtection(String dnsAdvancedProtection) {
            this.dnsAdvancedProtection = dnsAdvancedProtection;
        }

        @Override
        public final Builder dnsAdvancedProtection(String dnsAdvancedProtection) {
            this.dnsAdvancedProtection = dnsAdvancedProtection;
            return this;
        }

        @Override
        public final Builder dnsAdvancedProtection(DnsAdvancedProtection dnsAdvancedProtection) {
            this.dnsAdvancedProtection(dnsAdvancedProtection == null ? null : dnsAdvancedProtection.toString());
            return this;
        }

        public final String getFirewallDomainListId() {
            return this.firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getPriority() {
            return this.priority;
        }

        public final void setPriority(Long priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Long priority) {
            this.priority = priority;
            return this;
        }

        public final String getDnsViewId() {
            return this.dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final String getQueryType() {
            return this.queryType;
        }

        public final void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        @Override
        public final Builder queryType(String queryType) {
            this.queryType = queryType;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CRResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetFirewallRuleResponse build() {
            return new GetFirewallRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFirewallRuleResponse> {
        public Builder action(String var1);

        public Builder action(FirewallRuleAction var1);

        public Builder blockOverrideDnsType(String var1);

        public Builder blockOverrideDnsType(BlockOverrideDnsQueryType var1);

        public Builder blockOverrideDomain(String var1);

        public Builder blockOverrideTtl(Integer var1);

        public Builder blockResponse(String var1);

        public Builder blockResponse(FirewallBlockResponse var1);

        public Builder confidenceThreshold(String var1);

        public Builder confidenceThreshold(ConfidenceThreshold var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder dnsAdvancedProtection(String var1);

        public Builder dnsAdvancedProtection(DnsAdvancedProtection var1);

        public Builder firewallDomainListId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder priority(Long var1);

        public Builder dnsViewId(String var1);

        public Builder queryType(String var1);

        public Builder status(String var1);

        public Builder status(CRResourceStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

