/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53globalresolver.model.DnsSecValidationType;
import software.amazon.awssdk.services.route53globalresolver.model.EdnsClientSubnetType;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallRulesFailOpenType;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDnsViewRequest
extends Route53GlobalResolverRequest
implements ToCopyableBuilder<Builder, UpdateDnsViewRequest> {
    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsViewId").getter(UpdateDnsViewRequest.getter(UpdateDnsViewRequest::dnsViewId)).setter(UpdateDnsViewRequest.setter(Builder::dnsViewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dnsViewId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDnsViewRequest.getter(UpdateDnsViewRequest::name)).setter(UpdateDnsViewRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDnsViewRequest.getter(UpdateDnsViewRequest::description)).setter(UpdateDnsViewRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DNSSEC_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnssecValidation").getter(UpdateDnsViewRequest.getter(UpdateDnsViewRequest::dnssecValidationAsString)).setter(UpdateDnsViewRequest.setter(Builder::dnssecValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnssecValidation").build()}).build();
    private static final SdkField<String> EDNS_CLIENT_SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ednsClientSubnet").getter(UpdateDnsViewRequest.getter(UpdateDnsViewRequest::ednsClientSubnetAsString)).setter(UpdateDnsViewRequest.setter(Builder::ednsClientSubnet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ednsClientSubnet").build()}).build();
    private static final SdkField<String> FIREWALL_RULES_FAIL_OPEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firewallRulesFailOpen").getter(UpdateDnsViewRequest.getter(UpdateDnsViewRequest::firewallRulesFailOpenAsString)).setter(UpdateDnsViewRequest.setter(Builder::firewallRulesFailOpen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRulesFailOpen").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_VIEW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DNSSEC_VALIDATION_FIELD, EDNS_CLIENT_SUBNET_FIELD, FIREWALL_RULES_FAIL_OPEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDnsViewRequest.memberNameToFieldInitializer();
    private final String dnsViewId;
    private final String name;
    private final String description;
    private final String dnssecValidation;
    private final String ednsClientSubnet;
    private final String firewallRulesFailOpen;

    private UpdateDnsViewRequest(BuilderImpl builder) {
        super(builder);
        this.dnsViewId = builder.dnsViewId;
        this.name = builder.name;
        this.description = builder.description;
        this.dnssecValidation = builder.dnssecValidation;
        this.ednsClientSubnet = builder.ednsClientSubnet;
        this.firewallRulesFailOpen = builder.firewallRulesFailOpen;
    }

    public final String dnsViewId() {
        return this.dnsViewId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final DnsSecValidationType dnssecValidation() {
        return DnsSecValidationType.fromValue(this.dnssecValidation);
    }

    public final String dnssecValidationAsString() {
        return this.dnssecValidation;
    }

    public final EdnsClientSubnetType ednsClientSubnet() {
        return EdnsClientSubnetType.fromValue(this.ednsClientSubnet);
    }

    public final String ednsClientSubnetAsString() {
        return this.ednsClientSubnet;
    }

    public final FirewallRulesFailOpenType firewallRulesFailOpen() {
        return FirewallRulesFailOpenType.fromValue(this.firewallRulesFailOpen);
    }

    public final String firewallRulesFailOpenAsString() {
        return this.firewallRulesFailOpen;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnssecValidationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ednsClientSubnetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallRulesFailOpenAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDnsViewRequest)) {
            return false;
        }
        UpdateDnsViewRequest other = (UpdateDnsViewRequest)((Object)obj);
        return Objects.equals(this.dnsViewId(), other.dnsViewId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dnssecValidationAsString(), other.dnssecValidationAsString()) && Objects.equals(this.ednsClientSubnetAsString(), other.ednsClientSubnetAsString()) && Objects.equals(this.firewallRulesFailOpenAsString(), other.firewallRulesFailOpenAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDnsViewRequest").add("DnsViewId", (Object)this.dnsViewId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DnssecValidation", (Object)this.dnssecValidationAsString()).add("EdnsClientSubnet", (Object)this.ednsClientSubnetAsString()).add("FirewallRulesFailOpen", (Object)this.firewallRulesFailOpenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dnsViewId": {
                return Optional.ofNullable(clazz.cast(this.dnsViewId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "dnssecValidation": {
                return Optional.ofNullable(clazz.cast(this.dnssecValidationAsString()));
            }
            case "ednsClientSubnet": {
                return Optional.ofNullable(clazz.cast(this.ednsClientSubnetAsString()));
            }
            case "firewallRulesFailOpen": {
                return Optional.ofNullable(clazz.cast(this.firewallRulesFailOpenAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dnssecValidation", DNSSEC_VALIDATION_FIELD);
        map.put("ednsClientSubnet", EDNS_CLIENT_SUBNET_FIELD);
        map.put("firewallRulesFailOpen", FIREWALL_RULES_FAIL_OPEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDnsViewRequest, T> g) {
        return obj -> g.apply((UpdateDnsViewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverRequest.BuilderImpl
    implements Builder {
        private String dnsViewId;
        private String name;
        private String description;
        private String dnssecValidation;
        private String ednsClientSubnet;
        private String firewallRulesFailOpen;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDnsViewRequest model) {
            super(model);
            this.dnsViewId(model.dnsViewId);
            this.name(model.name);
            this.description(model.description);
            this.dnssecValidation(model.dnssecValidation);
            this.ednsClientSubnet(model.ednsClientSubnet);
            this.firewallRulesFailOpen(model.firewallRulesFailOpen);
        }

        public final String getDnsViewId() {
            return this.dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDnssecValidation() {
            return this.dnssecValidation;
        }

        public final void setDnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
        }

        @Override
        public final Builder dnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
            return this;
        }

        @Override
        public final Builder dnssecValidation(DnsSecValidationType dnssecValidation) {
            this.dnssecValidation(dnssecValidation == null ? null : dnssecValidation.toString());
            return this;
        }

        public final String getEdnsClientSubnet() {
            return this.ednsClientSubnet;
        }

        public final void setEdnsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
        }

        @Override
        public final Builder ednsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
            return this;
        }

        @Override
        public final Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet) {
            this.ednsClientSubnet(ednsClientSubnet == null ? null : ednsClientSubnet.toString());
            return this;
        }

        public final String getFirewallRulesFailOpen() {
            return this.firewallRulesFailOpen;
        }

        public final void setFirewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
        }

        @Override
        public final Builder firewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
            return this;
        }

        @Override
        public final Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen) {
            this.firewallRulesFailOpen(firewallRulesFailOpen == null ? null : firewallRulesFailOpen.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDnsViewRequest build() {
            return new UpdateDnsViewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDnsViewRequest> {
        public Builder dnsViewId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder dnssecValidation(String var1);

        public Builder dnssecValidation(DnsSecValidationType var1);

        public Builder ednsClientSubnet(String var1);

        public Builder ednsClientSubnet(EdnsClientSubnetType var1);

        public Builder firewallRulesFailOpen(String var1);

        public Builder firewallRulesFailOpen(FirewallRulesFailOpenType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

