/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53globalresolver.model.BlockOverrideDnsQueryType;
import software.amazon.awssdk.services.route53globalresolver.model.ConfidenceThreshold;
import software.amazon.awssdk.services.route53globalresolver.model.DnsAdvancedProtection;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallBlockResponse;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallRuleAction;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFirewallRuleRequest
extends Route53GlobalResolverRequest
implements ToCopyableBuilder<Builder, CreateFirewallRuleRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::actionAsString)).setter(CreateFirewallRuleRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> BLOCK_OVERRIDE_DNS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockOverrideDnsType").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::blockOverrideDnsTypeAsString)).setter(CreateFirewallRuleRequest.setter(Builder::blockOverrideDnsType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideDnsType").build()}).build();
    private static final SdkField<String> BLOCK_OVERRIDE_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockOverrideDomain").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::blockOverrideDomain)).setter(CreateFirewallRuleRequest.setter(Builder::blockOverrideDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideDomain").build()}).build();
    private static final SdkField<Integer> BLOCK_OVERRIDE_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("blockOverrideTtl").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::blockOverrideTtl)).setter(CreateFirewallRuleRequest.setter(Builder::blockOverrideTtl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideTtl").build()}).build();
    private static final SdkField<String> BLOCK_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockResponse").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::blockResponseAsString)).setter(CreateFirewallRuleRequest.setter(Builder::blockResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockResponse").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::clientToken)).setter(CreateFirewallRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confidenceThreshold").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::confidenceThresholdAsString)).setter(CreateFirewallRuleRequest.setter(Builder::confidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::description)).setter(CreateFirewallRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DNS_ADVANCED_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsAdvancedProtection").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::dnsAdvancedProtectionAsString)).setter(CreateFirewallRuleRequest.setter(Builder::dnsAdvancedProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsAdvancedProtection").build()}).build();
    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firewallDomainListId").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::firewallDomainListId)).setter(CreateFirewallRuleRequest.setter(Builder::firewallDomainListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallDomainListId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::name)).setter(CreateFirewallRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Long> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("priority").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::priority)).setter(CreateFirewallRuleRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsViewId").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::dnsViewId)).setter(CreateFirewallRuleRequest.setter(Builder::dnsViewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViewId").build()}).build();
    private static final SdkField<String> Q_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("qType").getter(CreateFirewallRuleRequest.getter(CreateFirewallRuleRequest::qType)).setter(CreateFirewallRuleRequest.setter(Builder::qType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BLOCK_OVERRIDE_DNS_TYPE_FIELD, BLOCK_OVERRIDE_DOMAIN_FIELD, BLOCK_OVERRIDE_TTL_FIELD, BLOCK_RESPONSE_FIELD, CLIENT_TOKEN_FIELD, CONFIDENCE_THRESHOLD_FIELD, DESCRIPTION_FIELD, DNS_ADVANCED_PROTECTION_FIELD, FIREWALL_DOMAIN_LIST_ID_FIELD, NAME_FIELD, PRIORITY_FIELD, DNS_VIEW_ID_FIELD, Q_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFirewallRuleRequest.memberNameToFieldInitializer();
    private final String action;
    private final String blockOverrideDnsType;
    private final String blockOverrideDomain;
    private final Integer blockOverrideTtl;
    private final String blockResponse;
    private final String clientToken;
    private final String confidenceThreshold;
    private final String description;
    private final String dnsAdvancedProtection;
    private final String firewallDomainListId;
    private final String name;
    private final Long priority;
    private final String dnsViewId;
    private final String qType;

    private CreateFirewallRuleRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.blockOverrideDnsType = builder.blockOverrideDnsType;
        this.blockOverrideDomain = builder.blockOverrideDomain;
        this.blockOverrideTtl = builder.blockOverrideTtl;
        this.blockResponse = builder.blockResponse;
        this.clientToken = builder.clientToken;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.description = builder.description;
        this.dnsAdvancedProtection = builder.dnsAdvancedProtection;
        this.firewallDomainListId = builder.firewallDomainListId;
        this.name = builder.name;
        this.priority = builder.priority;
        this.dnsViewId = builder.dnsViewId;
        this.qType = builder.qType;
    }

    public final FirewallRuleAction action() {
        return FirewallRuleAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final BlockOverrideDnsQueryType blockOverrideDnsType() {
        return BlockOverrideDnsQueryType.fromValue(this.blockOverrideDnsType);
    }

    public final String blockOverrideDnsTypeAsString() {
        return this.blockOverrideDnsType;
    }

    public final String blockOverrideDomain() {
        return this.blockOverrideDomain;
    }

    public final Integer blockOverrideTtl() {
        return this.blockOverrideTtl;
    }

    public final FirewallBlockResponse blockResponse() {
        return FirewallBlockResponse.fromValue(this.blockResponse);
    }

    public final String blockResponseAsString() {
        return this.blockResponse;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ConfidenceThreshold confidenceThreshold() {
        return ConfidenceThreshold.fromValue(this.confidenceThreshold);
    }

    public final String confidenceThresholdAsString() {
        return this.confidenceThreshold;
    }

    public final String description() {
        return this.description;
    }

    public final DnsAdvancedProtection dnsAdvancedProtection() {
        return DnsAdvancedProtection.fromValue(this.dnsAdvancedProtection);
    }

    public final String dnsAdvancedProtectionAsString() {
        return this.dnsAdvancedProtection;
    }

    public final String firewallDomainListId() {
        return this.firewallDomainListId;
    }

    public final String name() {
        return this.name;
    }

    public final Long priority() {
        return this.priority;
    }

    public final String dnsViewId() {
        return this.dnsViewId;
    }

    public final String qType() {
        return this.qType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideDnsTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockOverrideTtl());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceThresholdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsAdvancedProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.qType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFirewallRuleRequest)) {
            return false;
        }
        CreateFirewallRuleRequest other = (CreateFirewallRuleRequest)((Object)obj);
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.blockOverrideDnsTypeAsString(), other.blockOverrideDnsTypeAsString()) && Objects.equals(this.blockOverrideDomain(), other.blockOverrideDomain()) && Objects.equals(this.blockOverrideTtl(), other.blockOverrideTtl()) && Objects.equals(this.blockResponseAsString(), other.blockResponseAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.confidenceThresholdAsString(), other.confidenceThresholdAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dnsAdvancedProtectionAsString(), other.dnsAdvancedProtectionAsString()) && Objects.equals(this.firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.dnsViewId(), other.dnsViewId()) && Objects.equals(this.qType(), other.qType());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFirewallRuleRequest").add("Action", (Object)this.actionAsString()).add("BlockOverrideDnsType", (Object)this.blockOverrideDnsTypeAsString()).add("BlockOverrideDomain", (Object)this.blockOverrideDomain()).add("BlockOverrideTtl", (Object)this.blockOverrideTtl()).add("BlockResponse", (Object)this.blockResponseAsString()).add("ClientToken", (Object)this.clientToken()).add("ConfidenceThreshold", (Object)this.confidenceThresholdAsString()).add("Description", (Object)this.description()).add("DnsAdvancedProtection", (Object)this.dnsAdvancedProtectionAsString()).add("FirewallDomainListId", (Object)this.firewallDomainListId()).add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("DnsViewId", (Object)this.dnsViewId()).add("QType", (Object)this.qType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "blockOverrideDnsType": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideDnsTypeAsString()));
            }
            case "blockOverrideDomain": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideDomain()));
            }
            case "blockOverrideTtl": {
                return Optional.ofNullable(clazz.cast(this.blockOverrideTtl()));
            }
            case "blockResponse": {
                return Optional.ofNullable(clazz.cast(this.blockResponseAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "confidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.confidenceThresholdAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "dnsAdvancedProtection": {
                return Optional.ofNullable(clazz.cast(this.dnsAdvancedProtectionAsString()));
            }
            case "firewallDomainListId": {
                return Optional.ofNullable(clazz.cast(this.firewallDomainListId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "dnsViewId": {
                return Optional.ofNullable(clazz.cast(this.dnsViewId()));
            }
            case "qType": {
                return Optional.ofNullable(clazz.cast(this.qType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", ACTION_FIELD);
        map.put("blockOverrideDnsType", BLOCK_OVERRIDE_DNS_TYPE_FIELD);
        map.put("blockOverrideDomain", BLOCK_OVERRIDE_DOMAIN_FIELD);
        map.put("blockOverrideTtl", BLOCK_OVERRIDE_TTL_FIELD);
        map.put("blockResponse", BLOCK_RESPONSE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dnsAdvancedProtection", DNS_ADVANCED_PROTECTION_FIELD);
        map.put("firewallDomainListId", FIREWALL_DOMAIN_LIST_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("qType", Q_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFirewallRuleRequest, T> g) {
        return obj -> g.apply((CreateFirewallRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverRequest.BuilderImpl
    implements Builder {
        private String action;
        private String blockOverrideDnsType;
        private String blockOverrideDomain;
        private Integer blockOverrideTtl;
        private String blockResponse;
        private String clientToken;
        private String confidenceThreshold;
        private String description;
        private String dnsAdvancedProtection;
        private String firewallDomainListId;
        private String name;
        private Long priority;
        private String dnsViewId;
        private String qType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFirewallRuleRequest model) {
            super(model);
            this.action(model.action);
            this.blockOverrideDnsType(model.blockOverrideDnsType);
            this.blockOverrideDomain(model.blockOverrideDomain);
            this.blockOverrideTtl(model.blockOverrideTtl);
            this.blockResponse(model.blockResponse);
            this.clientToken(model.clientToken);
            this.confidenceThreshold(model.confidenceThreshold);
            this.description(model.description);
            this.dnsAdvancedProtection(model.dnsAdvancedProtection);
            this.firewallDomainListId(model.firewallDomainListId);
            this.name(model.name);
            this.priority(model.priority);
            this.dnsViewId(model.dnsViewId);
            this.qType(model.qType);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FirewallRuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBlockOverrideDnsType() {
            return this.blockOverrideDnsType;
        }

        public final void setBlockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
        }

        @Override
        public final Builder blockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
            return this;
        }

        @Override
        public final Builder blockOverrideDnsType(BlockOverrideDnsQueryType blockOverrideDnsType) {
            this.blockOverrideDnsType(blockOverrideDnsType == null ? null : blockOverrideDnsType.toString());
            return this;
        }

        public final String getBlockOverrideDomain() {
            return this.blockOverrideDomain;
        }

        public final void setBlockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
        }

        @Override
        public final Builder blockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
            return this;
        }

        public final Integer getBlockOverrideTtl() {
            return this.blockOverrideTtl;
        }

        public final void setBlockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
        }

        @Override
        public final Builder blockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
            return this;
        }

        public final String getBlockResponse() {
            return this.blockResponse;
        }

        public final void setBlockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
        }

        @Override
        public final Builder blockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
            return this;
        }

        @Override
        public final Builder blockResponse(FirewallBlockResponse blockResponse) {
            this.blockResponse(blockResponse == null ? null : blockResponse.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConfidenceThreshold() {
            return this.confidenceThreshold;
        }

        public final void setConfidenceThreshold(String confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(String confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        @Override
        public final Builder confidenceThreshold(ConfidenceThreshold confidenceThreshold) {
            this.confidenceThreshold(confidenceThreshold == null ? null : confidenceThreshold.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDnsAdvancedProtection() {
            return this.dnsAdvancedProtection;
        }

        public final void setDnsAdvancedProtection(String dnsAdvancedProtection) {
            this.dnsAdvancedProtection = dnsAdvancedProtection;
        }

        @Override
        public final Builder dnsAdvancedProtection(String dnsAdvancedProtection) {
            this.dnsAdvancedProtection = dnsAdvancedProtection;
            return this;
        }

        @Override
        public final Builder dnsAdvancedProtection(DnsAdvancedProtection dnsAdvancedProtection) {
            this.dnsAdvancedProtection(dnsAdvancedProtection == null ? null : dnsAdvancedProtection.toString());
            return this;
        }

        public final String getFirewallDomainListId() {
            return this.firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getPriority() {
            return this.priority;
        }

        public final void setPriority(Long priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Long priority) {
            this.priority = priority;
            return this;
        }

        public final String getDnsViewId() {
            return this.dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final String getQType() {
            return this.qType;
        }

        public final void setQType(String qType) {
            this.qType = qType;
        }

        @Override
        public final Builder qType(String qType) {
            this.qType = qType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFirewallRuleRequest build() {
            return new CreateFirewallRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFirewallRuleRequest> {
        public Builder action(String var1);

        public Builder action(FirewallRuleAction var1);

        public Builder blockOverrideDnsType(String var1);

        public Builder blockOverrideDnsType(BlockOverrideDnsQueryType var1);

        public Builder blockOverrideDomain(String var1);

        public Builder blockOverrideTtl(Integer var1);

        public Builder blockResponse(String var1);

        public Builder blockResponse(FirewallBlockResponse var1);

        public Builder clientToken(String var1);

        public Builder confidenceThreshold(String var1);

        public Builder confidenceThreshold(ConfidenceThreshold var1);

        public Builder description(String var1);

        public Builder dnsAdvancedProtection(String var1);

        public Builder dnsAdvancedProtection(DnsAdvancedProtection var1);

        public Builder firewallDomainListId(String var1);

        public Builder name(String var1);

        public Builder priority(Long var1);

        public Builder dnsViewId(String var1);

        public Builder qType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

