/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalResolverRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<UpdateGlobalResolverRequest.Builder, UpdateGlobalResolverRequest> {
    private static final SdkField<String> GLOBAL_RESOLVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("globalResolverId").getter(getter(UpdateGlobalResolverRequest::globalResolverId))
            .setter(setter(Builder::globalResolverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalResolverId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateGlobalResolverRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OBSERVABILITY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("observabilityRegion").getter(getter(UpdateGlobalResolverRequest::observabilityRegion))
            .setter(setter(Builder::observabilityRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observabilityRegion").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateGlobalResolverRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_RESOLVER_ID_FIELD,
            NAME_FIELD, OBSERVABILITY_REGION_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalResolverId;

    private final String name;

    private final String observabilityRegion;

    private final String description;

    private UpdateGlobalResolverRequest(BuilderImpl builder) {
        super(builder);
        this.globalResolverId = builder.globalResolverId;
        this.name = builder.name;
        this.observabilityRegion = builder.observabilityRegion;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the Global Resolver.
     * </p>
     * 
     * @return The ID of the Global Resolver.
     */
    public final String globalResolverId() {
        return globalResolverId;
    }

    /**
     * <p>
     * The name of the Global Resolver.
     * </p>
     * 
     * @return The name of the Global Resolver.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The AWS Regions in which the users' Global Resolver query resolution logs will be propagated.
     * </p>
     * 
     * @return The AWS Regions in which the users' Global Resolver query resolution logs will be propagated.
     */
    public final String observabilityRegion() {
        return observabilityRegion;
    }

    /**
     * <p>
     * The description of the Global Resolver.
     * </p>
     * 
     * @return The description of the Global Resolver.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityRegion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalResolverRequest)) {
            return false;
        }
        UpdateGlobalResolverRequest other = (UpdateGlobalResolverRequest) obj;
        return Objects.equals(globalResolverId(), other.globalResolverId()) && Objects.equals(name(), other.name())
                && Objects.equals(observabilityRegion(), other.observabilityRegion())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGlobalResolverRequest").add("GlobalResolverId", globalResolverId()).add("Name", name())
                .add("ObservabilityRegion", observabilityRegion()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "globalResolverId":
            return Optional.ofNullable(clazz.cast(globalResolverId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "observabilityRegion":
            return Optional.ofNullable(clazz.cast(observabilityRegion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("globalResolverId", GLOBAL_RESOLVER_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("observabilityRegion", OBSERVABILITY_REGION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalResolverRequest, T> g) {
        return obj -> g.apply((UpdateGlobalResolverRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGlobalResolverRequest> {
        /**
         * <p>
         * The ID of the Global Resolver.
         * </p>
         * 
         * @param globalResolverId
         *        The ID of the Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalResolverId(String globalResolverId);

        /**
         * <p>
         * The name of the Global Resolver.
         * </p>
         * 
         * @param name
         *        The name of the Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The AWS Regions in which the users' Global Resolver query resolution logs will be propagated.
         * </p>
         * 
         * @param observabilityRegion
         *        The AWS Regions in which the users' Global Resolver query resolution logs will be propagated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityRegion(String observabilityRegion);

        /**
         * <p>
         * The description of the Global Resolver.
         * </p>
         * 
         * @param description
         *        The description of the Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private String globalResolverId;

        private String name;

        private String observabilityRegion;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalResolverRequest model) {
            super(model);
            globalResolverId(model.globalResolverId);
            name(model.name);
            observabilityRegion(model.observabilityRegion);
            description(model.description);
        }

        public final String getGlobalResolverId() {
            return globalResolverId;
        }

        public final void setGlobalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
        }

        @Override
        public final Builder globalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getObservabilityRegion() {
            return observabilityRegion;
        }

        public final void setObservabilityRegion(String observabilityRegion) {
            this.observabilityRegion = observabilityRegion;
        }

        @Override
        public final Builder observabilityRegion(String observabilityRegion) {
            this.observabilityRegion = observabilityRegion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalResolverRequest build() {
            return new UpdateGlobalResolverRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
