/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallRulesRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<ListFirewallRulesRequest.Builder, ListFirewallRulesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFirewallRulesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max_results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFirewallRulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next_token").build()).build();

    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsViewId").getter(getter(ListFirewallRulesRequest::dnsViewId)).setter(setter(Builder::dnsViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dnsview_id").build()).build();

    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("filters")
            .getter(getter(ListFirewallRulesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("filters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, DNS_VIEW_ID_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String dnsViewId;

    private final Map<String, List<String>> filters;

    private ListFirewallRulesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.dnsViewId = builder.dnsViewId;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The maximum number of results to retrieve in a single call.
     * </p>
     * 
     * @return The maximum number of results to retrieve in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token used for large sets of results that can't be returned in a single response.
     * </p>
     * 
     * @return A pagination token used for large sets of results that can't be returned in a single response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * ID of the DNS view.
     * </p>
     * 
     * @return ID of the DNS view.
     */
    public final String dnsViewId() {
        return dnsViewId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Values to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Values to filter the results.
     */
    public final Map<String, List<String>> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRulesRequest)) {
            return false;
        }
        ListFirewallRulesRequest other = (ListFirewallRulesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(dnsViewId(), other.dnsViewId()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallRulesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("DnsViewId", dnsViewId()).add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "dnsViewId":
            return Optional.ofNullable(clazz.cast(dnsViewId()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("max_results", MAX_RESULTS_FIELD);
        map.put("next_token", NEXT_TOKEN_FIELD);
        map.put("dnsview_id", DNS_VIEW_ID_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRulesRequest, T> g) {
        return obj -> g.apply((ListFirewallRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFirewallRulesRequest> {
        /**
         * <p>
         * The maximum number of results to retrieve in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to retrieve in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token used for large sets of results that can't be returned in a single response.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used for large sets of results that can't be returned in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * ID of the DNS view.
         * </p>
         * 
         * @param dnsViewId
         *        ID of the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsViewId(String dnsViewId);

        /**
         * <p>
         * Values to filter the results.
         * </p>
         * 
         * @param filters
         *        Values to filter the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Map<String, ? extends Collection<String>> filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String dnsViewId;

        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRulesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            dnsViewId(model.dnsViewId);
            filters(model.filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDnsViewId() {
            return dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            if (filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return filters;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FiltersCopier.copy(filters);
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFirewallRulesRequest build() {
            return new ListFirewallRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
