/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportFirewallDomainsRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<ImportFirewallDomainsRequest.Builder, ImportFirewallDomainsRequest> {
    private static final SdkField<String> DOMAIN_FILE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainFileUrl").getter(getter(ImportFirewallDomainsRequest::domainFileUrl))
            .setter(setter(Builder::domainFileUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainFileUrl").build()).build();

    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firewallDomainListId").getter(getter(ImportFirewallDomainsRequest::firewallDomainListId))
            .setter(setter(Builder::firewallDomainListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("firewallDomainListId").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(ImportFirewallDomainsRequest::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FILE_URL_FIELD,
            FIREWALL_DOMAIN_LIST_ID_FIELD, OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainFileUrl;

    private final String firewallDomainListId;

    private final String operation;

    private ImportFirewallDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.domainFileUrl = builder.domainFileUrl;
        this.firewallDomainListId = builder.firewallDomainListId;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * The fully qualified URL of the file in Amazon S3 that contains the list of domains to import. The file should
     * contain one domain per line.
     * </p>
     * 
     * @return The fully qualified URL of the file in Amazon S3 that contains the list of domains to import. The file
     *         should contain one domain per line.
     */
    public final String domainFileUrl() {
        return domainFileUrl;
    }

    /**
     * <p>
     * ID of the DNS Firewall domain list that you want to import the domain list to.
     * </p>
     * 
     * @return ID of the DNS Firewall domain list that you want to import the domain list to.
     */
    public final String firewallDomainListId() {
        return firewallDomainListId;
    }

    /**
     * <p>
     * This value is <code>REPLACE</code>, and it updates the domain list to match the list of domains in the imported
     * file.
     * </p>
     * 
     * @return This value is <code>REPLACE</code>, and it updates the domain list to match the list of domains in the
     *         imported file.
     */
    public final String operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainFileUrl());
        hashCode = 31 * hashCode + Objects.hashCode(firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportFirewallDomainsRequest)) {
            return false;
        }
        ImportFirewallDomainsRequest other = (ImportFirewallDomainsRequest) obj;
        return Objects.equals(domainFileUrl(), other.domainFileUrl())
                && Objects.equals(firewallDomainListId(), other.firewallDomainListId())
                && Objects.equals(operation(), other.operation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportFirewallDomainsRequest").add("DomainFileUrl", domainFileUrl())
                .add("FirewallDomainListId", firewallDomainListId()).add("Operation", operation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainFileUrl":
            return Optional.ofNullable(clazz.cast(domainFileUrl()));
        case "firewallDomainListId":
            return Optional.ofNullable(clazz.cast(firewallDomainListId()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainFileUrl", DOMAIN_FILE_URL_FIELD);
        map.put("firewallDomainListId", FIREWALL_DOMAIN_LIST_ID_FIELD);
        map.put("operation", OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportFirewallDomainsRequest, T> g) {
        return obj -> g.apply((ImportFirewallDomainsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportFirewallDomainsRequest> {
        /**
         * <p>
         * The fully qualified URL of the file in Amazon S3 that contains the list of domains to import. The file should
         * contain one domain per line.
         * </p>
         * 
         * @param domainFileUrl
         *        The fully qualified URL of the file in Amazon S3 that contains the list of domains to import. The file
         *        should contain one domain per line.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainFileUrl(String domainFileUrl);

        /**
         * <p>
         * ID of the DNS Firewall domain list that you want to import the domain list to.
         * </p>
         * 
         * @param firewallDomainListId
         *        ID of the DNS Firewall domain list that you want to import the domain list to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainListId(String firewallDomainListId);

        /**
         * <p>
         * This value is <code>REPLACE</code>, and it updates the domain list to match the list of domains in the
         * imported file.
         * </p>
         * 
         * @param operation
         *        This value is <code>REPLACE</code>, and it updates the domain list to match the list of domains in the
         *        imported file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private String domainFileUrl;

        private String firewallDomainListId;

        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportFirewallDomainsRequest model) {
            super(model);
            domainFileUrl(model.domainFileUrl);
            firewallDomainListId(model.firewallDomainListId);
            operation(model.operation);
        }

        public final String getDomainFileUrl() {
            return domainFileUrl;
        }

        public final void setDomainFileUrl(String domainFileUrl) {
            this.domainFileUrl = domainFileUrl;
        }

        @Override
        public final Builder domainFileUrl(String domainFileUrl) {
            this.domainFileUrl = domainFileUrl;
            return this;
        }

        public final String getFirewallDomainListId() {
            return firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportFirewallDomainsRequest build() {
            return new ImportFirewallDomainsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
