/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedFirewallDomainListResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<GetManagedFirewallDomainListResponse.Builder, GetManagedFirewallDomainListResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetManagedFirewallDomainListResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetManagedFirewallDomainListResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetManagedFirewallDomainListResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> MANAGED_LIST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedListType").getter(getter(GetManagedFirewallDomainListResponse::managedListType))
            .setter(setter(Builder::managedListType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedListType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ID_FIELD,
            NAME_FIELD, MANAGED_LIST_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String id;

    private final String name;

    private final String managedListType;

    private GetManagedFirewallDomainListResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.managedListType = builder.managedListType;
    }

    /**
     * <p>
     * Description of the Managed Domain List.
     * </p>
     * 
     * @return Description of the Managed Domain List.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * ID of the Managed Domain List.
     * </p>
     * 
     * @return ID of the Managed Domain List.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Name of the Managed Domain List.
     * </p>
     * 
     * @return Name of the Managed Domain List.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Type of the managed category. This is either <code>THREAT</code> or <code>CONTENT</code>.
     * </p>
     * 
     * @return Type of the managed category. This is either <code>THREAT</code> or <code>CONTENT</code>.
     */
    public final String managedListType() {
        return managedListType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(managedListType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedFirewallDomainListResponse)) {
            return false;
        }
        GetManagedFirewallDomainListResponse other = (GetManagedFirewallDomainListResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(managedListType(), other.managedListType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedFirewallDomainListResponse").add("Description", description()).add("Id", id())
                .add("Name", name()).add("ManagedListType", managedListType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "managedListType":
            return Optional.ofNullable(clazz.cast(managedListType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("managedListType", MANAGED_LIST_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedFirewallDomainListResponse, T> g) {
        return obj -> g.apply((GetManagedFirewallDomainListResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetManagedFirewallDomainListResponse> {
        /**
         * <p>
         * Description of the Managed Domain List.
         * </p>
         * 
         * @param description
         *        Description of the Managed Domain List.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * ID of the Managed Domain List.
         * </p>
         * 
         * @param id
         *        ID of the Managed Domain List.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Name of the Managed Domain List.
         * </p>
         * 
         * @param name
         *        Name of the Managed Domain List.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Type of the managed category. This is either <code>THREAT</code> or <code>CONTENT</code>.
         * </p>
         * 
         * @param managedListType
         *        Type of the managed category. This is either <code>THREAT</code> or <code>CONTENT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedListType(String managedListType);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private String description;

        private String id;

        private String name;

        private String managedListType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedFirewallDomainListResponse model) {
            super(model);
            description(model.description);
            id(model.id);
            name(model.name);
            managedListType(model.managedListType);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getManagedListType() {
            return managedListType;
        }

        public final void setManagedListType(String managedListType) {
            this.managedListType = managedListType;
        }

        @Override
        public final Builder managedListType(String managedListType) {
            this.managedListType = managedListType;
            return this;
        }

        @Override
        public GetManagedFirewallDomainListResponse build() {
            return new GetManagedFirewallDomainListResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
