/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHostedZoneAssociationResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<GetHostedZoneAssociationResponse.Builder, GetHostedZoneAssociationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetHostedZoneAssociationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(GetHostedZoneAssociationResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostedZoneId").getter(getter(GetHostedZoneAssociationResponse::hostedZoneId))
            .setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()).build();

    private static final SdkField<String> HOSTED_ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostedZoneName").getter(getter(GetHostedZoneAssociationResponse::hostedZoneName))
            .setter(setter(Builder::hostedZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetHostedZoneAssociationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetHostedZoneAssociationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetHostedZoneAssociationResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetHostedZoneAssociationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_ARN_FIELD,
            HOSTED_ZONE_ID_FIELD, HOSTED_ZONE_NAME_FIELD, NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String resourceArn;

    private final String hostedZoneId;

    private final String hostedZoneName;

    private final String name;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private GetHostedZoneAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.resourceArn = builder.resourceArn;
        this.hostedZoneId = builder.hostedZoneId;
        this.hostedZoneName = builder.hostedZoneName;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * ID of the private hosted zone association.
     * </p>
     * 
     * @return ID of the private hosted zone association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the DNS view the private hosted zone is associated to.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the DNS view the private hosted zone is associated to.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * ID of the hosted zone associated to the DNS view.
     * </p>
     * 
     * @return ID of the hosted zone associated to the DNS view.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * Name of the domain associated with the private hosted zone.
     * </p>
     * 
     * @return Name of the domain associated with the private hosted zone.
     */
    public final String hostedZoneName() {
        return hostedZoneName;
    }

    /**
     * <p>
     * Name of the private hosted zone association.
     * </p>
     * 
     * @return Name of the private hosted zone association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time and date the private hosted zone association was created.
     * </p>
     * 
     * @return The time and date the private hosted zone association was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time and date the private hosted zone association was updated.
     * </p>
     * 
     * @return The time and date the private hosted zone association was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The operational status of the private hosted zone association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HostedZoneAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The operational status of the private hosted zone association.
     * @see HostedZoneAssociationStatus
     */
    public final HostedZoneAssociationStatus status() {
        return HostedZoneAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The operational status of the private hosted zone association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HostedZoneAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The operational status of the private hosted zone association.
     * @see HostedZoneAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneAssociationResponse)) {
            return false;
        }
        GetHostedZoneAssociationResponse other = (GetHostedZoneAssociationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(hostedZoneName(), other.hostedZoneName()) && Objects.equals(name(), other.name())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHostedZoneAssociationResponse").add("Id", id()).add("ResourceArn", resourceArn())
                .add("HostedZoneId", hostedZoneId()).add("HostedZoneName", hostedZoneName()).add("Name", name())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "hostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "hostedZoneName":
            return Optional.ofNullable(clazz.cast(hostedZoneName()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("hostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("hostedZoneName", HOSTED_ZONE_NAME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHostedZoneAssociationResponse, T> g) {
        return obj -> g.apply((GetHostedZoneAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetHostedZoneAssociationResponse> {
        /**
         * <p>
         * ID of the private hosted zone association.
         * </p>
         * 
         * @param id
         *        ID of the private hosted zone association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the DNS view the private hosted zone is associated to.
         * </p>
         * 
         * @param resourceArn
         *        Amazon Resource Name (ARN) of the DNS view the private hosted zone is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * ID of the hosted zone associated to the DNS view.
         * </p>
         * 
         * @param hostedZoneId
         *        ID of the hosted zone associated to the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * Name of the domain associated with the private hosted zone.
         * </p>
         * 
         * @param hostedZoneName
         *        Name of the domain associated with the private hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneName(String hostedZoneName);

        /**
         * <p>
         * Name of the private hosted zone association.
         * </p>
         * 
         * @param name
         *        Name of the private hosted zone association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time and date the private hosted zone association was created.
         * </p>
         * 
         * @param createdAt
         *        The time and date the private hosted zone association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time and date the private hosted zone association was updated.
         * </p>
         * 
         * @param updatedAt
         *        The time and date the private hosted zone association was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The operational status of the private hosted zone association.
         * </p>
         * 
         * @param status
         *        The operational status of the private hosted zone association.
         * @see HostedZoneAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostedZoneAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The operational status of the private hosted zone association.
         * </p>
         * 
         * @param status
         *        The operational status of the private hosted zone association.
         * @see HostedZoneAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostedZoneAssociationStatus
         */
        Builder status(HostedZoneAssociationStatus status);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private String id;

        private String resourceArn;

        private String hostedZoneId;

        private String hostedZoneName;

        private String name;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneAssociationResponse model) {
            super(model);
            id(model.id);
            resourceArn(model.resourceArn);
            hostedZoneId(model.hostedZoneId);
            hostedZoneName(model.hostedZoneName);
            name(model.name);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getHostedZoneName() {
            return hostedZoneName;
        }

        public final void setHostedZoneName(String hostedZoneName) {
            this.hostedZoneName = hostedZoneName;
        }

        @Override
        public final Builder hostedZoneName(String hostedZoneName) {
            this.hostedZoneName = hostedZoneName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HostedZoneAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetHostedZoneAssociationResponse build() {
            return new GetHostedZoneAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
