/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a DNS view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DNSViewSummary implements SdkPojo, Serializable, ToCopyableBuilder<DNSViewSummary.Builder, DNSViewSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DNSViewSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DNSViewSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(DNSViewSummary::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> DNSSEC_VALIDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnssecValidation").getter(getter(DNSViewSummary::dnssecValidationAsString))
            .setter(setter(Builder::dnssecValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnssecValidation").build()).build();

    private static final SdkField<String> EDNS_CLIENT_SUBNET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ednsClientSubnet").getter(getter(DNSViewSummary::ednsClientSubnetAsString))
            .setter(setter(Builder::ednsClientSubnet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ednsClientSubnet").build()).build();

    private static final SdkField<String> FIREWALL_RULES_FAIL_OPEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firewallRulesFailOpen").getter(getter(DNSViewSummary::firewallRulesFailOpenAsString))
            .setter(setter(Builder::firewallRulesFailOpen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRulesFailOpen").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DNSViewSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DNSViewSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> GLOBAL_RESOLVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("globalResolverId").getter(getter(DNSViewSummary::globalResolverId))
            .setter(setter(Builder::globalResolverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalResolverId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(DNSViewSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(DNSViewSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DNSViewSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            CLIENT_TOKEN_FIELD, DNSSEC_VALIDATION_FIELD, EDNS_CLIENT_SUBNET_FIELD, FIREWALL_RULES_FAIL_OPEN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, GLOBAL_RESOLVER_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String clientToken;

    private final String dnssecValidation;

    private final String ednsClientSubnet;

    private final String firewallRulesFailOpen;

    private final String name;

    private final String description;

    private final String globalResolverId;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private DNSViewSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.dnssecValidation = builder.dnssecValidation;
        this.ednsClientSubnet = builder.ednsClientSubnet;
        this.firewallRulesFailOpen = builder.firewallRulesFailOpen;
        this.name = builder.name;
        this.description = builder.description;
        this.globalResolverId = builder.globalResolverId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the DNS view.
     * </p>
     * 
     * @return The unique identifier of the DNS view.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DNS view.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DNS view.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique string that identifies the request and ensures idempotency.
     * </p>
     * 
     * @return The unique string that identifies the request and ensures idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Whether DNSSEC validation is enabled for the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnssecValidation}
     * will return {@link DnsSecValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dnssecValidationAsString}.
     * </p>
     * 
     * @return Whether DNSSEC validation is enabled for the DNS view.
     * @see DnsSecValidationType
     */
    public final DnsSecValidationType dnssecValidation() {
        return DnsSecValidationType.fromValue(dnssecValidation);
    }

    /**
     * <p>
     * Whether DNSSEC validation is enabled for the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnssecValidation}
     * will return {@link DnsSecValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dnssecValidationAsString}.
     * </p>
     * 
     * @return Whether DNSSEC validation is enabled for the DNS view.
     * @see DnsSecValidationType
     */
    public final String dnssecValidationAsString() {
        return dnssecValidation;
    }

    /**
     * <p>
     * Whether EDNS Client Subnet injection is enabled for the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ednsClientSubnet}
     * will return {@link EdnsClientSubnetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ednsClientSubnetAsString}.
     * </p>
     * 
     * @return Whether EDNS Client Subnet injection is enabled for the DNS view.
     * @see EdnsClientSubnetType
     */
    public final EdnsClientSubnetType ednsClientSubnet() {
        return EdnsClientSubnetType.fromValue(ednsClientSubnet);
    }

    /**
     * <p>
     * Whether EDNS Client Subnet injection is enabled for the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ednsClientSubnet}
     * will return {@link EdnsClientSubnetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ednsClientSubnetAsString}.
     * </p>
     * 
     * @return Whether EDNS Client Subnet injection is enabled for the DNS view.
     * @see EdnsClientSubnetType
     */
    public final String ednsClientSubnetAsString() {
        return ednsClientSubnet;
    }

    /**
     * <p>
     * Whether firewall rules fail open when they cannot be evaluated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallRulesFailOpen} will return {@link FirewallRulesFailOpenType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #firewallRulesFailOpenAsString}.
     * </p>
     * 
     * @return Whether firewall rules fail open when they cannot be evaluated.
     * @see FirewallRulesFailOpenType
     */
    public final FirewallRulesFailOpenType firewallRulesFailOpen() {
        return FirewallRulesFailOpenType.fromValue(firewallRulesFailOpen);
    }

    /**
     * <p>
     * Whether firewall rules fail open when they cannot be evaluated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallRulesFailOpen} will return {@link FirewallRulesFailOpenType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #firewallRulesFailOpenAsString}.
     * </p>
     * 
     * @return Whether firewall rules fail open when they cannot be evaluated.
     * @see FirewallRulesFailOpenType
     */
    public final String firewallRulesFailOpenAsString() {
        return firewallRulesFailOpen;
    }

    /**
     * <p>
     * The name of the DNS view.
     * </p>
     * 
     * @return The name of the DNS view.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the DNS view.
     * </p>
     * 
     * @return A description of the DNS view.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the global resolver that the DNS view is associated with.
     * </p>
     * 
     * @return The ID of the global resolver that the DNS view is associated with.
     */
    public final String globalResolverId() {
        return globalResolverId;
    }

    /**
     * <p>
     * The date and time when the DNS view was created.
     * </p>
     * 
     * @return The date and time when the DNS view was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the DNS view was last updated.
     * </p>
     * 
     * @return The date and time when the DNS view was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current status of the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProfileResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the DNS view.
     * @see ProfileResourceStatus
     */
    public final ProfileResourceStatus status() {
        return ProfileResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProfileResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the DNS view.
     * @see ProfileResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dnssecValidationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ednsClientSubnetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firewallRulesFailOpenAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(globalResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DNSViewSummary)) {
            return false;
        }
        DNSViewSummary other = (DNSViewSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dnssecValidationAsString(), other.dnssecValidationAsString())
                && Objects.equals(ednsClientSubnetAsString(), other.ednsClientSubnetAsString())
                && Objects.equals(firewallRulesFailOpenAsString(), other.firewallRulesFailOpenAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(globalResolverId(), other.globalResolverId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DNSViewSummary").add("Id", id()).add("Arn", arn()).add("ClientToken", clientToken())
                .add("DnssecValidation", dnssecValidationAsString()).add("EdnsClientSubnet", ednsClientSubnetAsString())
                .add("FirewallRulesFailOpen", firewallRulesFailOpenAsString()).add("Name", name())
                .add("Description", description()).add("GlobalResolverId", globalResolverId()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "dnssecValidation":
            return Optional.ofNullable(clazz.cast(dnssecValidationAsString()));
        case "ednsClientSubnet":
            return Optional.ofNullable(clazz.cast(ednsClientSubnetAsString()));
        case "firewallRulesFailOpen":
            return Optional.ofNullable(clazz.cast(firewallRulesFailOpenAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "globalResolverId":
            return Optional.ofNullable(clazz.cast(globalResolverId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("dnssecValidation", DNSSEC_VALIDATION_FIELD);
        map.put("ednsClientSubnet", EDNS_CLIENT_SUBNET_FIELD);
        map.put("firewallRulesFailOpen", FIREWALL_RULES_FAIL_OPEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("globalResolverId", GLOBAL_RESOLVER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DNSViewSummary, T> g) {
        return obj -> g.apply((DNSViewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DNSViewSummary> {
        /**
         * <p>
         * The unique identifier of the DNS view.
         * </p>
         * 
         * @param id
         *        The unique identifier of the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DNS view.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique string that identifies the request and ensures idempotency.
         * </p>
         * 
         * @param clientToken
         *        The unique string that identifies the request and ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Whether DNSSEC validation is enabled for the DNS view.
         * </p>
         * 
         * @param dnssecValidation
         *        Whether DNSSEC validation is enabled for the DNS view.
         * @see DnsSecValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSecValidationType
         */
        Builder dnssecValidation(String dnssecValidation);

        /**
         * <p>
         * Whether DNSSEC validation is enabled for the DNS view.
         * </p>
         * 
         * @param dnssecValidation
         *        Whether DNSSEC validation is enabled for the DNS view.
         * @see DnsSecValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSecValidationType
         */
        Builder dnssecValidation(DnsSecValidationType dnssecValidation);

        /**
         * <p>
         * Whether EDNS Client Subnet injection is enabled for the DNS view.
         * </p>
         * 
         * @param ednsClientSubnet
         *        Whether EDNS Client Subnet injection is enabled for the DNS view.
         * @see EdnsClientSubnetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdnsClientSubnetType
         */
        Builder ednsClientSubnet(String ednsClientSubnet);

        /**
         * <p>
         * Whether EDNS Client Subnet injection is enabled for the DNS view.
         * </p>
         * 
         * @param ednsClientSubnet
         *        Whether EDNS Client Subnet injection is enabled for the DNS view.
         * @see EdnsClientSubnetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdnsClientSubnetType
         */
        Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet);

        /**
         * <p>
         * Whether firewall rules fail open when they cannot be evaluated.
         * </p>
         * 
         * @param firewallRulesFailOpen
         *        Whether firewall rules fail open when they cannot be evaluated.
         * @see FirewallRulesFailOpenType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRulesFailOpenType
         */
        Builder firewallRulesFailOpen(String firewallRulesFailOpen);

        /**
         * <p>
         * Whether firewall rules fail open when they cannot be evaluated.
         * </p>
         * 
         * @param firewallRulesFailOpen
         *        Whether firewall rules fail open when they cannot be evaluated.
         * @see FirewallRulesFailOpenType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRulesFailOpenType
         */
        Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen);

        /**
         * <p>
         * The name of the DNS view.
         * </p>
         * 
         * @param name
         *        The name of the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the DNS view.
         * </p>
         * 
         * @param description
         *        A description of the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the global resolver that the DNS view is associated with.
         * </p>
         * 
         * @param globalResolverId
         *        The ID of the global resolver that the DNS view is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalResolverId(String globalResolverId);

        /**
         * <p>
         * The date and time when the DNS view was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the DNS view was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the DNS view was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time when the DNS view was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current status of the DNS view.
         * </p>
         * 
         * @param status
         *        The current status of the DNS view.
         * @see ProfileResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the DNS view.
         * </p>
         * 
         * @param status
         *        The current status of the DNS view.
         * @see ProfileResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileResourceStatus
         */
        Builder status(ProfileResourceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String clientToken;

        private String dnssecValidation;

        private String ednsClientSubnet;

        private String firewallRulesFailOpen;

        private String name;

        private String description;

        private String globalResolverId;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DNSViewSummary model) {
            id(model.id);
            arn(model.arn);
            clientToken(model.clientToken);
            dnssecValidation(model.dnssecValidation);
            ednsClientSubnet(model.ednsClientSubnet);
            firewallRulesFailOpen(model.firewallRulesFailOpen);
            name(model.name);
            description(model.description);
            globalResolverId(model.globalResolverId);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDnssecValidation() {
            return dnssecValidation;
        }

        public final void setDnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
        }

        @Override
        public final Builder dnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
            return this;
        }

        @Override
        public final Builder dnssecValidation(DnsSecValidationType dnssecValidation) {
            this.dnssecValidation(dnssecValidation == null ? null : dnssecValidation.toString());
            return this;
        }

        public final String getEdnsClientSubnet() {
            return ednsClientSubnet;
        }

        public final void setEdnsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
        }

        @Override
        public final Builder ednsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
            return this;
        }

        @Override
        public final Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet) {
            this.ednsClientSubnet(ednsClientSubnet == null ? null : ednsClientSubnet.toString());
            return this;
        }

        public final String getFirewallRulesFailOpen() {
            return firewallRulesFailOpen;
        }

        public final void setFirewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
        }

        @Override
        public final Builder firewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
            return this;
        }

        @Override
        public final Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen) {
            this.firewallRulesFailOpen(firewallRulesFailOpen == null ? null : firewallRulesFailOpen.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGlobalResolverId() {
            return globalResolverId;
        }

        public final void setGlobalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
        }

        @Override
        public final Builder globalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProfileResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DNSViewSummary build() {
            return new DNSViewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
