/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDnsViewRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<CreateDnsViewRequest.Builder, CreateDnsViewRequest> {
    private static final SdkField<String> GLOBAL_RESOLVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("globalResolverId").getter(getter(CreateDnsViewRequest::globalResolverId))
            .setter(setter(Builder::globalResolverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalResolverId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDnsViewRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDnsViewRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DNSSEC_VALIDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnssecValidation").getter(getter(CreateDnsViewRequest::dnssecValidationAsString))
            .setter(setter(Builder::dnssecValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnssecValidation").build()).build();

    private static final SdkField<String> EDNS_CLIENT_SUBNET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ednsClientSubnet").getter(getter(CreateDnsViewRequest::ednsClientSubnetAsString))
            .setter(setter(Builder::ednsClientSubnet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ednsClientSubnet").build()).build();

    private static final SdkField<String> FIREWALL_RULES_FAIL_OPEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firewallRulesFailOpen").getter(getter(CreateDnsViewRequest::firewallRulesFailOpenAsString))
            .setter(setter(Builder::firewallRulesFailOpen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRulesFailOpen").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDnsViewRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDnsViewRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_RESOLVER_ID_FIELD,
            CLIENT_TOKEN_FIELD, NAME_FIELD, DNSSEC_VALIDATION_FIELD, EDNS_CLIENT_SUBNET_FIELD, FIREWALL_RULES_FAIL_OPEN_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalResolverId;

    private final String clientToken;

    private final String name;

    private final String dnssecValidation;

    private final String ednsClientSubnet;

    private final String firewallRulesFailOpen;

    private final String description;

    private final Map<String, String> tags;

    private CreateDnsViewRequest(BuilderImpl builder) {
        super(builder);
        this.globalResolverId = builder.globalResolverId;
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.dnssecValidation = builder.dnssecValidation;
        this.ednsClientSubnet = builder.ednsClientSubnet;
        this.firewallRulesFailOpen = builder.firewallRulesFailOpen;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Route 53 Global Resolver to associate with this DNS view.
     * </p>
     * 
     * @return The ID of the Route 53 Global Resolver to associate with this DNS view.
     */
    public final String globalResolverId() {
        return globalResolverId;
    }

    /**
     * <p>
     * A unique string that identifies the request and ensures idempotency.
     * </p>
     * 
     * @return A unique string that identifies the request and ensures idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A descriptive name for the DNS view.
     * </p>
     * 
     * @return A descriptive name for the DNS view.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Whether to enable DNSSEC validation for DNS queries in this DNS view. When enabled, the resolver verifies the
     * authenticity and integrity of DNS responses from public name servers for DNSSEC-signed domains.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnssecValidation}
     * will return {@link DnsSecValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dnssecValidationAsString}.
     * </p>
     * 
     * @return Whether to enable DNSSEC validation for DNS queries in this DNS view. When enabled, the resolver verifies
     *         the authenticity and integrity of DNS responses from public name servers for DNSSEC-signed domains.
     * @see DnsSecValidationType
     */
    public final DnsSecValidationType dnssecValidation() {
        return DnsSecValidationType.fromValue(dnssecValidation);
    }

    /**
     * <p>
     * Whether to enable DNSSEC validation for DNS queries in this DNS view. When enabled, the resolver verifies the
     * authenticity and integrity of DNS responses from public name servers for DNSSEC-signed domains.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnssecValidation}
     * will return {@link DnsSecValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dnssecValidationAsString}.
     * </p>
     * 
     * @return Whether to enable DNSSEC validation for DNS queries in this DNS view. When enabled, the resolver verifies
     *         the authenticity and integrity of DNS responses from public name servers for DNSSEC-signed domains.
     * @see DnsSecValidationType
     */
    public final String dnssecValidationAsString() {
        return dnssecValidation;
    }

    /**
     * <p>
     * Whether to enable EDNS Client Subnet injection for DNS queries in this DNS view. When enabled, client subnet
     * information is forwarded to provide more accurate geographic-based DNS responses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ednsClientSubnet}
     * will return {@link EdnsClientSubnetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ednsClientSubnetAsString}.
     * </p>
     * 
     * @return Whether to enable EDNS Client Subnet injection for DNS queries in this DNS view. When enabled, client
     *         subnet information is forwarded to provide more accurate geographic-based DNS responses.
     * @see EdnsClientSubnetType
     */
    public final EdnsClientSubnetType ednsClientSubnet() {
        return EdnsClientSubnetType.fromValue(ednsClientSubnet);
    }

    /**
     * <p>
     * Whether to enable EDNS Client Subnet injection for DNS queries in this DNS view. When enabled, client subnet
     * information is forwarded to provide more accurate geographic-based DNS responses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ednsClientSubnet}
     * will return {@link EdnsClientSubnetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ednsClientSubnetAsString}.
     * </p>
     * 
     * @return Whether to enable EDNS Client Subnet injection for DNS queries in this DNS view. When enabled, client
     *         subnet information is forwarded to provide more accurate geographic-based DNS responses.
     * @see EdnsClientSubnetType
     */
    public final String ednsClientSubnetAsString() {
        return ednsClientSubnet;
    }

    /**
     * <p>
     * Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall rules due to service impairment.
     * When enabled, DNS queries are allowed through; when disabled, queries are blocked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallRulesFailOpen} will return {@link FirewallRulesFailOpenType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #firewallRulesFailOpenAsString}.
     * </p>
     * 
     * @return Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall rules due to service
     *         impairment. When enabled, DNS queries are allowed through; when disabled, queries are blocked.
     * @see FirewallRulesFailOpenType
     */
    public final FirewallRulesFailOpenType firewallRulesFailOpen() {
        return FirewallRulesFailOpenType.fromValue(firewallRulesFailOpen);
    }

    /**
     * <p>
     * Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall rules due to service impairment.
     * When enabled, DNS queries are allowed through; when disabled, queries are blocked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallRulesFailOpen} will return {@link FirewallRulesFailOpenType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #firewallRulesFailOpenAsString}.
     * </p>
     * 
     * @return Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall rules due to service
     *         impairment. When enabled, DNS queries are allowed through; when disabled, queries are blocked.
     * @see FirewallRulesFailOpenType
     */
    public final String firewallRulesFailOpenAsString() {
        return firewallRulesFailOpen;
    }

    /**
     * <p>
     * An optional description for the DNS view.
     * </p>
     * 
     * @return An optional description for the DNS view.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to associate with the DNS view.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to associate with the DNS view.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dnssecValidationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ednsClientSubnetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firewallRulesFailOpenAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDnsViewRequest)) {
            return false;
        }
        CreateDnsViewRequest other = (CreateDnsViewRequest) obj;
        return Objects.equals(globalResolverId(), other.globalResolverId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(name(), other.name())
                && Objects.equals(dnssecValidationAsString(), other.dnssecValidationAsString())
                && Objects.equals(ednsClientSubnetAsString(), other.ednsClientSubnetAsString())
                && Objects.equals(firewallRulesFailOpenAsString(), other.firewallRulesFailOpenAsString())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDnsViewRequest").add("GlobalResolverId", globalResolverId())
                .add("ClientToken", clientToken()).add("Name", name()).add("DnssecValidation", dnssecValidationAsString())
                .add("EdnsClientSubnet", ednsClientSubnetAsString())
                .add("FirewallRulesFailOpen", firewallRulesFailOpenAsString()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "globalResolverId":
            return Optional.ofNullable(clazz.cast(globalResolverId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dnssecValidation":
            return Optional.ofNullable(clazz.cast(dnssecValidationAsString()));
        case "ednsClientSubnet":
            return Optional.ofNullable(clazz.cast(ednsClientSubnetAsString()));
        case "firewallRulesFailOpen":
            return Optional.ofNullable(clazz.cast(firewallRulesFailOpenAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("globalResolverId", GLOBAL_RESOLVER_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dnssecValidation", DNSSEC_VALIDATION_FIELD);
        map.put("ednsClientSubnet", EDNS_CLIENT_SUBNET_FIELD);
        map.put("firewallRulesFailOpen", FIREWALL_RULES_FAIL_OPEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDnsViewRequest, T> g) {
        return obj -> g.apply((CreateDnsViewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDnsViewRequest> {
        /**
         * <p>
         * The ID of the Route 53 Global Resolver to associate with this DNS view.
         * </p>
         * 
         * @param globalResolverId
         *        The ID of the Route 53 Global Resolver to associate with this DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalResolverId(String globalResolverId);

        /**
         * <p>
         * A unique string that identifies the request and ensures idempotency.
         * </p>
         * 
         * @param clientToken
         *        A unique string that identifies the request and ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A descriptive name for the DNS view.
         * </p>
         * 
         * @param name
         *        A descriptive name for the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Whether to enable DNSSEC validation for DNS queries in this DNS view. When enabled, the resolver verifies the
         * authenticity and integrity of DNS responses from public name servers for DNSSEC-signed domains.
         * </p>
         * 
         * @param dnssecValidation
         *        Whether to enable DNSSEC validation for DNS queries in this DNS view. When enabled, the resolver
         *        verifies the authenticity and integrity of DNS responses from public name servers for DNSSEC-signed
         *        domains.
         * @see DnsSecValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSecValidationType
         */
        Builder dnssecValidation(String dnssecValidation);

        /**
         * <p>
         * Whether to enable DNSSEC validation for DNS queries in this DNS view. When enabled, the resolver verifies the
         * authenticity and integrity of DNS responses from public name servers for DNSSEC-signed domains.
         * </p>
         * 
         * @param dnssecValidation
         *        Whether to enable DNSSEC validation for DNS queries in this DNS view. When enabled, the resolver
         *        verifies the authenticity and integrity of DNS responses from public name servers for DNSSEC-signed
         *        domains.
         * @see DnsSecValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSecValidationType
         */
        Builder dnssecValidation(DnsSecValidationType dnssecValidation);

        /**
         * <p>
         * Whether to enable EDNS Client Subnet injection for DNS queries in this DNS view. When enabled, client subnet
         * information is forwarded to provide more accurate geographic-based DNS responses.
         * </p>
         * 
         * @param ednsClientSubnet
         *        Whether to enable EDNS Client Subnet injection for DNS queries in this DNS view. When enabled, client
         *        subnet information is forwarded to provide more accurate geographic-based DNS responses.
         * @see EdnsClientSubnetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdnsClientSubnetType
         */
        Builder ednsClientSubnet(String ednsClientSubnet);

        /**
         * <p>
         * Whether to enable EDNS Client Subnet injection for DNS queries in this DNS view. When enabled, client subnet
         * information is forwarded to provide more accurate geographic-based DNS responses.
         * </p>
         * 
         * @param ednsClientSubnet
         *        Whether to enable EDNS Client Subnet injection for DNS queries in this DNS view. When enabled, client
         *        subnet information is forwarded to provide more accurate geographic-based DNS responses.
         * @see EdnsClientSubnetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdnsClientSubnetType
         */
        Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet);

        /**
         * <p>
         * Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall rules due to service
         * impairment. When enabled, DNS queries are allowed through; when disabled, queries are blocked.
         * </p>
         * 
         * @param firewallRulesFailOpen
         *        Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall rules due to service
         *        impairment. When enabled, DNS queries are allowed through; when disabled, queries are blocked.
         * @see FirewallRulesFailOpenType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRulesFailOpenType
         */
        Builder firewallRulesFailOpen(String firewallRulesFailOpen);

        /**
         * <p>
         * Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall rules due to service
         * impairment. When enabled, DNS queries are allowed through; when disabled, queries are blocked.
         * </p>
         * 
         * @param firewallRulesFailOpen
         *        Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall rules due to service
         *        impairment. When enabled, DNS queries are allowed through; when disabled, queries are blocked.
         * @see FirewallRulesFailOpenType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRulesFailOpenType
         */
        Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen);

        /**
         * <p>
         * An optional description for the DNS view.
         * </p>
         * 
         * @param description
         *        An optional description for the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tags to associate with the DNS view.
         * </p>
         * 
         * @param tags
         *        Tags to associate with the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private String globalResolverId;

        private String clientToken;

        private String name;

        private String dnssecValidation;

        private String ednsClientSubnet;

        private String firewallRulesFailOpen;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDnsViewRequest model) {
            super(model);
            globalResolverId(model.globalResolverId);
            clientToken(model.clientToken);
            name(model.name);
            dnssecValidation(model.dnssecValidation);
            ednsClientSubnet(model.ednsClientSubnet);
            firewallRulesFailOpen(model.firewallRulesFailOpen);
            description(model.description);
            tags(model.tags);
        }

        public final String getGlobalResolverId() {
            return globalResolverId;
        }

        public final void setGlobalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
        }

        @Override
        public final Builder globalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDnssecValidation() {
            return dnssecValidation;
        }

        public final void setDnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
        }

        @Override
        public final Builder dnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
            return this;
        }

        @Override
        public final Builder dnssecValidation(DnsSecValidationType dnssecValidation) {
            this.dnssecValidation(dnssecValidation == null ? null : dnssecValidation.toString());
            return this;
        }

        public final String getEdnsClientSubnet() {
            return ednsClientSubnet;
        }

        public final void setEdnsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
        }

        @Override
        public final Builder ednsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
            return this;
        }

        @Override
        public final Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet) {
            this.ednsClientSubnet(ednsClientSubnet == null ? null : ednsClientSubnet.toString());
            return this;
        }

        public final String getFirewallRulesFailOpen() {
            return firewallRulesFailOpen;
        }

        public final void setFirewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
        }

        @Override
        public final Builder firewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
            return this;
        }

        @Override
        public final Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen) {
            this.firewallRulesFailOpen(firewallRulesFailOpen == null ? null : firewallRulesFailOpen.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDnsViewRequest build() {
            return new CreateDnsViewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
