/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of deleting a firewall rule in a batch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteFirewallRuleOutputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteFirewallRuleOutputItem.Builder, BatchDeleteFirewallRuleOutputItem> {
    private static final SdkField<BatchDeleteFirewallRuleResult> FIREWALL_RULE_FIELD = SdkField
            .<BatchDeleteFirewallRuleResult> builder(MarshallingType.SDK_POJO).memberName("firewallRule")
            .getter(getter(BatchDeleteFirewallRuleOutputItem::firewallRule)).setter(setter(Builder::firewallRule))
            .constructor(BatchDeleteFirewallRuleResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRule").build()).build();

    private static final SdkField<Integer> CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("code")
            .getter(getter(BatchDeleteFirewallRuleOutputItem::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchDeleteFirewallRuleOutputItem::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULE_FIELD,
            CODE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BatchDeleteFirewallRuleResult firewallRule;

    private final Integer code;

    private final String message;

    private BatchDeleteFirewallRuleOutputItem(BuilderImpl builder) {
        this.firewallRule = builder.firewallRule;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The firewall rule that was deleted in the batch operation.
     * </p>
     * 
     * @return The firewall rule that was deleted in the batch operation.
     */
    public final BatchDeleteFirewallRuleResult firewallRule() {
        return firewallRule;
    }

    /**
     * <p>
     * The response code for the delete operation.
     * </p>
     * 
     * @return The response code for the delete operation.
     */
    public final Integer code() {
        return code;
    }

    /**
     * <p>
     * The response message for the delete operation.
     * </p>
     * 
     * @return The response message for the delete operation.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firewallRule());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteFirewallRuleOutputItem)) {
            return false;
        }
        BatchDeleteFirewallRuleOutputItem other = (BatchDeleteFirewallRuleOutputItem) obj;
        return Objects.equals(firewallRule(), other.firewallRule()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteFirewallRuleOutputItem").add("FirewallRule", firewallRule()).add("Code", code())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "firewallRule":
            return Optional.ofNullable(clazz.cast(firewallRule()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("firewallRule", FIREWALL_RULE_FIELD);
        map.put("code", CODE_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteFirewallRuleOutputItem, T> g) {
        return obj -> g.apply((BatchDeleteFirewallRuleOutputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteFirewallRuleOutputItem> {
        /**
         * <p>
         * The firewall rule that was deleted in the batch operation.
         * </p>
         * 
         * @param firewallRule
         *        The firewall rule that was deleted in the batch operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRule(BatchDeleteFirewallRuleResult firewallRule);

        /**
         * <p>
         * The firewall rule that was deleted in the batch operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchDeleteFirewallRuleResult.Builder}
         * avoiding the need to create one manually via {@link BatchDeleteFirewallRuleResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchDeleteFirewallRuleResult.Builder#build()} is called
         * immediately and its result is passed to {@link #firewallRule(BatchDeleteFirewallRuleResult)}.
         * 
         * @param firewallRule
         *        a consumer that will call methods on {@link BatchDeleteFirewallRuleResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallRule(BatchDeleteFirewallRuleResult)
         */
        default Builder firewallRule(Consumer<BatchDeleteFirewallRuleResult.Builder> firewallRule) {
            return firewallRule(BatchDeleteFirewallRuleResult.builder().applyMutation(firewallRule).build());
        }

        /**
         * <p>
         * The response code for the delete operation.
         * </p>
         * 
         * @param code
         *        The response code for the delete operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * <p>
         * The response message for the delete operation.
         * </p>
         * 
         * @param message
         *        The response message for the delete operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private BatchDeleteFirewallRuleResult firewallRule;

        private Integer code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteFirewallRuleOutputItem model) {
            firewallRule(model.firewallRule);
            code(model.code);
            message(model.message);
        }

        public final BatchDeleteFirewallRuleResult.Builder getFirewallRule() {
            return firewallRule != null ? firewallRule.toBuilder() : null;
        }

        public final void setFirewallRule(BatchDeleteFirewallRuleResult.BuilderImpl firewallRule) {
            this.firewallRule = firewallRule != null ? firewallRule.build() : null;
        }

        @Override
        public final Builder firewallRule(BatchDeleteFirewallRuleResult firewallRule) {
            this.firewallRule = firewallRule;
            return this;
        }

        public final Integer getCode() {
            return code;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchDeleteFirewallRuleOutputItem build() {
            return new BatchDeleteFirewallRuleOutputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
