/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.route53globalresolver.model.AssociateHostedZoneRequest;
import software.amazon.awssdk.services.route53globalresolver.model.AssociateHostedZoneResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchCreateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchCreateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DisableDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DisableDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DisassociateHostedZoneRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DisassociateHostedZoneResponse;
import software.amazon.awssdk.services.route53globalresolver.model.EnableDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.EnableDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetHostedZoneAssociationRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetHostedZoneAssociationResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetManagedFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetManagedFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ImportFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ImportFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.TagResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.TagResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateHostedZoneAssociationRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateHostedZoneAssociationResponse;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesPublisher;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensPublisher;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsPublisher;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsPublisher;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsPublisher;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesPublisher;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversPublisher;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsPublisher;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsPublisher;

/**
 * Service client for accessing Amazon Route 53 Global Resolver asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Route 53 Global Resolver is a global, internet-accessible DNS resolver that enables customers to resolve and
 * forward traffic for both public and private domains while ensuring security and authenticity of queries over the
 * internet. Route 53 Global Resolver supports DNS-over-port 53 (Do53), DNS-over-TLS (DoT), and DNS-over-HTTPS (DoH)
 * protocols through global anycast IP addresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Route53GlobalResolverAsyncClient extends AwsClient {
    String SERVICE_NAME = "route53globalresolver";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "route53globalresolver";

    /**
     * <p>
     * Associates a Route 53 private hosted zone with a Route 53 Global Resolver resource. This allows the resolver to
     * resolve DNS queries for the private hosted zone from anywhere globally.
     * </p>
     *
     * @param associateHostedZoneRequest
     * @return A Java Future containing the result of the AssociateHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.AssociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/AssociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateHostedZoneResponse> associateHostedZone(
            AssociateHostedZoneRequest associateHostedZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a Route 53 private hosted zone with a Route 53 Global Resolver resource. This allows the resolver to
     * resolve DNS queries for the private hosted zone from anywhere globally.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateHostedZoneRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateHostedZoneRequest#builder()}
     * </p>
     *
     * @param associateHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.AssociateHostedZoneRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.AssociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/AssociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateHostedZoneResponse> associateHostedZone(
            Consumer<AssociateHostedZoneRequest.Builder> associateHostedZoneRequest) {
        return associateHostedZone(AssociateHostedZoneRequest.builder().applyMutation(associateHostedZoneRequest).build());
    }

    /**
     * <p>
     * Creates multiple DNS firewall rules in a single operation. This is more efficient than creating rules
     * individually when you need to set up multiple rules at once.
     * </p>
     *
     * @param batchCreateFirewallRuleRequest
     * @return A Java Future containing the result of the BatchCreateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.BatchCreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchCreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateFirewallRuleResponse> batchCreateFirewallRule(
            BatchCreateFirewallRuleRequest batchCreateFirewallRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates multiple DNS firewall rules in a single operation. This is more efficient than creating rules
     * individually when you need to set up multiple rules at once.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateFirewallRuleRequest.Builder} avoiding
     * the need to create one manually via {@link BatchCreateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param batchCreateFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchCreateFirewallRuleRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchCreateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.BatchCreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchCreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateFirewallRuleResponse> batchCreateFirewallRule(
            Consumer<BatchCreateFirewallRuleRequest.Builder> batchCreateFirewallRuleRequest) {
        return batchCreateFirewallRule(BatchCreateFirewallRuleRequest.builder().applyMutation(batchCreateFirewallRuleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes multiple DNS firewall rules in a single operation. This is more efficient than deleting rules
     * individually.
     * </p>
     *
     * @param batchDeleteFirewallRuleRequest
     * @return A Java Future containing the result of the BatchDeleteFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.BatchDeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchDeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteFirewallRuleResponse> batchDeleteFirewallRule(
            BatchDeleteFirewallRuleRequest batchDeleteFirewallRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes multiple DNS firewall rules in a single operation. This is more efficient than deleting rules
     * individually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteFirewallRuleRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteFirewallRuleRequest#builder()}
     * </p>
     *
     * @param batchDeleteFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchDeleteFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.BatchDeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchDeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteFirewallRuleResponse> batchDeleteFirewallRule(
            Consumer<BatchDeleteFirewallRuleRequest.Builder> batchDeleteFirewallRuleRequest) {
        return batchDeleteFirewallRule(BatchDeleteFirewallRuleRequest.builder().applyMutation(batchDeleteFirewallRuleRequest)
                .build());
    }

    /**
     * <p>
     * Updates multiple DNS firewall rules in a single operation. This is more efficient than updating rules
     * individually.
     * </p>
     *
     * @param batchUpdateFirewallRuleRequest
     * @return A Java Future containing the result of the BatchUpdateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.BatchUpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchUpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateFirewallRuleResponse> batchUpdateFirewallRule(
            BatchUpdateFirewallRuleRequest batchUpdateFirewallRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple DNS firewall rules in a single operation. This is more efficient than updating rules
     * individually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateFirewallRuleRequest.Builder} avoiding
     * the need to create one manually via {@link BatchUpdateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param batchUpdateFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchUpdateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.BatchUpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchUpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateFirewallRuleResponse> batchUpdateFirewallRule(
            Consumer<BatchUpdateFirewallRuleRequest.Builder> batchUpdateFirewallRuleRequest) {
        return batchUpdateFirewallRule(BatchUpdateFirewallRuleRequest.builder().applyMutation(batchUpdateFirewallRuleRequest)
                .build());
    }

    /**
     * <p>
     * Creates an access source for a DNS view. Access sources define IP addresses or CIDR ranges that are allowed to
     * send DNS queries to the Route 53 Global Resolver, along with the permitted DNS protocols.
     * </p>
     *
     * @param createAccessSourceRequest
     * @return A Java Future containing the result of the CreateAccessSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessSourceResponse> createAccessSource(CreateAccessSourceRequest createAccessSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access source for a DNS view. Access sources define IP addresses or CIDR ranges that are allowed to
     * send DNS queries to the Route 53 Global Resolver, along with the permitted DNS protocols.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessSourceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccessSourceRequest#builder()}
     * </p>
     *
     * @param createAccessSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateAccessSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAccessSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessSourceResponse> createAccessSource(
            Consumer<CreateAccessSourceRequest.Builder> createAccessSourceRequest) {
        return createAccessSource(CreateAccessSourceRequest.builder().applyMutation(createAccessSourceRequest).build());
    }

    /**
     * <p>
     * Creates an access token for a DNS view. Access tokens provide token-based authentication for DNS-over-HTTPS (DoH)
     * and DNS-over-TLS (DoT) connections to the Route 53 Global Resolver.
     * </p>
     *
     * @param createAccessTokenRequest
     * @return A Java Future containing the result of the CreateAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessTokenResponse> createAccessToken(CreateAccessTokenRequest createAccessTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access token for a DNS view. Access tokens provide token-based authentication for DNS-over-HTTPS (DoH)
     * and DNS-over-TLS (DoT) connections to the Route 53 Global Resolver.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessTokenRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAccessTokenRequest#builder()}
     * </p>
     *
     * @param createAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateAccessTokenRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessTokenResponse> createAccessToken(
            Consumer<CreateAccessTokenRequest.Builder> createAccessTokenRequest) {
        return createAccessToken(CreateAccessTokenRequest.builder().applyMutation(createAccessTokenRequest).build());
    }

    /**
     * <p>
     * Creates a DNS view within a Route 53 Global Resolver. A DNS view models end users, user groups, networks, and
     * devices, and serves as a parent resource that holds configurations controlling access, authorization, DNS
     * firewall rules, and forwarding rules.
     * </p>
     *
     * @param createDnsViewRequest
     * @return A Java Future containing the result of the CreateDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDnsViewResponse> createDNSView(CreateDnsViewRequest createDnsViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a DNS view within a Route 53 Global Resolver. A DNS view models end users, user groups, networks, and
     * devices, and serves as a parent resource that holds configurations controlling access, authorization, DNS
     * firewall rules, and forwarding rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDnsViewRequest#builder()}
     * </p>
     *
     * @param createDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateDnsViewRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDnsViewResponse> createDNSView(Consumer<CreateDnsViewRequest.Builder> createDnsViewRequest) {
        return createDNSView(CreateDnsViewRequest.builder().applyMutation(createDnsViewRequest).build());
    }

    /**
     * <p>
     * Creates a firewall domain list. Domain lists are reusable sets of domain specifications that you use in DNS
     * firewall rules to allow, block, or alert on DNS queries to specific domains.
     * </p>
     *
     * @param createFirewallDomainListRequest
     * @return A Java Future containing the result of the CreateFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFirewallDomainListResponse> createFirewallDomainList(
            CreateFirewallDomainListRequest createFirewallDomainListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a firewall domain list. Domain lists are reusable sets of domain specifications that you use in DNS
     * firewall rules to allow, block, or alert on DNS queries to specific domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallDomainListRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param createFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallDomainListRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFirewallDomainListResponse> createFirewallDomainList(
            Consumer<CreateFirewallDomainListRequest.Builder> createFirewallDomainListRequest) {
        return createFirewallDomainList(CreateFirewallDomainListRequest.builder().applyMutation(createFirewallDomainListRequest)
                .build());
    }

    /**
     * <p>
     * Creates a DNS firewall rule. Firewall rules define actions (ALLOW, BLOCK, or ALERT) to take on DNS queries that
     * match specified domain lists, managed domain lists, or advanced threat protections.
     * </p>
     *
     * @param createFirewallRuleRequest
     * @return A Java Future containing the result of the CreateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFirewallRuleResponse> createFirewallRule(CreateFirewallRuleRequest createFirewallRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a DNS firewall rule. Firewall rules define actions (ALLOW, BLOCK, or ALERT) to take on DNS queries that
     * match specified domain lists, managed domain lists, or advanced threat protections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param createFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFirewallRuleResponse> createFirewallRule(
            Consumer<CreateFirewallRuleRequest.Builder> createFirewallRuleRequest) {
        return createFirewallRule(CreateFirewallRuleRequest.builder().applyMutation(createFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Creates a new Route 53 Global Resolver instance. A Route 53 Global Resolver is a global, internet-accessible DNS
     * resolver that provides secure DNS resolution for both public and private domains through global anycast IP
     * addresses.
     * </p>
     *
     * @param createGlobalResolverRequest
     * @return A Java Future containing the result of the CreateGlobalResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGlobalResolverResponse> createGlobalResolver(
            CreateGlobalResolverRequest createGlobalResolverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Route 53 Global Resolver instance. A Route 53 Global Resolver is a global, internet-accessible DNS
     * resolver that provides secure DNS resolution for both public and private domains through global anycast IP
     * addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalResolverRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlobalResolverRequest#builder()}
     * </p>
     *
     * @param createGlobalResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateGlobalResolverRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateGlobalResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.CreateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGlobalResolverResponse> createGlobalResolver(
            Consumer<CreateGlobalResolverRequest.Builder> createGlobalResolverRequest) {
        return createGlobalResolver(CreateGlobalResolverRequest.builder().applyMutation(createGlobalResolverRequest).build());
    }

    /**
     * <p>
     * Deletes an access source. This operation cannot be undone.
     * </p>
     *
     * @param deleteAccessSourceRequest
     * @return A Java Future containing the result of the DeleteAccessSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessSourceResponse> deleteAccessSource(DeleteAccessSourceRequest deleteAccessSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access source. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccessSourceRequest#builder()}
     * </p>
     *
     * @param deleteAccessSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAccessSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessSourceResponse> deleteAccessSource(
            Consumer<DeleteAccessSourceRequest.Builder> deleteAccessSourceRequest) {
        return deleteAccessSource(DeleteAccessSourceRequest.builder().applyMutation(deleteAccessSourceRequest).build());
    }

    /**
     * <p>
     * Deletes an access token. This operation cannot be undone.
     * </p>
     *
     * @param deleteAccessTokenRequest
     * @return A Java Future containing the result of the DeleteAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessTokenResponse> deleteAccessToken(DeleteAccessTokenRequest deleteAccessTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access token. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessTokenRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAccessTokenRequest#builder()}
     * </p>
     *
     * @param deleteAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessTokenRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessTokenResponse> deleteAccessToken(
            Consumer<DeleteAccessTokenRequest.Builder> deleteAccessTokenRequest) {
        return deleteAccessToken(DeleteAccessTokenRequest.builder().applyMutation(deleteAccessTokenRequest).build());
    }

    /**
     * <p>
     * Deletes a DNS view. This operation cannot be undone.
     * </p>
     *
     * @param deleteDnsViewRequest
     * @return A Java Future containing the result of the DeleteDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDnsViewResponse> deleteDNSView(DeleteDnsViewRequest deleteDnsViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DNS view. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDnsViewRequest#builder()}
     * </p>
     *
     * @param deleteDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteDnsViewRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDnsViewResponse> deleteDNSView(Consumer<DeleteDnsViewRequest.Builder> deleteDnsViewRequest) {
        return deleteDNSView(DeleteDnsViewRequest.builder().applyMutation(deleteDnsViewRequest).build());
    }

    /**
     * <p>
     * Deletes a firewall domain list. This operation cannot be undone.
     * </p>
     *
     * @param deleteFirewallDomainListRequest
     * @return A Java Future containing the result of the DeleteFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallDomainListResponse> deleteFirewallDomainList(
            DeleteFirewallDomainListRequest deleteFirewallDomainListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a firewall domain list. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallDomainListRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param deleteFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallDomainListRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallDomainListResponse> deleteFirewallDomainList(
            Consumer<DeleteFirewallDomainListRequest.Builder> deleteFirewallDomainListRequest) {
        return deleteFirewallDomainList(DeleteFirewallDomainListRequest.builder().applyMutation(deleteFirewallDomainListRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a DNS firewall rule. This operation cannot be undone.
     * </p>
     *
     * @param deleteFirewallRuleRequest
     * @return A Java Future containing the result of the DeleteFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallRuleResponse> deleteFirewallRule(DeleteFirewallRuleRequest deleteFirewallRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DNS firewall rule. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFirewallRuleRequest#builder()}
     * </p>
     *
     * @param deleteFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFirewallRuleResponse> deleteFirewallRule(
            Consumer<DeleteFirewallRuleRequest.Builder> deleteFirewallRuleRequest) {
        return deleteFirewallRule(DeleteFirewallRuleRequest.builder().applyMutation(deleteFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a Route 53 Global Resolver instance. This operation cannot be undone. All associated DNS views, access
     * sources, tokens, and firewall rules are also deleted.
     * </p>
     *
     * @param deleteGlobalResolverRequest
     * @return A Java Future containing the result of the DeleteGlobalResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGlobalResolverResponse> deleteGlobalResolver(
            DeleteGlobalResolverRequest deleteGlobalResolverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Route 53 Global Resolver instance. This operation cannot be undone. All associated DNS views, access
     * sources, tokens, and firewall rules are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlobalResolverRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlobalResolverRequest#builder()}
     * </p>
     *
     * @param deleteGlobalResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteGlobalResolverRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteGlobalResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DeleteGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGlobalResolverResponse> deleteGlobalResolver(
            Consumer<DeleteGlobalResolverRequest.Builder> deleteGlobalResolverRequest) {
        return deleteGlobalResolver(DeleteGlobalResolverRequest.builder().applyMutation(deleteGlobalResolverRequest).build());
    }

    /**
     * <p>
     * Disables a DNS view, preventing it from serving DNS queries.
     * </p>
     *
     * @param disableDnsViewRequest
     * @return A Java Future containing the result of the DisableDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DisableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDnsViewResponse> disableDNSView(DisableDnsViewRequest disableDnsViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a DNS view, preventing it from serving DNS queries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link DisableDnsViewRequest#builder()}
     * </p>
     *
     * @param disableDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DisableDnsViewRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisableDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DisableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisableDnsViewResponse> disableDNSView(Consumer<DisableDnsViewRequest.Builder> disableDnsViewRequest) {
        return disableDNSView(DisableDnsViewRequest.builder().applyMutation(disableDnsViewRequest).build());
    }

    /**
     * <p>
     * Disassociates a Route 53 private hosted zone from a Route 53 Global Resolver resource.
     * </p>
     *
     * @param disassociateHostedZoneRequest
     * @return A Java Future containing the result of the DisassociateHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DisassociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisassociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateHostedZoneResponse> disassociateHostedZone(
            DisassociateHostedZoneRequest disassociateHostedZoneRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Route 53 private hosted zone from a Route 53 Global Resolver resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateHostedZoneRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateHostedZoneRequest#builder()}
     * </p>
     *
     * @param disassociateHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DisassociateHostedZoneRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateHostedZone operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.DisassociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisassociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateHostedZoneResponse> disassociateHostedZone(
            Consumer<DisassociateHostedZoneRequest.Builder> disassociateHostedZoneRequest) {
        return disassociateHostedZone(DisassociateHostedZoneRequest.builder().applyMutation(disassociateHostedZoneRequest)
                .build());
    }

    /**
     * <p>
     * Enables a disabled DNS view, allowing it to serve DNS queries again.
     * </p>
     *
     * @param enableDnsViewRequest
     * @return A Java Future containing the result of the EnableDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.EnableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/EnableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDnsViewResponse> enableDNSView(EnableDnsViewRequest enableDnsViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables a disabled DNS view, allowing it to serve DNS queries again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link EnableDnsViewRequest#builder()}
     * </p>
     *
     * @param enableDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.EnableDnsViewRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the EnableDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.EnableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/EnableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EnableDnsViewResponse> enableDNSView(Consumer<EnableDnsViewRequest.Builder> enableDnsViewRequest) {
        return enableDNSView(EnableDnsViewRequest.builder().applyMutation(enableDnsViewRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an access source.
     * </p>
     *
     * @param getAccessSourceRequest
     * @return A Java Future containing the result of the GetAccessSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessSourceResponse> getAccessSource(GetAccessSourceRequest getAccessSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an access source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessSourceRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccessSourceRequest#builder()}
     * </p>
     *
     * @param getAccessSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetAccessSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAccessSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessSourceResponse> getAccessSource(
            Consumer<GetAccessSourceRequest.Builder> getAccessSourceRequest) {
        return getAccessSource(GetAccessSourceRequest.builder().applyMutation(getAccessSourceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an access token.
     * </p>
     *
     * @param getAccessTokenRequest
     * @return A Java Future containing the result of the GetAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessTokenResponse> getAccessToken(GetAccessTokenRequest getAccessTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an access token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessTokenRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccessTokenRequest#builder()}
     * </p>
     *
     * @param getAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetAccessTokenRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessTokenResponse> getAccessToken(Consumer<GetAccessTokenRequest.Builder> getAccessTokenRequest) {
        return getAccessToken(GetAccessTokenRequest.builder().applyMutation(getAccessTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a DNS view.
     * </p>
     *
     * @param getDnsViewRequest
     * @return A Java Future containing the result of the GetDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDnsViewResponse> getDNSView(GetDnsViewRequest getDnsViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a DNS view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link GetDnsViewRequest#builder()}
     * </p>
     *
     * @param getDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetDnsViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDnsViewResponse> getDNSView(Consumer<GetDnsViewRequest.Builder> getDnsViewRequest) {
        return getDNSView(GetDnsViewRequest.builder().applyMutation(getDnsViewRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a firewall domain list.
     * </p>
     *
     * @param getFirewallDomainListRequest
     * @return A Java Future containing the result of the GetFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFirewallDomainListResponse> getFirewallDomainList(
            GetFirewallDomainListRequest getFirewallDomainListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a firewall domain list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallDomainListRequest.Builder} avoiding the
     * need to create one manually via {@link GetFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param getFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetFirewallDomainListRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetFirewallDomainList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFirewallDomainListResponse> getFirewallDomainList(
            Consumer<GetFirewallDomainListRequest.Builder> getFirewallDomainListRequest) {
        return getFirewallDomainList(GetFirewallDomainListRequest.builder().applyMutation(getFirewallDomainListRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a DNS firewall rule.
     * </p>
     *
     * @param getFirewallRuleRequest
     * @return A Java Future containing the result of the GetFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFirewallRuleResponse> getFirewallRule(GetFirewallRuleRequest getFirewallRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a DNS firewall rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallRuleRequest.Builder} avoiding the need
     * to create one manually via {@link GetFirewallRuleRequest#builder()}
     * </p>
     *
     * @param getFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetFirewallRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFirewallRuleResponse> getFirewallRule(
            Consumer<GetFirewallRuleRequest.Builder> getFirewallRuleRequest) {
        return getFirewallRule(GetFirewallRuleRequest.builder().applyMutation(getFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a Route 53 Global Resolver instance.
     * </p>
     *
     * @param getGlobalResolverRequest
     * @return A Java Future containing the result of the GetGlobalResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGlobalResolverResponse> getGlobalResolver(GetGlobalResolverRequest getGlobalResolverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a Route 53 Global Resolver instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlobalResolverRequest.Builder} avoiding the need
     * to create one manually via {@link GetGlobalResolverRequest#builder()}
     * </p>
     *
     * @param getGlobalResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetGlobalResolverRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetGlobalResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGlobalResolverResponse> getGlobalResolver(
            Consumer<GetGlobalResolverRequest.Builder> getGlobalResolverRequest) {
        return getGlobalResolver(GetGlobalResolverRequest.builder().applyMutation(getGlobalResolverRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a hosted zone association.
     * </p>
     *
     * @param getHostedZoneAssociationRequest
     * @return A Java Future containing the result of the GetHostedZoneAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetHostedZoneAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHostedZoneAssociationResponse> getHostedZoneAssociation(
            GetHostedZoneAssociationRequest getHostedZoneAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a hosted zone association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHostedZoneAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetHostedZoneAssociationRequest#builder()}
     * </p>
     *
     * @param getHostedZoneAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetHostedZoneAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetHostedZoneAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetHostedZoneAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetHostedZoneAssociationResponse> getHostedZoneAssociation(
            Consumer<GetHostedZoneAssociationRequest.Builder> getHostedZoneAssociationRequest) {
        return getHostedZoneAssociation(GetHostedZoneAssociationRequest.builder().applyMutation(getHostedZoneAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about an AWS-managed firewall domain list. Managed domain lists contain domains associated
     * with malicious activity, content categories, or specific threats.
     * </p>
     *
     * @param getManagedFirewallDomainListRequest
     * @return A Java Future containing the result of the GetManagedFirewallDomainList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetManagedFirewallDomainList
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetManagedFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedFirewallDomainListResponse> getManagedFirewallDomainList(
            GetManagedFirewallDomainListRequest getManagedFirewallDomainListRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an AWS-managed firewall domain list. Managed domain lists contain domains associated
     * with malicious activity, content categories, or specific threats.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedFirewallDomainListRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param getManagedFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetManagedFirewallDomainListRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetManagedFirewallDomainList operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.GetManagedFirewallDomainList
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetManagedFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedFirewallDomainListResponse> getManagedFirewallDomainList(
            Consumer<GetManagedFirewallDomainListRequest.Builder> getManagedFirewallDomainListRequest) {
        return getManagedFirewallDomainList(GetManagedFirewallDomainListRequest.builder()
                .applyMutation(getManagedFirewallDomainListRequest).build());
    }

    /**
     * <p>
     * Imports a list of domains from an Amazon S3 file into a firewall domain list. The file should contain one domain
     * per line.
     * </p>
     *
     * @param importFirewallDomainsRequest
     * @return A Java Future containing the result of the ImportFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ImportFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ImportFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportFirewallDomainsResponse> importFirewallDomains(
            ImportFirewallDomainsRequest importFirewallDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a list of domains from an Amazon S3 file into a firewall domain list. The file should contain one domain
     * per line.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ImportFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param importFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ImportFirewallDomainsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ImportFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ImportFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ImportFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportFirewallDomainsResponse> importFirewallDomains(
            Consumer<ImportFirewallDomainsRequest.Builder> importFirewallDomainsRequest) {
        return importFirewallDomains(ImportFirewallDomainsRequest.builder().applyMutation(importFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all access sources with pagination support.
     * </p>
     *
     * @param listAccessSourcesRequest
     * @return A Java Future containing the result of the ListAccessSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessSourcesResponse> listAccessSources(ListAccessSourcesRequest listAccessSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all access sources with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccessSourcesRequest#builder()}
     * </p>
     *
     * @param listAccessSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAccessSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessSourcesResponse> listAccessSources(
            Consumer<ListAccessSourcesRequest.Builder> listAccessSourcesRequest) {
        return listAccessSources(ListAccessSourcesRequest.builder().applyMutation(listAccessSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessSources(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesPublisher publisher = client.listAccessSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesPublisher publisher = client.listAccessSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessSources(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessSourcesPublisher listAccessSourcesPaginator(ListAccessSourcesRequest listAccessSourcesRequest) {
        return new ListAccessSourcesPublisher(this, listAccessSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessSources(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesPublisher publisher = client.listAccessSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesPublisher publisher = client.listAccessSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessSources(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccessSourcesRequest#builder()}
     * </p>
     *
     * @param listAccessSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessSourcesPublisher listAccessSourcesPaginator(
            Consumer<ListAccessSourcesRequest.Builder> listAccessSourcesRequest) {
        return listAccessSourcesPaginator(ListAccessSourcesRequest.builder().applyMutation(listAccessSourcesRequest).build());
    }

    /**
     * <p>
     * Lists all access tokens for a DNS view with pagination support.
     * </p>
     *
     * @param listAccessTokensRequest
     * @return A Java Future containing the result of the ListAccessTokens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessTokensResponse> listAccessTokens(ListAccessTokensRequest listAccessTokensRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all access tokens for a DNS view with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessTokensRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccessTokensRequest#builder()}
     * </p>
     *
     * @param listAccessTokensRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAccessTokens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessTokensResponse> listAccessTokens(
            Consumer<ListAccessTokensRequest.Builder> listAccessTokensRequest) {
        return listAccessTokens(ListAccessTokensRequest.builder().applyMutation(listAccessTokensRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessTokens(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensPublisher publisher = client.listAccessTokensPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensPublisher publisher = client.listAccessTokensPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessTokens(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessTokensRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessTokensPublisher listAccessTokensPaginator(ListAccessTokensRequest listAccessTokensRequest) {
        return new ListAccessTokensPublisher(this, listAccessTokensRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessTokens(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensPublisher publisher = client.listAccessTokensPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensPublisher publisher = client.listAccessTokensPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessTokens(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessTokensRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccessTokensRequest#builder()}
     * </p>
     *
     * @param listAccessTokensRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessTokensPublisher listAccessTokensPaginator(Consumer<ListAccessTokensRequest.Builder> listAccessTokensRequest) {
        return listAccessTokensPaginator(ListAccessTokensRequest.builder().applyMutation(listAccessTokensRequest).build());
    }

    /**
     * <p>
     * Lists all DNS views for a Route 53 Global Resolver with pagination support.
     * </p>
     *
     * @param listDnsViewsRequest
     * @return A Java Future containing the result of the ListDNSViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDnsViewsResponse> listDNSViews(ListDnsViewsRequest listDnsViewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all DNS views for a Route 53 Global Resolver with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDnsViewsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDnsViewsRequest#builder()}
     * </p>
     *
     * @param listDnsViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListDNSViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDnsViewsResponse> listDNSViews(Consumer<ListDnsViewsRequest.Builder> listDnsViewsRequest) {
        return listDNSViews(ListDnsViewsRequest.builder().applyMutation(listDnsViewsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDNSViews(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsPublisher publisher = client.listDNSViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsPublisher publisher = client.listDNSViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDNSViews(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDnsViewsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDNSViewsPublisher listDNSViewsPaginator(ListDnsViewsRequest listDnsViewsRequest) {
        return new ListDNSViewsPublisher(this, listDnsViewsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDNSViews(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsPublisher publisher = client.listDNSViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsPublisher publisher = client.listDNSViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDNSViews(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDnsViewsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDnsViewsRequest#builder()}
     * </p>
     *
     * @param listDnsViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDNSViewsPublisher listDNSViewsPaginator(Consumer<ListDnsViewsRequest.Builder> listDnsViewsRequest) {
        return listDNSViewsPaginator(ListDnsViewsRequest.builder().applyMutation(listDnsViewsRequest).build());
    }

    /**
     * <p>
     * Lists all firewall domain lists for a Route 53 Global Resolver with pagination support.
     * </p>
     *
     * @param listFirewallDomainListsRequest
     * @return A Java Future containing the result of the ListFirewallDomainLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallDomainListsResponse> listFirewallDomainLists(
            ListFirewallDomainListsRequest listFirewallDomainListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all firewall domain lists for a Route 53 Global Resolver with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainListsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListFirewallDomainLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallDomainListsResponse> listFirewallDomainLists(
            Consumer<ListFirewallDomainListsRequest.Builder> listFirewallDomainListsRequest) {
        return listFirewallDomainLists(ListFirewallDomainListsRequest.builder().applyMutation(listFirewallDomainListsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsPublisher publisher = client.listFirewallDomainListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsPublisher publisher = client.listFirewallDomainListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallDomainListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsPublisher listFirewallDomainListsPaginator(
            ListFirewallDomainListsRequest listFirewallDomainListsRequest) {
        return new ListFirewallDomainListsPublisher(this, listFirewallDomainListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsPublisher publisher = client.listFirewallDomainListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsPublisher publisher = client.listFirewallDomainListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainListsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsPublisher listFirewallDomainListsPaginator(
            Consumer<ListFirewallDomainListsRequest.Builder> listFirewallDomainListsRequest) {
        return listFirewallDomainListsPaginator(ListFirewallDomainListsRequest.builder()
                .applyMutation(listFirewallDomainListsRequest).build());
    }

    /**
     * <p>
     * Lists all the domains in DNS Firewall domain list you have created.
     * </p>
     *
     * @param listFirewallDomainsRequest
     * @return A Java Future containing the result of the ListFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallDomainsResponse> listFirewallDomains(
            ListFirewallDomainsRequest listFirewallDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the domains in DNS Firewall domain list you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallDomainsResponse> listFirewallDomains(
            Consumer<ListFirewallDomainsRequest.Builder> listFirewallDomainsRequest) {
        return listFirewallDomains(ListFirewallDomainsRequest.builder().applyMutation(listFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsPublisher publisher = client.listFirewallDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsPublisher publisher = client.listFirewallDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsPublisher listFirewallDomainsPaginator(ListFirewallDomainsRequest listFirewallDomainsRequest) {
        return new ListFirewallDomainsPublisher(this, listFirewallDomainsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsPublisher publisher = client.listFirewallDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsPublisher publisher = client.listFirewallDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsPublisher listFirewallDomainsPaginator(
            Consumer<ListFirewallDomainsRequest.Builder> listFirewallDomainsRequest) {
        return listFirewallDomainsPaginator(ListFirewallDomainsRequest.builder().applyMutation(listFirewallDomainsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all DNS firewall rules for a DNS view with pagination support.
     * </p>
     *
     * @param listFirewallRulesRequest
     * @return A Java Future containing the result of the ListFirewallRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallRulesResponse> listFirewallRules(ListFirewallRulesRequest listFirewallRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all DNS firewall rules for a DNS view with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListFirewallRulesRequest#builder()}
     * </p>
     *
     * @param listFirewallRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFirewallRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFirewallRulesResponse> listFirewallRules(
            Consumer<ListFirewallRulesRequest.Builder> listFirewallRulesRequest) {
        return listFirewallRules(ListFirewallRulesRequest.builder().applyMutation(listFirewallRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesPublisher publisher = client.listFirewallRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesPublisher publisher = client.listFirewallRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesPublisher listFirewallRulesPaginator(ListFirewallRulesRequest listFirewallRulesRequest) {
        return new ListFirewallRulesPublisher(this, listFirewallRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesPublisher publisher = client.listFirewallRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesPublisher publisher = client.listFirewallRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListFirewallRulesRequest#builder()}
     * </p>
     *
     * @param listFirewallRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesPublisher listFirewallRulesPaginator(
            Consumer<ListFirewallRulesRequest.Builder> listFirewallRulesRequest) {
        return listFirewallRulesPaginator(ListFirewallRulesRequest.builder().applyMutation(listFirewallRulesRequest).build());
    }

    /**
     * <p>
     * Lists all Route 53 Global Resolver instances in your account with pagination support.
     * </p>
     *
     * @param listGlobalResolversRequest
     * @return A Java Future containing the result of the ListGlobalResolvers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGlobalResolversResponse> listGlobalResolvers(
            ListGlobalResolversRequest listGlobalResolversRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Route 53 Global Resolver instances in your account with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGlobalResolversRequest.Builder} avoiding the
     * need to create one manually via {@link ListGlobalResolversRequest#builder()}
     * </p>
     *
     * @param listGlobalResolversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListGlobalResolvers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGlobalResolversResponse> listGlobalResolvers(
            Consumer<ListGlobalResolversRequest.Builder> listGlobalResolversRequest) {
        return listGlobalResolvers(ListGlobalResolversRequest.builder().applyMutation(listGlobalResolversRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGlobalResolvers(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversPublisher publisher = client.listGlobalResolversPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversPublisher publisher = client.listGlobalResolversPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGlobalResolvers(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGlobalResolversRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGlobalResolversPublisher listGlobalResolversPaginator(ListGlobalResolversRequest listGlobalResolversRequest) {
        return new ListGlobalResolversPublisher(this, listGlobalResolversRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGlobalResolvers(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversPublisher publisher = client.listGlobalResolversPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversPublisher publisher = client.listGlobalResolversPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGlobalResolvers(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGlobalResolversRequest.Builder} avoiding the
     * need to create one manually via {@link ListGlobalResolversRequest#builder()}
     * </p>
     *
     * @param listGlobalResolversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGlobalResolversPublisher listGlobalResolversPaginator(
            Consumer<ListGlobalResolversRequest.Builder> listGlobalResolversRequest) {
        return listGlobalResolversPaginator(ListGlobalResolversRequest.builder().applyMutation(listGlobalResolversRequest)
                .build());
    }

    /**
     * <p>
     * Lists all hosted zone associations for a Route 53 Global Resolver resource with pagination support.
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     * @return A Java Future containing the result of the ListHostedZoneAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHostedZoneAssociationsResponse> listHostedZoneAssociations(
            ListHostedZoneAssociationsRequest listHostedZoneAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all hosted zone associations for a Route 53 Global Resolver resource with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedZoneAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListHostedZoneAssociationsRequest#builder()}
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListHostedZoneAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListHostedZoneAssociationsResponse> listHostedZoneAssociations(
            Consumer<ListHostedZoneAssociationsRequest.Builder> listHostedZoneAssociationsRequest) {
        return listHostedZoneAssociations(ListHostedZoneAssociationsRequest.builder()
                .applyMutation(listHostedZoneAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHostedZoneAssociations(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsPublisher publisher = client.listHostedZoneAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsPublisher publisher = client.listHostedZoneAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedZoneAssociations(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostedZoneAssociationsPublisher listHostedZoneAssociationsPaginator(
            ListHostedZoneAssociationsRequest listHostedZoneAssociationsRequest) {
        return new ListHostedZoneAssociationsPublisher(this, listHostedZoneAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHostedZoneAssociations(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsPublisher publisher = client.listHostedZoneAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsPublisher publisher = client.listHostedZoneAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedZoneAssociations(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedZoneAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListHostedZoneAssociationsRequest#builder()}
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostedZoneAssociationsPublisher listHostedZoneAssociationsPaginator(
            Consumer<ListHostedZoneAssociationsRequest.Builder> listHostedZoneAssociationsRequest) {
        return listHostedZoneAssociationsPaginator(ListHostedZoneAssociationsRequest.builder()
                .applyMutation(listHostedZoneAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of the AWS Managed DNS Lists and the categories for DNS Firewall. The categories are
     * either <code>THREAT</code> or <code>CONTENT</code>.
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     * @return A Java Future containing the result of the ListManagedFirewallDomainLists operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedFirewallDomainListsResponse> listManagedFirewallDomainLists(
            ListManagedFirewallDomainListsRequest listManagedFirewallDomainListsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of the AWS Managed DNS Lists and the categories for DNS Firewall. The categories are
     * either <code>THREAT</code> or <code>CONTENT</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedFirewallDomainListsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListManagedFirewallDomainLists operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListManagedFirewallDomainListsResponse> listManagedFirewallDomainLists(
            Consumer<ListManagedFirewallDomainListsRequest.Builder> listManagedFirewallDomainListsRequest) {
        return listManagedFirewallDomainLists(ListManagedFirewallDomainListsRequest.builder()
                .applyMutation(listManagedFirewallDomainListsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsPublisher publisher = client.listManagedFirewallDomainListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsPublisher publisher = client.listManagedFirewallDomainListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedFirewallDomainListsPublisher listManagedFirewallDomainListsPaginator(
            ListManagedFirewallDomainListsRequest listManagedFirewallDomainListsRequest) {
        return new ListManagedFirewallDomainListsPublisher(this, listManagedFirewallDomainListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsPublisher publisher = client.listManagedFirewallDomainListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsPublisher publisher = client.listManagedFirewallDomainListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedFirewallDomainListsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedFirewallDomainListsPublisher listManagedFirewallDomainListsPaginator(
            Consumer<ListManagedFirewallDomainListsRequest.Builder> listManagedFirewallDomainListsRequest) {
        return listManagedFirewallDomainListsPaginator(ListManagedFirewallDomainListsRequest.builder()
                .applyMutation(listManagedFirewallDomainListsRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with a Route 53 Global Resolver resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with a Route 53 Global Resolver resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a Route 53 Global Resolver resource. Tags are key-value pairs that help you organize and
     * identify your resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a Route 53 Global Resolver resource. Tags are key-value pairs that help you organize and
     * identify your resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a Route 53 Global Resolver resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a Route 53 Global Resolver resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an access source.
     * </p>
     *
     * @param updateAccessSourceRequest
     * @return A Java Future containing the result of the UpdateAccessSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessSourceResponse> updateAccessSource(UpdateAccessSourceRequest updateAccessSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an access source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessSourceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccessSourceRequest#builder()}
     * </p>
     *
     * @param updateAccessSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessSourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAccessSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>ServiceQuotaExceededException The request would exceed one or more service quotas. Check your current
     *         usage and quotas, then try again.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessSourceResponse> updateAccessSource(
            Consumer<UpdateAccessSourceRequest.Builder> updateAccessSourceRequest) {
        return updateAccessSource(UpdateAccessSourceRequest.builder().applyMutation(updateAccessSourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an access token.
     * </p>
     *
     * @param updateAccessTokenRequest
     * @return A Java Future containing the result of the UpdateAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessTokenResponse> updateAccessToken(UpdateAccessTokenRequest updateAccessTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an access token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessTokenRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAccessTokenRequest#builder()}
     * </p>
     *
     * @param updateAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessTokenRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessTokenResponse> updateAccessToken(
            Consumer<UpdateAccessTokenRequest.Builder> updateAccessTokenRequest) {
        return updateAccessToken(UpdateAccessTokenRequest.builder().applyMutation(updateAccessTokenRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a DNS view.
     * </p>
     *
     * @param updateDnsViewRequest
     * @return A Java Future containing the result of the UpdateDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDnsViewResponse> updateDNSView(UpdateDnsViewRequest updateDnsViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a DNS view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDnsViewRequest#builder()}
     * </p>
     *
     * @param updateDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateDnsViewRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateDNSView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDnsViewResponse> updateDNSView(Consumer<UpdateDnsViewRequest.Builder> updateDnsViewRequest) {
        return updateDNSView(UpdateDnsViewRequest.builder().applyMutation(updateDnsViewRequest).build());
    }

    /**
     * <p>
     * Updates a DNS Firewall domain list from an array of specified domains.
     * </p>
     *
     * @param updateFirewallDomainsRequest
     * @return A Java Future containing the result of the UpdateFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallDomainsResponse> updateFirewallDomains(
            UpdateFirewallDomainsRequest updateFirewallDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a DNS Firewall domain list from an array of specified domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param updateFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallDomainsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateFirewallDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallDomainsResponse> updateFirewallDomains(
            Consumer<UpdateFirewallDomainsRequest.Builder> updateFirewallDomainsRequest) {
        return updateFirewallDomains(UpdateFirewallDomainsRequest.builder().applyMutation(updateFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a DNS firewall rule.
     * </p>
     *
     * @param updateFirewallRuleRequest
     * @return A Java Future containing the result of the UpdateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallRuleResponse> updateFirewallRule(UpdateFirewallRuleRequest updateFirewallRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a DNS firewall rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param updateFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallRuleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateFirewallRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFirewallRuleResponse> updateFirewallRule(
            Consumer<UpdateFirewallRuleRequest.Builder> updateFirewallRuleRequest) {
        return updateFirewallRule(UpdateFirewallRuleRequest.builder().applyMutation(updateFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a Route 53 Global Resolver instance. You can modify the name, description, and
     * observability region.
     * </p>
     *
     * @param updateGlobalResolverRequest
     * @return A Java Future containing the result of the UpdateGlobalResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalResolverResponse> updateGlobalResolver(
            UpdateGlobalResolverRequest updateGlobalResolverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a Route 53 Global Resolver instance. You can modify the name, description, and
     * observability region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalResolverRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalResolverRequest#builder()}
     * </p>
     *
     * @param updateGlobalResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateGlobalResolverRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateGlobalResolver operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalResolverResponse> updateGlobalResolver(
            Consumer<UpdateGlobalResolverRequest.Builder> updateGlobalResolverRequest) {
        return updateGlobalResolver(UpdateGlobalResolverRequest.builder().applyMutation(updateGlobalResolverRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a hosted zone association.
     * </p>
     *
     * @param updateHostedZoneAssociationRequest
     * @return A Java Future containing the result of the UpdateHostedZoneAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateHostedZoneAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHostedZoneAssociationResponse> updateHostedZoneAssociation(
            UpdateHostedZoneAssociationRequest updateHostedZoneAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a hosted zone association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHostedZoneAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateHostedZoneAssociationRequest#builder()}
     * </p>
     *
     * @param updateHostedZoneAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateHostedZoneAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateHostedZoneAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Try again later.</li>
     *         <li>ValidationException The input parameters are invalid. Check the parameter values and try again.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. This can occur when
     *         trying to modify a resource that is not in a valid state for the requested operation.</li>
     *         <li>AccessDeniedException You don't have permission to perform this operation. Check your IAM permissions
     *         and try again.</li>
     *         <li>ThrottlingException The request was throttled due to too many requests. Wait a moment and try again.</li>
     *         <li>ResourceNotFoundException The specified resource was not found. Verify the resource ID and try again.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Route53GlobalResolverException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample Route53GlobalResolverAsyncClient.UpdateHostedZoneAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateHostedZoneAssociationResponse> updateHostedZoneAssociation(
            Consumer<UpdateHostedZoneAssociationRequest.Builder> updateHostedZoneAssociationRequest) {
        return updateHostedZoneAssociation(UpdateHostedZoneAssociationRequest.builder()
                .applyMutation(updateHostedZoneAssociationRequest).build());
    }

    @Override
    default Route53GlobalResolverServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link Route53GlobalResolverAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53GlobalResolverAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53GlobalResolverAsyncClient}.
     */
    static Route53GlobalResolverAsyncClientBuilder builder() {
        return new DefaultRoute53GlobalResolverAsyncClientBuilder();
    }
}
