/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.route53globalresolver.internal.Route53GlobalResolverServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.route53globalresolver.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.route53globalresolver.model.AccessDeniedException;
import software.amazon.awssdk.services.route53globalresolver.model.AssociateHostedZoneRequest;
import software.amazon.awssdk.services.route53globalresolver.model.AssociateHostedZoneResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchCreateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchCreateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ConflictException;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DisableDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DisableDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DisassociateHostedZoneRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DisassociateHostedZoneResponse;
import software.amazon.awssdk.services.route53globalresolver.model.EnableDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.EnableDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetHostedZoneAssociationRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetHostedZoneAssociationResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetManagedFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetManagedFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ImportFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ImportFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.InternalServerException;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ResourceNotFoundException;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverException;
import software.amazon.awssdk.services.route53globalresolver.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.route53globalresolver.model.TagResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.TagResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ThrottlingException;
import software.amazon.awssdk.services.route53globalresolver.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateHostedZoneAssociationRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateHostedZoneAssociationResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ValidationException;
import software.amazon.awssdk.services.route53globalresolver.transform.AssociateHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.BatchCreateFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.BatchDeleteFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.BatchUpdateFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.CreateAccessSourceRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.CreateAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.CreateDnsViewRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.CreateFirewallDomainListRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.CreateFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.CreateGlobalResolverRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.DeleteAccessSourceRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.DeleteAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.DeleteDnsViewRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.DeleteFirewallDomainListRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.DeleteFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.DeleteGlobalResolverRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.DisableDnsViewRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.DisassociateHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.EnableDnsViewRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.GetAccessSourceRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.GetAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.GetDnsViewRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.GetFirewallDomainListRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.GetFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.GetGlobalResolverRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.GetHostedZoneAssociationRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.GetManagedFirewallDomainListRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ImportFirewallDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListAccessSourcesRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListAccessTokensRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListDnsViewsRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListFirewallDomainListsRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListFirewallDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListFirewallRulesRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListGlobalResolversRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListHostedZoneAssociationsRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListManagedFirewallDomainListsRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.UpdateAccessSourceRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.UpdateAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.UpdateDnsViewRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.UpdateFirewallDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.UpdateFirewallRuleRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.UpdateGlobalResolverRequestMarshaller;
import software.amazon.awssdk.services.route53globalresolver.transform.UpdateHostedZoneAssociationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link Route53GlobalResolverClient}.
 *
 * @see Route53GlobalResolverClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRoute53GlobalResolverClient implements Route53GlobalResolverClient {
    private static final Logger log = Logger.loggerFor(DefaultRoute53GlobalResolverClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53GlobalResolverClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Route53GlobalResolver" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a Route 53 private hosted zone with a Route 53 Global Resolver resource. This allows the resolver to
     * resolve DNS queries for the private hosted zone from anywhere globally.
     * </p>
     *
     * @param associateHostedZoneRequest
     * @return Result of the AssociateHostedZone operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.AssociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/AssociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateHostedZoneResponse associateHostedZone(AssociateHostedZoneRequest associateHostedZoneRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateHostedZoneResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateHostedZoneResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateHostedZoneRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateHostedZoneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateHostedZone");

            return clientHandler.execute(new ClientExecutionParams<AssociateHostedZoneRequest, AssociateHostedZoneResponse>()
                    .withOperationName("AssociateHostedZone").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateHostedZoneRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateHostedZoneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates multiple DNS firewall rules in a single operation. This is more efficient than creating rules
     * individually when you need to set up multiple rules at once.
     * </p>
     *
     * @param batchCreateFirewallRuleRequest
     * @return Result of the BatchCreateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchCreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchCreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateFirewallRuleResponse batchCreateFirewallRule(BatchCreateFirewallRuleRequest batchCreateFirewallRuleRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreateFirewallRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchCreateFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateFirewallRule");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchCreateFirewallRuleRequest, BatchCreateFirewallRuleResponse>()
                            .withOperationName("BatchCreateFirewallRule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchCreateFirewallRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchCreateFirewallRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes multiple DNS firewall rules in a single operation. This is more efficient than deleting rules
     * individually.
     * </p>
     *
     * @param batchDeleteFirewallRuleRequest
     * @return Result of the BatchDeleteFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchDeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchDeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDeleteFirewallRuleResponse batchDeleteFirewallRule(BatchDeleteFirewallRuleRequest batchDeleteFirewallRuleRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteFirewallRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteFirewallRule");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteFirewallRuleRequest, BatchDeleteFirewallRuleResponse>()
                            .withOperationName("BatchDeleteFirewallRule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDeleteFirewallRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDeleteFirewallRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates multiple DNS firewall rules in a single operation. This is more efficient than updating rules
     * individually.
     * </p>
     *
     * @param batchUpdateFirewallRuleRequest
     * @return Result of the BatchUpdateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchUpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchUpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchUpdateFirewallRuleResponse batchUpdateFirewallRule(BatchUpdateFirewallRuleRequest batchUpdateFirewallRuleRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateFirewallRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdateFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateFirewallRule");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateFirewallRuleRequest, BatchUpdateFirewallRuleResponse>()
                            .withOperationName("BatchUpdateFirewallRule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchUpdateFirewallRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchUpdateFirewallRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an access source for a DNS view. Access sources define IP addresses or CIDR ranges that are allowed to
     * send DNS queries to the Route 53 Global Resolver, along with the permitted DNS protocols.
     * </p>
     *
     * @param createAccessSourceRequest
     * @return Result of the CreateAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccessSourceResponse createAccessSource(CreateAccessSourceRequest createAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccessSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccessSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessSource");

            return clientHandler.execute(new ClientExecutionParams<CreateAccessSourceRequest, CreateAccessSourceResponse>()
                    .withOperationName("CreateAccessSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAccessSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAccessSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an access token for a DNS view. Access tokens provide token-based authentication for DNS-over-HTTPS (DoH)
     * and DNS-over-TLS (DoT) connections to the Route 53 Global Resolver.
     * </p>
     *
     * @param createAccessTokenRequest
     * @return Result of the CreateAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccessTokenResponse createAccessToken(CreateAccessTokenRequest createAccessTokenRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccessTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAccessTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccessTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessToken");

            return clientHandler.execute(new ClientExecutionParams<CreateAccessTokenRequest, CreateAccessTokenResponse>()
                    .withOperationName("CreateAccessToken").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAccessTokenRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAccessTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a DNS view within a Route 53 Global Resolver. A DNS view models end users, user groups, networks, and
     * devices, and serves as a parent resource that holds configurations controlling access, authorization, DNS
     * firewall rules, and forwarding rules.
     * </p>
     *
     * @param createDnsViewRequest
     * @return Result of the CreateDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDnsViewResponse createDNSView(CreateDnsViewRequest createDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDnsViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDnsViewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDnsViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDnsViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDNSView");

            return clientHandler.execute(new ClientExecutionParams<CreateDnsViewRequest, CreateDnsViewResponse>()
                    .withOperationName("CreateDNSView").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDnsViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDnsViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a firewall domain list. Domain lists are reusable sets of domain specifications that you use in DNS
     * firewall rules to allow, block, or alert on DNS queries to specific domains.
     * </p>
     *
     * @param createFirewallDomainListRequest
     * @return Result of the CreateFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFirewallDomainListResponse createFirewallDomainList(
            CreateFirewallDomainListRequest createFirewallDomainListRequest) throws InternalServerException, ValidationException,
            ConflictException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFirewallDomainListResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFirewallDomainListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallDomainListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallDomainListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewallDomainList");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFirewallDomainListRequest, CreateFirewallDomainListResponse>()
                            .withOperationName("CreateFirewallDomainList").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createFirewallDomainListRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateFirewallDomainListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a DNS firewall rule. Firewall rules define actions (ALLOW, BLOCK, or ALERT) to take on DNS queries that
     * match specified domain lists, managed domain lists, or advanced threat protections.
     * </p>
     *
     * @param createFirewallRuleRequest
     * @return Result of the CreateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFirewallRuleResponse createFirewallRule(CreateFirewallRuleRequest createFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFirewallRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFirewallRule");

            return clientHandler.execute(new ClientExecutionParams<CreateFirewallRuleRequest, CreateFirewallRuleResponse>()
                    .withOperationName("CreateFirewallRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFirewallRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFirewallRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Route 53 Global Resolver instance. A Route 53 Global Resolver is a global, internet-accessible DNS
     * resolver that provides secure DNS resolution for both public and private domains through global anycast IP
     * addresses.
     * </p>
     *
     * @param createGlobalResolverRequest
     * @return Result of the CreateGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGlobalResolverResponse createGlobalResolver(CreateGlobalResolverRequest createGlobalResolverRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGlobalResolverResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateGlobalResolverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGlobalResolverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGlobalResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGlobalResolver");

            return clientHandler.execute(new ClientExecutionParams<CreateGlobalResolverRequest, CreateGlobalResolverResponse>()
                    .withOperationName("CreateGlobalResolver").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createGlobalResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGlobalResolverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an access source. This operation cannot be undone.
     * </p>
     *
     * @param deleteAccessSourceRequest
     * @return Result of the DeleteAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccessSourceResponse deleteAccessSource(DeleteAccessSourceRequest deleteAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccessSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccessSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessSource");

            return clientHandler.execute(new ClientExecutionParams<DeleteAccessSourceRequest, DeleteAccessSourceResponse>()
                    .withOperationName("DeleteAccessSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAccessSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAccessSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an access token. This operation cannot be undone.
     * </p>
     *
     * @param deleteAccessTokenRequest
     * @return Result of the DeleteAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccessTokenResponse deleteAccessToken(DeleteAccessTokenRequest deleteAccessTokenRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccessTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAccessTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessToken");

            return clientHandler.execute(new ClientExecutionParams<DeleteAccessTokenRequest, DeleteAccessTokenResponse>()
                    .withOperationName("DeleteAccessToken").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAccessTokenRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAccessTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a DNS view. This operation cannot be undone.
     * </p>
     *
     * @param deleteDnsViewRequest
     * @return Result of the DeleteDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDnsViewResponse deleteDNSView(DeleteDnsViewRequest deleteDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDnsViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDnsViewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDnsViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDnsViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDNSView");

            return clientHandler.execute(new ClientExecutionParams<DeleteDnsViewRequest, DeleteDnsViewResponse>()
                    .withOperationName("DeleteDNSView").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDnsViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDnsViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a firewall domain list. This operation cannot be undone.
     * </p>
     *
     * @param deleteFirewallDomainListRequest
     * @return Result of the DeleteFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFirewallDomainListResponse deleteFirewallDomainList(
            DeleteFirewallDomainListRequest deleteFirewallDomainListRequest) throws InternalServerException, ValidationException,
            ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFirewallDomainListResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFirewallDomainListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallDomainListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallDomainListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewallDomainList");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFirewallDomainListRequest, DeleteFirewallDomainListResponse>()
                            .withOperationName("DeleteFirewallDomainList").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteFirewallDomainListRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFirewallDomainListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a DNS firewall rule. This operation cannot be undone.
     * </p>
     *
     * @param deleteFirewallRuleRequest
     * @return Result of the DeleteFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFirewallRuleResponse deleteFirewallRule(DeleteFirewallRuleRequest deleteFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFirewallRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFirewallRule");

            return clientHandler.execute(new ClientExecutionParams<DeleteFirewallRuleRequest, DeleteFirewallRuleResponse>()
                    .withOperationName("DeleteFirewallRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFirewallRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFirewallRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Route 53 Global Resolver instance. This operation cannot be undone. All associated DNS views, access
     * sources, tokens, and firewall rules are also deleted.
     * </p>
     *
     * @param deleteGlobalResolverRequest
     * @return Result of the DeleteGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGlobalResolverResponse deleteGlobalResolver(DeleteGlobalResolverRequest deleteGlobalResolverRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGlobalResolverResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteGlobalResolverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGlobalResolverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGlobalResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGlobalResolver");

            return clientHandler.execute(new ClientExecutionParams<DeleteGlobalResolverRequest, DeleteGlobalResolverResponse>()
                    .withOperationName("DeleteGlobalResolver").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteGlobalResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGlobalResolverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables a DNS view, preventing it from serving DNS queries.
     * </p>
     *
     * @param disableDnsViewRequest
     * @return Result of the DisableDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DisableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisableDnsViewResponse disableDNSView(DisableDnsViewRequest disableDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableDnsViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisableDnsViewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableDnsViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableDnsViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableDNSView");

            return clientHandler.execute(new ClientExecutionParams<DisableDnsViewRequest, DisableDnsViewResponse>()
                    .withOperationName("DisableDNSView").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disableDnsViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableDnsViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a Route 53 private hosted zone from a Route 53 Global Resolver resource.
     * </p>
     *
     * @param disassociateHostedZoneRequest
     * @return Result of the DisassociateHostedZone operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DisassociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisassociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateHostedZoneResponse disassociateHostedZone(DisassociateHostedZoneRequest disassociateHostedZoneRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateHostedZoneResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateHostedZoneResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateHostedZoneRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateHostedZoneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateHostedZone");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateHostedZoneRequest, DisassociateHostedZoneResponse>()
                            .withOperationName("DisassociateHostedZone").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateHostedZoneRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateHostedZoneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables a disabled DNS view, allowing it to serve DNS queries again.
     * </p>
     *
     * @param enableDnsViewRequest
     * @return Result of the EnableDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.EnableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/EnableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public EnableDnsViewResponse enableDNSView(EnableDnsViewRequest enableDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableDnsViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                EnableDnsViewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableDnsViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableDnsViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableDNSView");

            return clientHandler.execute(new ClientExecutionParams<EnableDnsViewRequest, EnableDnsViewResponse>()
                    .withOperationName("EnableDNSView").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(enableDnsViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EnableDnsViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an access source.
     * </p>
     *
     * @param getAccessSourceRequest
     * @return Result of the GetAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAccessSourceResponse getAccessSource(GetAccessSourceRequest getAccessSourceRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccessSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAccessSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessSource");

            return clientHandler.execute(new ClientExecutionParams<GetAccessSourceRequest, GetAccessSourceResponse>()
                    .withOperationName("GetAccessSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAccessSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccessSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an access token.
     * </p>
     *
     * @param getAccessTokenRequest
     * @return Result of the GetAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAccessTokenResponse getAccessToken(GetAccessTokenRequest getAccessTokenRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccessTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAccessTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessTokenRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessToken");

            return clientHandler.execute(new ClientExecutionParams<GetAccessTokenRequest, GetAccessTokenResponse>()
                    .withOperationName("GetAccessToken").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAccessTokenRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccessTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a DNS view.
     * </p>
     *
     * @param getDnsViewRequest
     * @return Result of the GetDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDnsViewResponse getDNSView(GetDnsViewRequest getDnsViewRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDnsViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDnsViewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDnsViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDnsViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDNSView");

            return clientHandler.execute(new ClientExecutionParams<GetDnsViewRequest, GetDnsViewResponse>()
                    .withOperationName("GetDNSView").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getDnsViewRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDnsViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a firewall domain list.
     * </p>
     *
     * @param getFirewallDomainListRequest
     * @return Result of the GetFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFirewallDomainListResponse getFirewallDomainList(GetFirewallDomainListRequest getFirewallDomainListRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFirewallDomainListResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFirewallDomainListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFirewallDomainListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFirewallDomainListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFirewallDomainList");

            return clientHandler.execute(new ClientExecutionParams<GetFirewallDomainListRequest, GetFirewallDomainListResponse>()
                    .withOperationName("GetFirewallDomainList").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getFirewallDomainListRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFirewallDomainListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a DNS firewall rule.
     * </p>
     *
     * @param getFirewallRuleRequest
     * @return Result of the GetFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFirewallRuleResponse getFirewallRule(GetFirewallRuleRequest getFirewallRuleRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFirewallRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFirewallRule");

            return clientHandler.execute(new ClientExecutionParams<GetFirewallRuleRequest, GetFirewallRuleResponse>()
                    .withOperationName("GetFirewallRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getFirewallRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFirewallRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a Route 53 Global Resolver instance.
     * </p>
     *
     * @param getGlobalResolverRequest
     * @return Result of the GetGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGlobalResolverResponse getGlobalResolver(GetGlobalResolverRequest getGlobalResolverRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGlobalResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGlobalResolverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGlobalResolverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGlobalResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGlobalResolver");

            return clientHandler.execute(new ClientExecutionParams<GetGlobalResolverRequest, GetGlobalResolverResponse>()
                    .withOperationName("GetGlobalResolver").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getGlobalResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGlobalResolverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a hosted zone association.
     * </p>
     *
     * @param getHostedZoneAssociationRequest
     * @return Result of the GetHostedZoneAssociation operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetHostedZoneAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetHostedZoneAssociationResponse getHostedZoneAssociation(
            GetHostedZoneAssociationRequest getHostedZoneAssociationRequest) throws InternalServerException, ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetHostedZoneAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetHostedZoneAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getHostedZoneAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getHostedZoneAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetHostedZoneAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetHostedZoneAssociationRequest, GetHostedZoneAssociationResponse>()
                            .withOperationName("GetHostedZoneAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getHostedZoneAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetHostedZoneAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an AWS-managed firewall domain list. Managed domain lists contain domains associated
     * with malicious activity, content categories, or specific threats.
     * </p>
     *
     * @param getManagedFirewallDomainListRequest
     * @return Result of the GetManagedFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetManagedFirewallDomainList
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetManagedFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetManagedFirewallDomainListResponse getManagedFirewallDomainList(
            GetManagedFirewallDomainListRequest getManagedFirewallDomainListRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetManagedFirewallDomainListResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetManagedFirewallDomainListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getManagedFirewallDomainListRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getManagedFirewallDomainListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetManagedFirewallDomainList");

            return clientHandler
                    .execute(new ClientExecutionParams<GetManagedFirewallDomainListRequest, GetManagedFirewallDomainListResponse>()
                            .withOperationName("GetManagedFirewallDomainList").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getManagedFirewallDomainListRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetManagedFirewallDomainListRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports a list of domains from an Amazon S3 file into a firewall domain list. The file should contain one domain
     * per line.
     * </p>
     *
     * @param importFirewallDomainsRequest
     * @return Result of the ImportFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ImportFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ImportFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportFirewallDomainsResponse importFirewallDomains(ImportFirewallDomainsRequest importFirewallDomainsRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportFirewallDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportFirewallDomainsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importFirewallDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importFirewallDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportFirewallDomains");

            return clientHandler.execute(new ClientExecutionParams<ImportFirewallDomainsRequest, ImportFirewallDomainsResponse>()
                    .withOperationName("ImportFirewallDomains").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importFirewallDomainsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportFirewallDomainsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all access sources with pagination support.
     * </p>
     *
     * @param listAccessSourcesRequest
     * @return Result of the ListAccessSources operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccessSourcesResponse listAccessSources(ListAccessSourcesRequest listAccessSourcesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccessSourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAccessSourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessSources");

            return clientHandler.execute(new ClientExecutionParams<ListAccessSourcesRequest, ListAccessSourcesResponse>()
                    .withOperationName("ListAccessSources").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAccessSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAccessSourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all access tokens for a DNS view with pagination support.
     * </p>
     *
     * @param listAccessTokensRequest
     * @return Result of the ListAccessTokens operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccessTokensResponse listAccessTokens(ListAccessTokensRequest listAccessTokensRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccessTokensResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAccessTokensResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessTokensRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessTokensRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessTokens");

            return clientHandler.execute(new ClientExecutionParams<ListAccessTokensRequest, ListAccessTokensResponse>()
                    .withOperationName("ListAccessTokens").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAccessTokensRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAccessTokensRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all DNS views for a Route 53 Global Resolver with pagination support.
     * </p>
     *
     * @param listDnsViewsRequest
     * @return Result of the ListDNSViews operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDnsViewsResponse listDNSViews(ListDnsViewsRequest listDnsViewsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDnsViewsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDnsViewsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDnsViewsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDnsViewsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDNSViews");

            return clientHandler.execute(new ClientExecutionParams<ListDnsViewsRequest, ListDnsViewsResponse>()
                    .withOperationName("ListDNSViews").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDnsViewsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDnsViewsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all firewall domain lists for a Route 53 Global Resolver with pagination support.
     * </p>
     *
     * @param listFirewallDomainListsRequest
     * @return Result of the ListFirewallDomainLists operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFirewallDomainListsResponse listFirewallDomainLists(ListFirewallDomainListsRequest listFirewallDomainListsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFirewallDomainListsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFirewallDomainListsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallDomainListsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallDomainListsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallDomainLists");

            return clientHandler
                    .execute(new ClientExecutionParams<ListFirewallDomainListsRequest, ListFirewallDomainListsResponse>()
                            .withOperationName("ListFirewallDomainLists").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listFirewallDomainListsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListFirewallDomainListsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the domains in DNS Firewall domain list you have created.
     * </p>
     *
     * @param listFirewallDomainsRequest
     * @return Result of the ListFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFirewallDomainsResponse listFirewallDomains(ListFirewallDomainsRequest listFirewallDomainsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFirewallDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFirewallDomainsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallDomains");

            return clientHandler.execute(new ClientExecutionParams<ListFirewallDomainsRequest, ListFirewallDomainsResponse>()
                    .withOperationName("ListFirewallDomains").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFirewallDomainsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFirewallDomainsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all DNS firewall rules for a DNS view with pagination support.
     * </p>
     *
     * @param listFirewallRulesRequest
     * @return Result of the ListFirewallRules operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFirewallRulesResponse listFirewallRules(ListFirewallRulesRequest listFirewallRulesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFirewallRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFirewallRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFirewallRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFirewallRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFirewallRules");

            return clientHandler.execute(new ClientExecutionParams<ListFirewallRulesRequest, ListFirewallRulesResponse>()
                    .withOperationName("ListFirewallRules").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFirewallRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFirewallRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Route 53 Global Resolver instances in your account with pagination support.
     * </p>
     *
     * @param listGlobalResolversRequest
     * @return Result of the ListGlobalResolvers operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGlobalResolversResponse listGlobalResolvers(ListGlobalResolversRequest listGlobalResolversRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGlobalResolversResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListGlobalResolversResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGlobalResolversRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGlobalResolversRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGlobalResolvers");

            return clientHandler.execute(new ClientExecutionParams<ListGlobalResolversRequest, ListGlobalResolversResponse>()
                    .withOperationName("ListGlobalResolvers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGlobalResolversRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGlobalResolversRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all hosted zone associations for a Route 53 Global Resolver resource with pagination support.
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     * @return Result of the ListHostedZoneAssociations operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListHostedZoneAssociationsResponse listHostedZoneAssociations(
            ListHostedZoneAssociationsRequest listHostedZoneAssociationsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListHostedZoneAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListHostedZoneAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listHostedZoneAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listHostedZoneAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListHostedZoneAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListHostedZoneAssociationsRequest, ListHostedZoneAssociationsResponse>()
                            .withOperationName("ListHostedZoneAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listHostedZoneAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListHostedZoneAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a paginated list of the AWS Managed DNS Lists and the categories for DNS Firewall. The categories are
     * either <code>THREAT</code> or <code>CONTENT</code>.
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     * @return Result of the ListManagedFirewallDomainLists operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListManagedFirewallDomainListsResponse listManagedFirewallDomainLists(
            ListManagedFirewallDomainListsRequest listManagedFirewallDomainListsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListManagedFirewallDomainListsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListManagedFirewallDomainListsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedFirewallDomainListsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listManagedFirewallDomainListsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedFirewallDomainLists");

            return clientHandler
                    .execute(new ClientExecutionParams<ListManagedFirewallDomainListsRequest, ListManagedFirewallDomainListsResponse>()
                            .withOperationName("ListManagedFirewallDomainLists").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listManagedFirewallDomainListsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListManagedFirewallDomainListsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags associated with a Route 53 Global Resolver resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates tags for a Route 53 Global Resolver resource. Tags are key-value pairs that help you organize and
     * identify your resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from a Route 53 Global Resolver resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an access source.
     * </p>
     *
     * @param updateAccessSourceRequest
     * @return Result of the UpdateAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccessSourceResponse updateAccessSource(UpdateAccessSourceRequest updateAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccessSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAccessSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccessSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccessSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccessSource");

            return clientHandler.execute(new ClientExecutionParams<UpdateAccessSourceRequest, UpdateAccessSourceResponse>()
                    .withOperationName("UpdateAccessSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAccessSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAccessSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of an access token.
     * </p>
     *
     * @param updateAccessTokenRequest
     * @return Result of the UpdateAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccessTokenResponse updateAccessToken(UpdateAccessTokenRequest updateAccessTokenRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccessTokenResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAccessTokenResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccessTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccessTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccessToken");

            return clientHandler.execute(new ClientExecutionParams<UpdateAccessTokenRequest, UpdateAccessTokenResponse>()
                    .withOperationName("UpdateAccessToken").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAccessTokenRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAccessTokenRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of a DNS view.
     * </p>
     *
     * @param updateDnsViewRequest
     * @return Result of the UpdateDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDnsViewResponse updateDNSView(UpdateDnsViewRequest updateDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDnsViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDnsViewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDnsViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDnsViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDNSView");

            return clientHandler.execute(new ClientExecutionParams<UpdateDnsViewRequest, UpdateDnsViewResponse>()
                    .withOperationName("UpdateDNSView").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDnsViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDnsViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a DNS Firewall domain list from an array of specified domains.
     * </p>
     *
     * @param updateFirewallDomainsRequest
     * @return Result of the UpdateFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFirewallDomainsResponse updateFirewallDomains(UpdateFirewallDomainsRequest updateFirewallDomainsRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFirewallDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFirewallDomainsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallDomains");

            return clientHandler.execute(new ClientExecutionParams<UpdateFirewallDomainsRequest, UpdateFirewallDomainsResponse>()
                    .withOperationName("UpdateFirewallDomains").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFirewallDomainsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFirewallDomainsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of a DNS firewall rule.
     * </p>
     *
     * @param updateFirewallRuleRequest
     * @return Result of the UpdateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFirewallRuleResponse updateFirewallRule(UpdateFirewallRuleRequest updateFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFirewallRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFirewallRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFirewallRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFirewallRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFirewallRule");

            return clientHandler.execute(new ClientExecutionParams<UpdateFirewallRuleRequest, UpdateFirewallRuleResponse>()
                    .withOperationName("UpdateFirewallRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFirewallRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFirewallRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of a Route 53 Global Resolver instance. You can modify the name, description, and
     * observability region.
     * </p>
     *
     * @param updateGlobalResolverRequest
     * @return Result of the UpdateGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGlobalResolverResponse updateGlobalResolver(UpdateGlobalResolverRequest updateGlobalResolverRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGlobalResolverResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateGlobalResolverResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGlobalResolverRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGlobalResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGlobalResolver");

            return clientHandler.execute(new ClientExecutionParams<UpdateGlobalResolverRequest, UpdateGlobalResolverResponse>()
                    .withOperationName("UpdateGlobalResolver").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateGlobalResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGlobalResolverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of a hosted zone association.
     * </p>
     *
     * @param updateHostedZoneAssociationRequest
     * @return Result of the UpdateHostedZoneAssociation operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateHostedZoneAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateHostedZoneAssociationResponse updateHostedZoneAssociation(
            UpdateHostedZoneAssociationRequest updateHostedZoneAssociationRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateHostedZoneAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateHostedZoneAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateHostedZoneAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateHostedZoneAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Route53GlobalResolver");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateHostedZoneAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateHostedZoneAssociationRequest, UpdateHostedZoneAssociationResponse>()
                            .withOperationName("UpdateHostedZoneAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateHostedZoneAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateHostedZoneAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        Route53GlobalResolverServiceClientConfigurationBuilder serviceConfigBuilder = new Route53GlobalResolverServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(Route53GlobalResolverException::builder).protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1");
    }

    @Override
    public final Route53GlobalResolverServiceClientConfiguration serviceClientConfiguration() {
        return new Route53GlobalResolverServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
