/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FirewallRuleAction {
    ALLOW("ALLOW"),
    ALERT("ALERT"),
    BLOCK("BLOCK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FirewallRuleAction> VALUE_MAP;
    private final String value;

    private FirewallRuleAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FirewallRuleAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FirewallRuleAction> knownValues() {
        EnumSet<FirewallRuleAction> knownValues = EnumSet.allOf(FirewallRuleAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FirewallRuleAction.class, FirewallRuleAction::toString);
    }
}

