/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverAsyncClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse;

public class ListFirewallDomainsPublisher
implements SdkPublisher<ListFirewallDomainsResponse> {
    private final Route53GlobalResolverAsyncClient client;
    private final ListFirewallDomainsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFirewallDomainsPublisher(Route53GlobalResolverAsyncClient client, ListFirewallDomainsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFirewallDomainsPublisher(Route53GlobalResolverAsyncClient client, ListFirewallDomainsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFirewallDomainsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFirewallDomainsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> domains() {
        Function<ListFirewallDomainsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domains() != null) {
                return response.domains().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFirewallDomainsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFirewallDomainsResponseFetcher
    implements AsyncPageFetcher<ListFirewallDomainsResponse> {
        private ListFirewallDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFirewallDomainsResponse> nextPage(ListFirewallDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallDomainsPublisher.this.client.listFirewallDomains(ListFirewallDomainsPublisher.this.firstRequest);
            }
            return ListFirewallDomainsPublisher.this.client.listFirewallDomains((ListFirewallDomainsRequest)((Object)ListFirewallDomainsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

