/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.GlobalResolversCopier;
import software.amazon.awssdk.services.route53globalresolver.model.GlobalResolversItem;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGlobalResolversResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, ListGlobalResolversResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGlobalResolversResponse.getter(ListGlobalResolversResponse::nextToken)).setter(ListGlobalResolversResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<GlobalResolversItem>> GLOBAL_RESOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("globalResolvers").getter(ListGlobalResolversResponse.getter(ListGlobalResolversResponse::globalResolvers)).setter(ListGlobalResolversResponse.setter(Builder::globalResolvers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalResolvers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalResolversItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, GLOBAL_RESOLVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGlobalResolversResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<GlobalResolversItem> globalResolvers;

    private ListGlobalResolversResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.globalResolvers = builder.globalResolvers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasGlobalResolvers() {
        return this.globalResolvers != null && !(this.globalResolvers instanceof SdkAutoConstructList);
    }

    public final List<GlobalResolversItem> globalResolvers() {
        return this.globalResolvers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalResolvers() ? this.globalResolvers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGlobalResolversResponse)) {
            return false;
        }
        ListGlobalResolversResponse other = (ListGlobalResolversResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasGlobalResolvers() == other.hasGlobalResolvers() && Objects.equals(this.globalResolvers(), other.globalResolvers());
    }

    public final String toString() {
        return ToString.builder((String)"ListGlobalResolversResponse").add("NextToken", (Object)this.nextToken()).add("GlobalResolvers", this.hasGlobalResolvers() ? this.globalResolvers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "globalResolvers": {
                return Optional.ofNullable(clazz.cast(this.globalResolvers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("globalResolvers", GLOBAL_RESOLVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGlobalResolversResponse, T> g) {
        return obj -> g.apply((ListGlobalResolversResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<GlobalResolversItem> globalResolvers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGlobalResolversResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.globalResolvers(model.globalResolvers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<GlobalResolversItem.Builder> getGlobalResolvers() {
            List<GlobalResolversItem.Builder> result = GlobalResolversCopier.copyToBuilder(this.globalResolvers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalResolvers(Collection<GlobalResolversItem.BuilderImpl> globalResolvers) {
            this.globalResolvers = GlobalResolversCopier.copyFromBuilder(globalResolvers);
        }

        @Override
        public final Builder globalResolvers(Collection<GlobalResolversItem> globalResolvers) {
            this.globalResolvers = GlobalResolversCopier.copy(globalResolvers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalResolvers(GlobalResolversItem ... globalResolvers) {
            this.globalResolvers(Arrays.asList(globalResolvers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalResolvers(Consumer<GlobalResolversItem.Builder> ... globalResolvers) {
            this.globalResolvers(Stream.of(globalResolvers).map(c -> (GlobalResolversItem)((GlobalResolversItem.Builder)GlobalResolversItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListGlobalResolversResponse build() {
            return new ListGlobalResolversResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGlobalResolversResponse> {
        public Builder nextToken(String var1);

        public Builder globalResolvers(Collection<GlobalResolversItem> var1);

        public Builder globalResolvers(GlobalResolversItem ... var1);

        public Builder globalResolvers(Consumer<GlobalResolversItem.Builder> ... var1);
    }
}

