/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.Nameserver;
import software.amazon.awssdk.services.route53domains.model.NameserverListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainNameserversRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, UpdateDomainNameserversRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameserversRequest.getter(UpdateDomainNameserversRequest::domainName)).setter(UpdateDomainNameserversRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> FI_AUTH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameserversRequest.getter(UpdateDomainNameserversRequest::fiAuthKey)).setter(UpdateDomainNameserversRequest.setter(Builder::fiAuthKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FIAuthKey").build()}).build();
    private static final SdkField<List<Nameserver>> NAMESERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateDomainNameserversRequest.getter(UpdateDomainNameserversRequest::nameservers)).setter(UpdateDomainNameserversRequest.setter(Builder::nameservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nameservers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Nameserver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, FI_AUTH_KEY_FIELD, NAMESERVERS_FIELD));
    private final String domainName;
    private final String fiAuthKey;
    private final List<Nameserver> nameservers;

    private UpdateDomainNameserversRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.fiAuthKey = builder.fiAuthKey;
        this.nameservers = builder.nameservers;
    }

    public String domainName() {
        return this.domainName;
    }

    public String fiAuthKey() {
        return this.fiAuthKey;
    }

    public List<Nameserver> nameservers() {
        return this.nameservers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fiAuthKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameservers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainNameserversRequest)) {
            return false;
        }
        UpdateDomainNameserversRequest other = (UpdateDomainNameserversRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.fiAuthKey(), other.fiAuthKey()) && Objects.equals(this.nameservers(), other.nameservers());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDomainNameserversRequest").add("DomainName", (Object)this.domainName()).add("FIAuthKey", (Object)this.fiAuthKey()).add("Nameservers", this.nameservers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "FIAuthKey": {
                return Optional.ofNullable(clazz.cast(this.fiAuthKey()));
            }
            case "Nameservers": {
                return Optional.ofNullable(clazz.cast(this.nameservers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainNameserversRequest, T> g) {
        return obj -> g.apply((UpdateDomainNameserversRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String fiAuthKey;
        private List<Nameserver> nameservers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainNameserversRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.fiAuthKey(model.fiAuthKey);
            this.nameservers(model.nameservers);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getFiAuthKey() {
            return this.fiAuthKey;
        }

        @Override
        public final Builder fiAuthKey(String fiAuthKey) {
            this.fiAuthKey = fiAuthKey;
            return this;
        }

        public final void setFiAuthKey(String fiAuthKey) {
            this.fiAuthKey = fiAuthKey;
        }

        public final Collection<Nameserver.Builder> getNameservers() {
            return this.nameservers != null ? (Collection)this.nameservers.stream().map(Nameserver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Consumer<Nameserver.Builder> ... nameservers) {
            this.nameservers(Stream.of(nameservers).map(c -> (Nameserver)((Nameserver.Builder)Nameserver.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNameservers(Collection<Nameserver.BuilderImpl> nameservers) {
            this.nameservers = NameserverListCopier.copyFromBuilder(nameservers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainNameserversRequest build() {
            return new UpdateDomainNameserversRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainNameserversRequest> {
        public Builder domainName(String var1);

        public Builder fiAuthKey(String var1);

        public Builder nameservers(Collection<Nameserver> var1);

        public Builder nameservers(Nameserver ... var1);

        public Builder nameservers(Consumer<Nameserver.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

